//	Zinc Application Framework - Z_KEY.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_KEY_HPP)
#define Z_KEY_HPP
#include <z_env.hpp>

// --------------------------------------------------------------------------
// ----- ZafKeyStruct -------------------------------------------------------
// --------------------------------------------------------------------------
// --- event.type is E_KEY
// --- event.rawCode is the key shift state (high byte) and scan code (low byte)
// --- event.key contains the key shift-state and character code

// --- shiftState ---
const ZafRawCode S_SHIFT				= 0x0003;	// left- or right-shift
const ZafRawCode S_RIGHT_SHIFT			= 0x0001;
const ZafRawCode S_LEFT_SHIFT			= 0x0002;
const ZafRawCode S_CTRL					= 0x0004;
const ZafRawCode S_ALT					= 0x0008;
const ZafRawCode S_CMD					= S_ALT;
const ZafRawCode S_SCROLL_LOCK			= 0x0010;
const ZafRawCode S_NUM_LOCK				= 0x0020;
const ZafRawCode S_CAPS_LOCK			= 0x0040;
const ZafRawCode S_INSERT				= 0x0080;
const ZafRawCode S_OPT					= 0x0100;

const ZafRawCode S_KEYDOWN				= 0x0200;
const ZafRawCode S_KEYUP				= 0x0400;
const ZafRawCode S_DOUBLE_CLICK			= 0x0800;

struct ZAF_EXPORT ZafKeyStruct
{
	ZafRawCode shiftState;
	ZafIChar value;
};

#endif // Z_KEY_HPP

