//	Zinc Application Framework - Z_INT.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_INT_HPP)
#define Z_INT_HPP
#include <z_fdata.hpp>
#include <z_stdarg.hpp>

// --------------------------------------------------------------------------
// ----- ZafIntegerData -----------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafIntegerData : public ZafFormatData
{
public:
	// -- General members ---
	ZafIntegerData(void);
	ZafIntegerData(long value);
	ZafIntegerData(const ZafIChar *string, const ZafIChar *format = ZAF_NULLP(ZafIChar));
	ZafIntegerData(const ZafIntegerData &copy);
	virtual ~ZafIntegerData(void);

	// --- Persistence ---
	ZafIntegerData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	virtual int FormattedText(ZafIChar *buffer, int maxLength, const ZafIChar *format = 0) const;
	long Value(void) const;
	// set
	virtual void Clear(void);
	virtual ZafError SetInteger(long value);
	virtual ZafError SetInteger(const ZafIChar *buffer, const ZafIChar *format);
	virtual ZafError SetInteger(const ZafIntegerData &integer);

	// --- Operators ---
	operator long() { return value; }

	ZafIntegerData operator++(void);
	ZafIntegerData operator++(int);
	ZafIntegerData operator--(void);
	ZafIntegerData operator--(int);

	ZafIntegerData &operator=(long value);
	ZafIntegerData &operator+=(long value);
	ZafIntegerData &operator-=(long value);
	ZafIntegerData &operator*=(long value);
	ZafIntegerData &operator/=(long value);
	ZafIntegerData &operator%=(long value);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafFormatData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafFormatData::IsA(compareName)); }

protected:
	// --- Persistence ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafIntegerData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);

private:
	friend class ZAF_EXPORT ZafStandardArg;

	long value;

	static void Bind(void);
	static void Format(va_list *argList, ZafIChar **ptrBuffer, ZafIChar fmtch, int flags, int width, int prec);
	static int Parse(va_list *argList, ZafIChar **ptrBuffer, ZafIChar fmtch, int flags, int width, const ZafIChar **fmt);
};

// --- inline functions ---
inline long ZafIntegerData::Value(void) const { return value; }

#endif // Z_INT_HPP

