//	Zinc Application Framework - Z_IMAGE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_IMAGE_HPP)
#define Z_IMAGE_HPP
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafImage -----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafImage : public ZafWindowObject
{
public:
	// --- General members ---
	ZafImage(int left, int top, int width, int height,
		const ZafIChar *pathName, int pathID = -1);
	ZafImage(const ZafImage &copy);
	virtual ~ZafImage(void);

	// --- Persistent members ---
	ZafImage(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	bool AutoSize(void) const;
	int PathID(void);
	const ZafIChar *PathName(void);
	bool Scaled(void) const;
	bool Tiled(void) const;
	bool Wallpaper(void) const;
	// set
	virtual bool SetAutoSize(bool autoSize);
	virtual ZafError SetPathID(int pathID);
	virtual ZafError SetPathName(const ZafIChar *pathName);
	virtual bool SetScaled(bool scaled);
	virtual bool SetTiled(bool tiled);
	virtual bool SetWallpaper(bool wallpaper);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetFocus(bool currentFocus);
	virtual ZafLogicalFont SetFont(ZafLogicalFont font);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual ZafLogicalColor SetTextColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSImage;

	// --- General members ---
	ZafIChar *pathName;
	int pathID;
	int width, height;
	OSImageID imageBuffer;

	bool autoSize;
	bool scaled;
	bool tiled;
	bool wallpaper;

	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);

	// --- Filter definitions ---
	bool LoadImageFromApplication(void);
	bool LoadImageFromFile(void);

	// --- Deallocation member ---
	void DestroyImageHandle(void);

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSRegisterObject(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafImage::Read); }
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];

#if defined(ZAF_MACINTOSH)
	bool staticPICT;
#endif
};

// --- inline functions ---
inline bool ZafImage::AutoSize(void) const { return autoSize; }
inline int ZafImage::PathID(void) { return pathID; }
inline const ZafIChar *ZafImage::PathName(void) { return (pathName); }
inline bool ZafImage::Scaled(void) const { return scaled; }
inline bool ZafImage::Tiled(void) const { return tiled; }
inline bool ZafImage::Wallpaper(void) const { return wallpaper; }

#endif // Z_IMAGE_HPP
