//	Zinc Application Framework - Z_ICON1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_ICON1_HPP)
#define Z_ICON1_HPP
#include <z_icon.hpp>
#include <z_button.hpp>

// --------------------------------------------------------------------------
// ----- ZafIcon ------------------------------------------------------------
// --------------------------------------------------------------------------

enum ZafIconType
{
	ZAF_NATIVE_ICON		= 0,
	ZAF_MINIMIZE_ICON	= 1
};

// --- Icon image messages ---
typedef ZafNumberID ZafIconImage;
const ZafIconImage ZAF_APPLICATION_ICON		= 0;
const ZafIconImage ZAF_ASTERISK_ICON		= 1;
const ZafIconImage ZAF_EXCLAMATION_ICON		= 2;
const ZafIconImage ZAF_HAND_ICON			= 3;
const ZafIconImage ZAF_QUESTION_ICON		= 4;

class ZAF_EXPORT ZafIcon : public ZafButton
{
public:
	// --- General members ---
	ZafIcon(int left, int top, const ZafIChar *text,
		ZafIconData *iconData = ZAF_NULLP(ZafIconData),
		ZafIconType iconType = ZAF_NATIVE_ICON);
	ZafIcon(int left, int top, ZafStringData *title,
		ZafIconData *iconData = ZAF_NULLP(ZafIconData),
		ZafIconType iconType = ZAF_NATIVE_ICON);
	ZafIcon(const ZafIcon &copy);
	virtual ~ZafIcon(void);

	// --- Persistent members ---
	ZafIcon(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafIconData *IconData(void) const;
	ZafIconType IconType(void) const;
	// set
	virtual ZafError SetIconData(ZafIconData *iconData);
	virtual ZafIconData *SetIconImage(ZafIconImage iconImage);
	virtual ZafIconType SetIconType(ZafIconType iconType);

	// --- Button members ---
	virtual void ClearImage(void);
	virtual bool SetAllowDefault(bool allowDefault);
	virtual bool SetAllowToggling(bool allowToggling);
	virtual bool SetAutoRepeatSelection(bool autoRepeatSelection);
	virtual ZafError SetBitmapData(ZafBitmapData *bitmapData);
	virtual ZafButtonType SetButtonType(ZafButtonType buttonType);
	virtual int SetDepth(int depth);
	virtual ZafIChar SetHotKey(ZafIChar hotKeyChar, int index = -1);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetDisabled(bool disabled);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSelected(bool selected);
	virtual bool SetSupportObject(bool supportObject);
	virtual bool SetVisible(bool visible);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }

	// --- Special OS members ---
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

protected:
	friend class ZAF_EXPORT OSIcon;
	friend class ZAF_EXPORT ZafWindow;

	// --- General members ---
	ZafIconType iconType;
	ZafIconData *iconData;

	virtual ZafEventType DragDropEvent(const ZafEventStruct &event);
	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType DrawFocus(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType DrawShadow(ZafRegionStruct &region, int depth, ZafEventType ccode);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Data access ---
	static ZafError Update(ZafIcon *icon, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return icon->OSSetImage();
		  else if (type == ZAF_UPDATE_DATA) return (ZAF_ERROR_NONE);
		  else return (ZAF_ERROR_INVALID); }

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetImage(void);
	virtual ZafError OSSetText(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafIcon::Read); }
	void WriteData(ZafObjectPersistence &persist);

	// --- Image support ---
	static ZafStringIDChar ZAF_FARDATA applicationName[];
	static ZafStringIDChar ZAF_FARDATA asteriskName[];
	static ZafStringIDChar ZAF_FARDATA exclamationName[];
	static ZafStringIDChar ZAF_FARDATA handName[];
	static ZafStringIDChar ZAF_FARDATA questionName[];
	static ZafIconData **imageTable;
	static void ImageAllocate(void);
	static void ImageFree(bool globalRequest = false);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
};

// --- inline functions ---
inline ZafIconType ZafIcon::IconType(void) const { return iconType; }
inline ZafIconData *ZafIcon::IconData(void) const { return (iconData); }

#endif // Z_ICON1_HPP

