//	Zinc Application Framework - Z_ICON.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_ICON_HPP)
#define Z_ICON_HPP
#include <z_idata1.hpp>

// --------------------------------------------------------------------------
// ----- ZafIconData --------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafIconData : public ZafImageData, public ZafIconStruct
{
public:
	// --- General members ---
	ZafIconData(const ZafImageStruct &data);
	ZafIconData(const ZafIconStruct &data);
	ZafIconData(const ZafIconData &copy);
	virtual ~ZafIconData(void);

	// --- Persistent members ---
	ZafIconData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafLogicalColor *Array(void) const;
	int Height(void) const;
	int Width(void) const;
	// set
	virtual void Clear(void);
	virtual ZafError SetIcon(int width, int height, ZafLogicalColor *array);
	virtual ZafError SetIcon(const ZafIconStruct &icon);

	// --- Operators ---
	ZafIconData &operator=(const ZafIconData &icon);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafData::IsA(compareName)); }

protected:
	// --- Persistent members ---
	void ReadData(ZafDataPersistence &persist);
	virtual ZafDataConstructor ReadFunction(void) { return (ZafIconData::Read); }
	void WriteData(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);
};

// --- inline functions ---
inline ZafLogicalColor *ZafIconData::Array(void) const { return (array); }
inline int ZafIconData::Height(void) const { return (height); }
inline int ZafIconData::Width(void) const { return (width); }
inline ZafIconData &ZafIconData::operator=(const ZafIconData &icon) { SetIcon(icon); return *this; }

#endif // Z_ICON_HPP

