//	Zinc Application Framework - Z_HELP.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_HELP_HPP)
#define Z_HELP_HPP
#include <z_win.hpp>
#include <z_border.hpp>
#include <z_button.hpp>
#include <z_prompt.hpp>
#include <z_string.hpp>
#include <z_text.hpp>
#include <z_title.hpp>
#include <z_vlist.hpp>
#include <z_icon.hpp>

// --------------------------------------------------------------------------
// ----- ZafHelpSystem ------------------------------------------------------
// --------------------------------------------------------------------------

// --- ZafHelpEvent ---
const ZafHelpEvent S_HLP_SHOW_TOPIC				= -1999;
const ZafHelpEvent S_HLP_SHOW_INDEX				= -1998;
const ZafHelpEvent S_HLP_CLOSE					= -1997;
const ZafHelpEvent S_HLP_UPDATE_NAME			= -1996;
const ZafHelpEvent S_HLP_SELECT_TOPIC			= -1995;

class ZAF_EXPORT ZafHelpStub
{
public:
	ZafHelpStub(void);
	virtual ~ZafHelpStub(void);
	virtual void DisplayHelp(const ZafIChar *name) = 0;
};

class ZAF_EXPORT ZafHelpSystem : public ZafHelpStub, public ZafWindow
{
public:
	// --- General class members ---
	ZafHelpSystem(ZafFileSystem *helpStorage, ZafIChar *helpContext);
	ZafHelpSystem(const ZafHelpSystem &copy);
	virtual ~ZafHelpSystem(void);
	virtual void DisplayHelp(const ZafIChar *name);
	virtual void ResetStorage(ZafFileSystem *helpStorage);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSHelpSystem;

	ZafFileSystem *helpStorage;

	// --- Language & locale support ---
	static ZafIconData *helpIcon;
	static ZafLanguageData *language;
	static void ImageAllocate(void);
	static void LanguageAllocate(void);
	static void ImageFree(bool globalRequest = false);
	static void LanguageFree(bool globalRequest = false);

private:
	// general fields
	ZafIChar *context;
	ZafBorder *borderField;
	ZafTitle *titleField;
	ZafButton *showButton;
	ZafButton *closeButton;
	// index fields
	ZafPrompt *indexTopic;
	ZafPrompt *indexInstruction;
	ZafString *indexTitle;
	ZafVtList *indexContext;
	// topic fields
	ZafPrompt *topicTitle;
	ZafText *topicContext;

	void AddIndexFields(void);
	void AddTopicFields(ZafIChar *title = ZAF_NULLP(ZafIChar), ZafIChar *context = ZAF_NULLP(ZafIChar));
	void ComputeGeometry(void);
	static ZafEventType ItemCallback(ZafWindowObject *object, ZafEventStruct &event, ZafEventType ccode);
	void RemoveIndexFields(void);
	void RemoveTopicFields(void);
};

extern ZAF_EXPORT ZafHelpStub *zafHelpSystem;

#endif // Z_HELP_HPP

