//	Zinc Application Framework - Z_GMGR.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_GMGR_HPP)
#define Z_GMGR_HPP
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafConstraint ------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafConstraint : public ZafElement
{
public:
	// --- General members ---
	ZafConstraint(ZafWindowObject *object);
	ZafConstraint(const ZafConstraint &copy);
	virtual ~ZafConstraint(void);
	virtual ZafEventType Event(const ZafEventStruct &event);

	// --- Persistent members ---
	ZafConstraint(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual ZafConstraint *Duplicate(void);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafElement::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafElement::IsA(compareName)); }

	ZafConstraint *Next(void) const { return((ZafConstraint *)next); }
	ZafConstraint *Previous(void) const { return((ZafConstraint *)previous); }
	
	// --- Data access ---
	// get
	ZafWindowObject *Object(void);
	// set
	void SetObjNumberID(ZafNumberID tObjNumberID) { objNumberID = tObjNumberID; }
	
protected:
	friend class ZAF_EXPORT ZafGeometryManager;

	// --- General members ---
	ZafWindowObject *object;
	ZafNumberID objNumberID;
	ZafGeometryManager *parent;

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) = 0;
	void WriteData(ZafObjectPersistence &persist);

private:
	static ZafStringID genericConstraintID;
};

// --- inline functions ---
inline ZafWindowObject *ZafConstraint::Object(void) { return object; }

// --------------------------------------------------------------------------
// ----- ZafAttachment -----------------------------------------------------
// --------------------------------------------------------------------------

enum ZafAttachmentType
{
	ZAF_ATCF_LEFT,
	ZAF_ATCF_TOP,
	ZAF_ATCF_RIGHT,
	ZAF_ATCF_BOTTOM
};

class ZAF_EXPORT ZafAttachment : public ZafConstraint
{
public:
	// --- General members ---
	ZafAttachment(ZafWindowObject *object, ZafAttachmentType type);
	ZafAttachment(const ZafAttachment &copy);
	virtual ~ZafAttachment(void);

	// --- Persistent members ---
	ZafAttachment(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Data access ---
	// get
	ZafWindowObject *Reference(void);
	// set
	ZafError SetReference(ZafWindowObject *reference);
	void SetReferenceNumberID(ZafNumberID referenceNumberID){ refNumberID = referenceNumberID; }

	// --- Attributes ---
	// get
	int Offset(void) const;
	bool OppositeSide(void) const;
	bool Stretch(void) const;
	ZafAttachmentType Type(void) const;
	// set
	int SetOffset(int offset);
	bool SetOppositeSide(bool oppositeSide);
	bool SetStretch(bool stretch);
	ZafAttachmentType SetType(ZafAttachmentType type);

	// --- Constraint members ---
	virtual ZafEventType Event(const ZafEventStruct &event);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafConstraint::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((className == className) ? true : ZafConstraint::IsA(compareName)); }

protected:
	// --- General members ---
	ZafWindowObject *reference;
	ZafNumberID refNumberID;
	int offset;
	ZafAttachmentType type;
	bool stretch, oppositeSide;

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafAttachment::Read); }
	void WriteData(ZafObjectPersistence &persist);

	virtual ZafConstraint *Duplicate(void);
};

// --- inline functions ---
inline int ZafAttachment::Offset(void) const { return offset; }
inline bool ZafAttachment::OppositeSide(void) const { return oppositeSide; }
inline ZafWindowObject *ZafAttachment::Reference(void) { return reference; }
inline bool ZafAttachment::Stretch(void) const { return stretch; }
inline ZafAttachmentType ZafAttachment::Type(void) const { return type; }

// --------------------------------------------------------------------------
// ----- ZafRelativeConstraint ----------------------------------------------
// --------------------------------------------------------------------------

enum ZafRelativeConstraintType
{
	ZAF_RLCF_LEFT,
	ZAF_RLCF_TOP,
	ZAF_RLCF_RIGHT,
	ZAF_RLCF_BOTTOM
};

class ZAF_EXPORT ZafRelativeConstraint : public ZafConstraint
{
public:
	// --- General members ---
	ZafRelativeConstraint(ZafWindowObject *object,
		ZafRelativeConstraintType type);
	ZafRelativeConstraint(const ZafRelativeConstraint &copy);
	virtual ~ZafRelativeConstraint(void);

	// --- Persistent members ---
	ZafRelativeConstraint(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes ---
	// get
	bool Center(void) const;
	bool OppositeSide(void) const;
	int Ratio(void) const;
	bool Stretch(void) const;
	ZafRelativeConstraintType Type(void) const;
	// set
	int SetCenter(bool center);
	bool SetOppositeSide(bool oppositeSide);
	int SetRatio(int ratio);
	bool SetStretch(bool stretch);
	ZafRelativeConstraintType SetType(ZafRelativeConstraintType type);

	// --- Constraint members ---
	virtual ZafEventType Event(const ZafEventStruct &event);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafConstraint::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafConstraint::IsA(compareName)); }

protected:
	// --- General members ---
	int ratio;
	ZafRelativeConstraintType type;
	bool stretch, oppositeSide, center;

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafRelativeConstraint::Read); }
	void WriteData(ZafObjectPersistence &persist);

	virtual ZafConstraint *Duplicate(void);
};

// --- inline functions ---
inline bool ZafRelativeConstraint::Center(void) const { return center; }
inline bool ZafRelativeConstraint::OppositeSide(void) const { return oppositeSide; }
inline int ZafRelativeConstraint::Ratio(void) const { return ratio; }
inline bool ZafRelativeConstraint::Stretch(void) const { return stretch; }
inline ZafRelativeConstraintType ZafRelativeConstraint::Type(void) const { return type; }

// --------------------------------------------------------------------------
// ----- ZafDimensionConstraint ---------------------------------------------
// --------------------------------------------------------------------------

enum ZafDimensionConstraintType
{
	ZAF_DNCF_WIDTH,
	ZAF_DNCF_HEIGHT
};

class ZAF_EXPORT ZafDimensionConstraint : public ZafConstraint
{
public:
	// --- General members ---
	ZafDimensionConstraint(ZafWindowObject *object,
		ZafDimensionConstraintType type);
	ZafDimensionConstraint(const ZafDimensionConstraint &copy);
	virtual ~ZafDimensionConstraint(void);

	// --- Persistent members ---
	ZafDimensionConstraint(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes ---
	// get
	int Maximum(void) const;
	int Minimum(void) const;
	ZafDimensionConstraintType Type(void) const;
	// set
	int SetMaximum(int hzMaximum);
	int SetMinimum(int hzMinimum);
	ZafDimensionConstraintType SetType(ZafDimensionConstraintType type);

	// --- Constraint members ---
	virtual ZafEventType Event(const ZafEventStruct &event);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafConstraint::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafConstraint::IsA(compareName)); }

protected:
	// --- General members ---
	int minimum, maximum;
	ZafDimensionConstraintType type;

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafDimensionConstraint::Read); }
	void WriteData(ZafObjectPersistence &persist);

	virtual ZafConstraint *Duplicate(void);
};

// --- inline functions ---
inline int ZafDimensionConstraint::Maximum(void) const { return maximum; }
inline int ZafDimensionConstraint::Minimum(void) const { return minimum; }
inline ZafDimensionConstraintType ZafDimensionConstraint::Type(void) const { return type; }

// --------------------------------------------------------------------------
// ----- ZafGeometryManager -----------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafGeometryManager : public ZafWindowObject, public ZafList
{
public:
	// --- General members ---
	ZafGeometryManager(void);
	ZafGeometryManager(const ZafGeometryManager &copy);
	virtual ~ZafGeometryManager(void);

	// --- Persistent members ---
	ZafGeometryManager(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetAutomaticUpdate(bool automaticUpdate);
	virtual ZafLogicalColor SetBackgroundColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual bool SetBordered(bool bordered);
	virtual ZafCoordinateType SetCoordinateType(ZafCoordinateType coordinateType);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual ZafLogicalFont SetFont(ZafLogicalFont font);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetOSDraw(bool osDraw);
	virtual bool SetParentDrawBorder(bool parentDrawBorder);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual const ZafIChar *SetQuickTip(const ZafIChar *quickTip);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSelected(bool selected);
	virtual bool SetSupportObject(bool supportObject);
	virtual ZafLogicalColor SetTextColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);
	virtual ZafPaletteMap *SetUserPalette(ZafPaletteMap *userPalette, bool staticUserPalette);
	virtual bool SetVisible(bool visible);

	// --- List members ---
	ZafConstraint *Add(ZafConstraint *object, ZafConstraint *position = ZAF_NULLP(ZafConstraint));
	ZafConstraint *Current(void) const { return((ZafConstraint *)current); }
	ZafConstraint *First(void) const { return((ZafConstraint *)first); }
	ZafConstraint *Last(void) const { return((ZafConstraint *)last); }
	ZafConstraint *Subtract(ZafConstraint *object);

	ZafGeometryManager &operator+(ZafConstraint *object) { Add(object); return(*this); }
	ZafGeometryManager &operator-(ZafConstraint *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }

protected:
	// --- General members ---
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);

	// --- Special OS members ---
	virtual void OSSize(void);

	// --- Persistent members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafGeometryManager::Read); }

	virtual ZafWindowObject *Duplicate(void);
};

#endif // Z_GMGR_HPP

