//	Zinc Application Framework - Z_FDATA.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_FDATA_HPP)
#define Z_FDATA_HPP
#include <z_data.hpp>
#include <z_loc.hpp>

// --------------------------------------------------------------------------
// ----- ZafFormatData ------------------------------------------------------
// --------------------------------------------------------------------------

struct ZAF_EXPORT parentArgs;
#define ZAF_FORMAT_LENGTH		64

class ZAF_EXPORT ZafFormatData : public ZafData
{
public:
	// --- General members ---
	virtual ~ZafFormatData(void);

	// --- Persistence ---
	ZafFormatData(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	virtual int FormattedText(ZafIChar *buffer, int maxLength, const ZafIChar *format = 0) const = 0;

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafData::IsA(compareName)); }

protected:
	// --- General members ---
	ZafFormatData(void);
	ZafFormatData(const ZafFormatData &copy);

	// printf support
	const ZafIChar *ParseFormat(ZafIChar *format, const ZafIChar *formatArray) const;
	int Sprintf(ZafIChar *buffer, int maxLength, const ZafIChar *format) const;
	int Sscanf(const ZafIChar *buffer, const ZafIChar *format);
};

#endif // Z_FDATA_HPP

