//	Zinc Application Framework - Z_EVENT.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_EVENT_HPP)
#define Z_EVENT_HPP
#include <z_region.hpp>
#include <z_key.hpp>
#include <z_mouse.hpp>
#include <z_scrll.hpp>

// --------------------------------------------------------------------------
// ----- ZafEventType -------------------------------------------------------
// --------------------------------------------------------------------------
// --- The following object identifier values are reserved.
// ---      values <= -5000         reserved for future use.
// ---      values -4999..-4500     ZafDesignerEvent
// ---      values -4499..-3600     ZafApplicationEvent
// ---      values -3599..-3500     ZafNotifyEvent
// ---      values -3499..-3000     ZafDeviceState
// ---      values -2999..-2000     ZafDialogEvent
// ---      values -1999..-1900     ZafHelpEvent
// ---      values -2999..   -1     ZafSystemEvent
// ---      values     0..   99     ZafRawCode
// ---      values   100.. 9999     ZafLogicalEvent
// ---      values >= 10000         available for programmer's use.

// --------------------------------------------------------------------------
// ----- ZafEventStruct -----------------------------------------------------
// --------------------------------------------------------------------------

// --- Designer events ---
typedef ZafEventType ZafDesignerEvent;
const ZafDesignerEvent D_DESIGNER_FIRST			= -4999;
const ZafDesignerEvent D_DESIGNER_LAST			= -4500;

// --- Application events ---
typedef ZafEventType ZafApplicationEvent;
const ZafApplicationEvent A_APPLICATION_FIRST	= -4499;
const ZafApplicationEvent A_APPLICATION_LAST	= -3600;

// --- Notify events ---
typedef ZafEventType ZafNotifyEvent;
const ZafNotifyEvent N_NOTIFY_FIRST				= -3599;
const ZafNotifyEvent N_NOTIFY_LAST				= -3500;

// --- Device states ---
typedef ZafEventType ZafDeviceState;
const ZafDeviceState D_DEVICE_FIRST				= -3499;
const ZafDeviceState D_DEVICE_LAST				= -3000;

// --- System events ---
typedef ZafEventType ZafSystemEvent;
const ZafSystemEvent S_SYSTEM_EVENT				= -2999;
const ZafSystemEvent S_SYSTEM_FIRST				= -2999;
const ZafSystemEvent S_SYSTEM_LAST				= -1;

// --- Dialog events ---
typedef ZafEventType ZafDialogEvent;
const ZafDialogEvent S_DIALOG_FIRST				= -2999;
const ZafDialogEvent S_DIALOG_LAST				= -2000;
const ZafDialogEvent S_DIALOG_USER				= -2499;

// --- Help events ---
typedef ZafEventType ZafHelpEvent;
const ZafHelpEvent S_HELP_FIRST					= -1999;
const ZafHelpEvent S_HELP_LAST					= -1900;

// --- Device types ---
typedef ZafEventType ZafDeviceType;
const ZafDeviceType E_DEVICE_EVENT				= 0;
const ZafDeviceType E_DEVICE_FIRST				= 0;
const ZafDeviceType E_DEVICE_LAST				= 99;

// --- Logical events ---
typedef ZafEventType ZafLogicalEvent;
const ZafLogicalEvent L_LOGICAL_EVENT			= 100;
const ZafLogicalEvent L_LOGICAL_FIRST			= 100;
const ZafLogicalEvent L_LOGICAL_LAST			= 9999;

// --- User events ---
typedef ZafEventType ZafUserEvent;
const ZafUserEvent U_USER_FIRST					= 10000;
const ZafUserEvent U_USER_LAST					= 32767;

// Declaration of classes used by ZafEventStruct.
class ZAF_EXPORT ZafDevice;
class ZAF_EXPORT ZafDisplay;
class ZAF_EXPORT ZafEventManager;
class ZAF_EXPORT ZafWindowObject;
class ZAF_EXPORT ZafWindow;
class ZAF_EXPORT ZafWindowManager;

struct ZAF_EXPORT ZafEventStruct
{
	ZafEventType type;
	OSEventStruct osEvent;
	ZafRawCode rawCode;
	ZafRawCode modifiers;
	ZafWindowObject *route;
	ZafWindowObject *converted;
	ZafIChar *text;

	union
	{
		ZafKeyStruct key;
		ZafRegionStruct region;
		ZafPositionStruct position;
		ZafScrollStruct scroll;

		ZafDevice *device;
		ZafDisplay *display;
		ZafEventManager *eventManager;
		const ZafIChar *helpContext;
		ZafWindowObject *windowObject;
		ZafWindow *window;
		ZafWindowManager *windowManager;

		OSWindowID screenID;

		void *data;
	};

	// --- Constructors ---
	ZafEventStruct(void);
	ZafEventStruct(ZafEventType type, OSEventStruct *osEvent);
	ZafEventStruct(ZafEventType type, ZafRawCode rawCode = 0);

	ZafEventStruct(ZafEventType type, ZafRawCode rawCode, ZafKeyStruct key);
	ZafEventStruct(ZafEventType type, ZafRawCode rawCode, ZafRegionStruct region);
	ZafEventStruct(ZafEventType type, ZafRawCode rawCode, ZafPositionStruct position);
	ZafEventStruct(ZafEventType type, ZafRawCode rawCode, ZafScrollStruct scroll);

	// --- Members to get union information ---
	ZafDevice *Device(void) const { return (device); }
	ZafDisplay *Display(void) const { return (display); }
	ZafEventManager *EventManager(void) const { return (eventManager); }
	const ZafKeyStruct *Key(void) const { return (&key); }
	const ZafPositionStruct *Position(void) const { return (&position); }
	const ZafRegionStruct *Region(void) const { return (&region); }
	const ZafScrollStruct *Scroll(void) const { return (&scroll); }
	void *VoidData(void) const { return (data); }
	ZafWindow *Window(void) const { return (window); }
	ZafWindowManager *WindowManager(void) const { return (windowManager); }
	ZafWindowObject *WindowObject(void) const { return (windowObject); }

	// --- Members to set union information ---
	void SetDevice(ZafDevice *tDevice) { device = tDevice; }
	void SetDisplay(ZafDisplay *tDisplay) { display = tDisplay; }
	void SetEventManager(ZafEventManager *tEventManager) { eventManager = tEventManager; }
	void SetKey(ZafKeyStruct *tKey) { key = *tKey; }
	void SetPosition(ZafPositionStruct *tPosition) { position = *tPosition; }
	void SetRegion(ZafRegionStruct *tRegion) { region = *tRegion; }
	void SetScroll(ZafScrollStruct *tScroll) { scroll = *tScroll; }
	void SetVoidData(void *tData) { data = tData; }
	void SetWindow(ZafWindow *tWindow) { window = tWindow; }
	void SetWindowManager(ZafWindowManager *tWindowManager) { windowManager = tWindowManager; }
	void SetWindowObject(ZafWindowObject *tWindowObject) { windowObject = tWindowObject; }

	// -- General members ---
	ZafEventType InputType(ZafEventType ccode = 0) const;
};

#endif // Z_EVENT_HPP

