//	Zinc Application Framework - Z_ERROR.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_ERROR_HPP)
#define Z_ERROR_HPP
#include <z_dlgwin.hpp>

// --------------------------------------------------------------------------
// ----- ZafErrorSystem -----------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafErrorStub
{
public:
	ZafErrorStub(void);
	virtual ~ZafErrorStub(void);
	virtual ZafDialogEvent ErrorMessage(ZafWindowObject *object,
		ZafIChar *title, ZafDialogFlags dlgFlags, ZafIChar *message) = 0;
	ZafDialogEvent ReportError(ZafWindowObject *object,
		ZafIChar *title, ZafDialogFlags dlgFlags,
		ZafIChar *format, ...);
};

class ZAF_EXPORT ZafErrorSystem : public ZafErrorStub
{
public:
	// --- General members ---
	ZafErrorSystem(void);
	ZafErrorSystem(const ZafErrorSystem &copy);
	virtual ~ZafErrorSystem(void);
	static void Beep(void);
	virtual ZafDialogEvent ErrorMessage(ZafWindowObject *object,
		ZafIChar *title, ZafDialogFlags dlgFlags, ZafIChar *message);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : false); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : false); }

protected:
	friend class ZAF_EXPORT OSErrorSystem;

	// --- Language & locale support ---
	static ZafLanguageData *language;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);
};

extern ZAF_EXPORT ZafErrorStub *zafErrorSystem;

#endif // Z_ERROR_HPP

