//	Zinc Application Framework - Z_ENV.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#ifndef Z_ENV_HPP
#define Z_ENV_HPP

// International language support.
#define ZAF_ISO8859_1			// Standard support for ISO8859-1
//#define ZAF_UNICODE			// Support for UNICODE

#if defined(_WINDOWS) || (defined(_Windows) && !defined(DOS32PP)) || defined(WIN32) || defined(__WINDOWS__) || defined(__NT__)
#	include <w_env.hpp>
#elif defined(__hpux) || defined(__sgi) || defined(sun) || defined(_SINIX) || defined(__DVX__) || (defined(__alpha) && !defined(WIN32)) || defined(_IBM_RS6000) || defined(__QNX__) || defined(SCO_UNIX) || defined(__linux__)
#	include <m_env.hpp>
#elif defined(__OS2__) || defined(__GLOCKENSPIEL__) || defined(__IBMCPP__)
#	include <o_env.hpp>
#elif defined(macintosh)
#	include <a_env.hpp>
#else
#	include <d_env.hpp>
#endif

#if defined(ZAF_UNICODE)
#	if defined(__MWERKS__)
		typedef unsigned short ZafIChar;
#		define ZAF_ITEXT(x)	L ## x
#	else
		typedef wchar_t ZafIChar;
#		define ZAF_ITEXT(x)	L ## x
#	endif
#else
	typedef char ZafIChar;
#	define ZAF_ITEXT(x)	x
#endif

// ----- General Zinc Switches ----------------------------------------------

// Zinc persistence.
#define ZAF_READ				// Allow read operations
#define ZAF_WRITE				// Allow write operations

// International language.
//#define ZAF_DECOMPOSE			// Support to decompose compound Unicode
//#define ZAF_REARRANGEARGS		// Support for argument rearrangement in sprintf() and sscanf()
#define ZAF_DO_OS_I18N			// Do possibly broken OS I18n support

// ----- ZAF_NULLP, ZAF_NULLF, ZAF_NULLH, ZAF_VOIDF, ZAF_VOIDP --------------

#define ZAF_NULLP(type)		((type *)0)
#define ZAF_NULLF(type)		((type)0)
#define ZAF_NULLH(type)		((type)0)

// ----- Compiler/Hardware Typedef Sizes ------------------------------------

#if defined(__DVX__) || defined(_IBM_RS6000) || defined(__QNX__) || defined(__sgi)
	typedef	signed char		ZafInt8;
	typedef	unsigned char	ZafUInt8;
#else
	typedef	char			ZafInt8;
	typedef	unsigned char	ZafUInt8;
#endif
#if (ZAF_WORD_SIZE == 16)
	typedef	short		   	ZafInt16;
	typedef	unsigned short	ZafUInt16;
	typedef	long			ZafInt32;
	typedef	unsigned long	ZafUInt32;
#elif (ZAF_WORD_SIZE == 32)
	typedef	short			ZafInt16;
	typedef	unsigned short	ZafUInt16;
	typedef	long			ZafInt32;
	typedef	unsigned long	ZafUInt32;
#elif (ZAF_WORD_SIZE == 64)
	typedef	short			ZafInt16;
	typedef	unsigned short	ZafUInt16;
	typedef	int				ZafInt32;
	typedef	unsigned int	ZafUInt32;
#else
	???? set your word size;
#endif

// ----- ZafFlags -----------------------------------------------------------

typedef ZafUInt16 ZafFlags;
typedef ZafUInt16 ZafStatus;

// --- Errors ---------------------------------------------------------------

typedef int ZafError;
const ZafError ZAF_ERROR_NONE 					= 0;	// Value successfully imported
const ZafError ZAF_ERROR_INVALID 				= 1;	// Invalid value
const ZafError ZAF_ERROR_INVALID_NAME			= 2;	// Invalid name
const ZafError ZAF_ERROR_AMBIGUOUS				= 3;	// Ambiguous value
const ZafError ZAF_ERROR_VALUE_MISSING			= 4;	// Required value not present
const ZafError ZAF_ERROR_OUT_OF_RANGE			= 5;	// Value out of range
const ZafError ZAF_ERROR_LESS_THAN_RANGE		= 6;	// Value less than positively open-ended range
const ZafError ZAF_ERROR_GREATER_THAN_RANGE		= 7;	// Value greater than negatively open-ended range
const ZafError ZAF_ERROR_INVALID_ID				= 8;	// Invalid class identifier
const ZafError ZAF_ERROR_INVALID_CLASS			= 9;	// Invalid class object
const ZafError ZAF_ERROR_INVALID_TARGET			= 10;	// Invalid target
const ZafError ZAF_ERROR_INVALID_SOURCE			= 11;	// Invalid source
const ZafError ZAF_ERROR_LEAVE_INVALID 			= 12;	// Leave the value invalid
const ZafError ZAF_ERROR_CONSTRUCTOR 			= 13;	// Constructor detected an error
const ZafError ZAF_ERROR_FILE_OPEN				= 14;	// File open error
const ZafError ZAF_ERROR_FILE_POSITION			= 15;	// File pointer positioning error
const ZafError ZAF_ERROR_FILE_READ				= 16;	// File read error (not because of eof)
const ZafError ZAF_ERROR_FILE_WRITE				= 17;	// File write error
const ZafError ZAF_ERROR_STORAGE_VERSION		= 18;	// Storage file is wrong version

// ----- Miscellaneous ------------------------------------------------------

const int ZAF_DYNAMIC_ARRAY_INCREMENT			= 5;
const int ZAF_MAXPATHLEN						= 256;
const int ZAF_MAXNAMELEN						= 64;

typedef ZafInt32 ZafEventType;
typedef unsigned int ZafRawCode;

typedef ZafInt16 ZafClassID;

typedef unsigned int ZafInfoRequest;

typedef ZafIChar ZafClassNameChar;
typedef const ZafIChar *ZafClassName;

typedef ZafIChar ZafStringIDChar;
typedef const ZafIChar *ZafStringID;

typedef ZafIChar ZafDataNameChar;
typedef const ZafIChar *ZafDataName;

#endif // Z_ENV_HPP

