//	Zinc Application Framework - Z_DLGWIN.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_DLGWIN_HPP)
#define Z_DLGWIN_HPP
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafDialogWindow ----------------------------------------------------
// --------------------------------------------------------------------------

// --- ZafDialogFlags ---
typedef ZafFlags ZafDialogFlags;
const ZafDialogFlags ZAF_DIALOG_OK			= 0x0001;
const ZafDialogFlags ZAF_DIALOG_YES			= 0x0002;
const ZafDialogFlags ZAF_DIALOG_NO			= 0x0004;
const ZafDialogFlags ZAF_DIALOG_ABORT		= 0x0008;
const ZafDialogFlags ZAF_DIALOG_RETRY		= 0x0010;
const ZafDialogFlags ZAF_DIALOG_IGNORE		= 0x0020;
const ZafDialogFlags ZAF_DIALOG_CANCEL		= 0x0040;
const ZafDialogFlags ZAF_DIALOG_HELP		= 0x0080;

// --- ZafDialogEvent ---
const ZafDialogEvent S_DLG_OK				= -2999;
const ZafDialogEvent S_DLG_YES				= -2998;
const ZafDialogEvent S_DLG_NO				= -2997;
const ZafDialogEvent S_DLG_ABORT			= -2996;
const ZafDialogEvent S_DLG_RETRY			= -2995;
const ZafDialogEvent S_DLG_IGNORE			= -2994;
const ZafDialogEvent S_DLG_CANCEL			= -2993;
const ZafDialogEvent S_DLG_HELP				= -2992;

// --- Messages ---
const ZafUInt8 ZAF_MSG_TITLE 				= 0; // error
const ZafUInt8 ZAF_MSG_OK 					= 1; // error
const ZafUInt8 ZAF_MSG_CANCEL 				= 2; // error
const ZafUInt8 ZAF_MSG_ICONNAME 			= 3; // help, error
const ZafUInt8 ZAF_MSG_MOVE 				= 4; // error
const ZafUInt8 ZAF_MSG_CLOSE 				= 5; // help, error
const ZafUInt8 ZAF_MSG_MESSAGE1 			= 6; // help
const ZafUInt8 ZAF_MSG_ICONTITLE 			= 7; // help
const ZafUInt8 ZAF_MSG_MESSAGE2 			= 8; // help
const ZafUInt8 ZAF_MSG_HELP_TOPIC 			= 9; // help
const ZafUInt8 ZAF_MSG_HELP_INDEX 			= 10; // help
const ZafUInt8 ZAF_MSG_SHOW_TOPIC 			= 11; // help
const ZafUInt8 ZAF_MSG_SHOW_INDEX 			= 12; // help
const ZafUInt8 ZAF_MSG_HELP	 				= 13; // error
const ZafUInt8 ZAF_MSG_NEW	 				= 14; // file
const ZafUInt8 ZAF_MSG_OPEN	 				= 15; // file
const ZafUInt8 ZAF_MSG_SAVEAS	 			= 16; // file

class ZAF_EXPORT ZafDialogWindow : public ZafWindow
{
public:
	// --- General members ---
	ZafDialogWindow(int left, int top, int width, int height);
	ZafDialogWindow(const ZafDialogWindow &copy);
	virtual ~ZafDialogWindow(void);
	ZafDialogEvent Control(ZafQFlags flags = Q_NORMAL);

	// --- Persistent members ---
	ZafDialogWindow(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes ---
	// get
	virtual bool Modal(void) const;
	// set
	virtual bool SetModal(bool modal);

	// --- Window members ---
	virtual bool SetSizeable(bool sizeable);
	virtual bool SetTemporary(bool temporary);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentPalette(bool parentPalette);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);

	// --- List members ---
	ZafDialogWindow &operator+(ZafWindowObject *object) { Add(object); return(*this); }
	ZafDialogWindow &operator-(ZafWindowObject *object) { Subtract(object); return(*this); }

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindow::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindow::IsA(compareName)); }

protected:
	bool modal;

	// --- Special OS members ---
	virtual void OSRegisterObject(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafDialogWindow::Read); }
	void WriteData(ZafObjectPersistence &persist);
};

#endif // Z_DLGWIN_HPP

