//	Zinc Application Framework - Z_DATE1.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_DATE1_HPP)
#define Z_DATE1_HPP
#include <z_date.hpp>
#include <z_str1.hpp>

// --------------------------------------------------------------------------
// ----- ZafDate ------------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafDate : public ZafString
{
public:
	// --- General members ---
	ZafDate(int left, int top, int width,
		ZafDateData *dateData = ZAF_NULLP(ZafDateData));
	ZafDate(int left, int top, int width,
		int year, int month, int day);
	ZafDate(const ZafDate &copy);
	virtual ~ZafDate(void);

	// --- Persistent members ---
	ZafDate(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	ZafDateData *DateData(void) const;
	// set
	virtual ZafError SetDateData(ZafDateData *dateData);

	// --- String members ---
	virtual bool SetLowerCase(bool lowerCase);
	virtual bool SetPassword(bool password);
	virtual ZafError SetStringData(ZafStringData *string);
	virtual bool SetUpperCase(bool upperCase);
	virtual bool SetVariableName(bool variableName);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual ZafError SetText(const ZafIChar *text);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafString::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafString::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSDate;

	// --- General members ---
	virtual ZafWindowObject *Duplicate(void);

	// --- Data access ---
	ZafDateData *dateData;
	virtual ZafError Decrement(ZafData *data);
	virtual ZafError Increment(ZafData *data);
	static ZafError Update(ZafDate *date, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return date->OSSetDate();
		  else if (type == ZAF_UPDATE_DATA) return date->OSGetDate();
		  else return (ZAF_ERROR_INVALID); }
	virtual ZafError Validate(bool processError = true);

	// --- Special OS members ---
	ZafError OSGetDate(void);
	ZafError OSSetDate(void);

	// --- Language & locale support ---
	static ZafLanguageData *errorStrings;
	static void LanguageAllocate(void);
	static void LanguageFree(bool globalRequest = false);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafDate::Read); }
	void WriteData(ZafObjectPersistence &persist);
};

// --- inline functions ---
inline ZafDateData *ZafDate::DateData(void) const { return dateData; }
inline ZafError ZafDate::SetText(const ZafIChar *text) { return (dateData->SetDate(text, inputFormatData ? inputFormatData->Text() : ZAF_NULLP(ZafIChar))); }

#endif // Z_DATE1_HPP

