//	Zinc Application Framework - Z_DATE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_DATE_HPP)
#define Z_DATE_HPP
#include <z_utime.hpp>

// --------------------------------------------------------------------------
// ----- ZafDateData --------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafDateData : public ZafUTimeData
{
public:
	// -- General members ---
	ZafDateData(void);
	ZafDateData(int year, int month, int day);
	ZafDateData(const ZafIChar *string, const ZafIChar *format = ZAF_NULLP(ZafIChar));
	ZafDateData(const ZafDateData &copy);
	ZafDateData(const ZafUTimeData &copy);
	virtual ~ZafDateData(void);

	// --- Persistence ---
	ZafDateData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	// --- Attributes & data access ---
	// get
	virtual int FormattedText(ZafIChar *buffer, int maxLength, const ZafIChar *format = 0) const;
	// set
	virtual void Clear(void);
	virtual ZafError SetDate(int year, int month, int day);
	virtual ZafError SetDate(const ZafIChar *buffer, const ZafIChar *format);
	virtual ZafError SetDate(const ZafDateData &number);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafUTimeData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafUTimeData::IsA(compareName)); }

protected:
	// --- Persistent members --
	virtual ZafDataConstructor ReadFunction(void) { return (ZafDateData::Read); }

	virtual ZafData *Duplicate(void);
};

#endif // Z_DATE_HPP

