//	Zinc Application Framework - Z_CSET.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_CSET_HPP)
#define Z_CSET_HPP
#include <z_idata.hpp>

// --------------------------------------------------------------------------
// ----- ZafCodeSetData -----------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafCharLookup;
class ZAF_EXPORT ZafWcharLookup;
class ZAF_EXPORT ZafCodeSetData : public ZafI18nData
{
public:
	// --- General members ---
	ZafIChar dirSepStr[2];

	ZafCodeSetData(ZafIChar *i18NToLocal, ZafIChar *localToI18N);
	ZafCodeSetData(const ZafCodeSetData &copy);
	virtual ~ZafCodeSetData(void);
	int ConvertToOSChar(ZafIChar zafChar, char *osChar);
	char *ConvertToOSString(const ZafIChar *zafString, char *osString = ZAF_NULLP(char), bool allocate = true);
	int ConvertToZafChar(const char *osChar, ZafIChar &zafChar);
	ZafIChar *ConvertToZafString(const char *osString, ZafIChar *zafString = ZAF_NULLP(ZafIChar), bool allocate = true);

	// --- Special UNICODE functions ---
#if defined(ZAF_UNICODE)
	int ConvertToOSWChar(ZafIChar zafChar, wchar_t *osChar);
	wchar_t *ConvertToOSWString(const ZafIChar *zafString, wchar_t *osString = ZAF_NULLP(wchar_t), bool allocate = true);
	int ConvertToZafChar(const wchar_t *osChar, ZafIChar &zafChar);
	ZafIChar *ConvertToZafString(const wchar_t *osString, ZafIChar *zafString = ZAF_NULLP(ZafIChar), bool allocate = true);
	ZafIChar *IsoToUnicode(const char *isoText, ZafIChar *unicodeText = ZAF_NULLP(ZafIChar));
	char *UnicodeToIso(const ZafIChar *unicodeText, char *isoText = ZAF_NULLP(char));

	int mblen(const char *hardware);
	int wcstombs(char *s, const ZafIChar *pwcs, int n = -1);
	int mbstowcs(ZafIChar *pwcs, const char *s, int n = -1);
#endif

	// --- Persistent members ---
	ZafCodeSetData(const ZafIChar *name, ZafDataPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafDataPersistence &persist);
	virtual void Write(ZafDataPersistence &persist);

	virtual ZafData *Duplicate(void);

	// --- Attributes & data access ---
	// get
	static const ZafIChar *CodeSetName(void);
	ZafUInt8 DefaultLeadByte(void) const;
	// set
	virtual void Clear(void);
	ZafUInt8 SetDefaultLeadByte(ZafUInt8 defaultLeadByte);
	static ZafError SetCodeSetName(const ZafIChar *codeSetName);

	// --- Default charmap ---
	static void CodeSetAllocate(const ZafIChar *name = ZAF_NULLP(ZafIChar));
	static void CodeSetFree(bool globalRequest = false);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafI18nData::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafI18nData::IsA(compareName)); }

#if defined(ZAF_UNICODE)
	static bool OSNativeMapping(void);
	bool SetNativeMapping(bool mapping) { nativeMapping = mapping; return (nativeMapping); }
	bool NativeMapping(void) const { return (nativeMapping); }
#endif

protected:
	// --- Persistence ---
	virtual ZafDataConstructor ReadFunction(void) { return (ZafCodeSetData::Read); }

#if defined(ZAF_UNICODE)
	bool nativeMapping;
#endif

private:
	ZafUInt8 defaultLeadByte;
	ZafCharLookup *isoToLocal;
	ZafCharLookup *localToIso;
#	if defined(ZAF_UNICODE)
	ZafWcharLookup *unicodeToLocal;
	ZafWcharLookup *localToUnicode;

	static int OSConvertToOSChar(ZafIChar zafChar, char *osChar);
	static char *OSConvertToOSString(const ZafIChar *zafString, char *osString, int maxLength);
	static int OSConvertToZafChar(const char *osChar, ZafIChar &zafChar);
	static ZafIChar *OSConvertToZafString(const char *osString, ZafIChar *zafString, int maxLength);
#	endif

	void InitializeDirSepStr(void);
};

extern ZAF_EXPORT ZafCodeSetData *zafCodeSet;

// --- inline functions ---
inline const ZafIChar *ZafCodeSetData::CodeSetName(void) { return (zafCodeSet ? zafCodeSet->StringID() : ZAF_NULLP(ZafIChar)); }
inline ZafUInt8 ZafCodeSetData::DefaultLeadByte(void) const { return (defaultLeadByte); }

#endif // Z_CSET_HPP

