//	Zinc Application Framework - Z_BUTTON.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_BUTTON_HPP)
#define Z_BUTTON_HPP
#include <z_bitmap.hpp>
#include <z_str.hpp>
#include <z_win.hpp>

// --------------------------------------------------------------------------
// ----- ZafButton ----------------------------------------------------------
// --------------------------------------------------------------------------

enum ZafButtonType
{
	ZAF_NATIVE_BUTTON	= 0,
	ZAF_RADIO_BUTTON	= 1,
	ZAF_CHECK_BOX		= 2,
	ZAF_3D_BUTTON		= 3,
	ZAF_FLAT_BUTTON		= 4,
	ZAF_TOOLBAR_BUTTON	= 5
};

class ZAF_EXPORT ZafButton : public ZafWindowObject
{
public:
	// --- General members ---
	ZafButton(int left, int top, int width, int height, const ZafIChar *text,
		ZafBitmapData *bitmapData = ZAF_NULLP(ZafBitmapData), 
		ZafButtonType buttonType = ZAF_NATIVE_BUTTON);
	ZafButton(int left, int top, int width, int height, ZafStringData *stringData,
		ZafBitmapData *bitmapData = ZAF_NULLP(ZafBitmapData),
		ZafButtonType buttonType = ZAF_NATIVE_BUTTON);
	ZafButton(const ZafButton &copy);
	virtual ~ZafButton(void);
	ZafEventType SendMessage(const ZafEventStruct &event, ZafEventType ccode);

	// --- Persistent members ---
	ZafButton(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	bool AllowDefault(void) const;
	bool AllowToggling(void) const;
	bool AutoRepeatSelection(void) const;
	bool AutoSize(void) const;
	ZafBitmapData *BitmapData(void) const;
	ZafButtonType ButtonType(void) const;
	bool Depressed(void) const;
	int Depth(void) const;
	ZafIChar HotKeyChar(void) const;
	int HotKeyIndex(void) const;
	ZafHzJustify HzJustify(void) const;
	ZafVtJustify VtJustify(void) const;
	bool SelectOnDoubleClick(void) const;
	bool SelectOnDownClick(void) const;
	const ZafIChar *SendMessageText(void) const;
	bool SendMessageWhenSelected(void) const;
	ZafStringData *StringData(void) const;
	virtual const ZafIChar *Text(void);
	ZafEventType Value(void) const;
	// set
	virtual void ClearImage(void);
	virtual void ClearText(void);
	virtual bool SetAllowDefault(bool allowDefault);
	virtual bool SetAllowToggling(bool allowToggling);
	virtual bool SetAutoRepeatSelection(bool autoRepeatSelection);
	virtual bool SetAutoSize(bool autoSize);
	virtual ZafError SetBitmapData(ZafBitmapData *bitmapData);
	virtual ZafButtonType SetButtonType(ZafButtonType buttonType);
	virtual bool SetDepressed(bool depressed);
	virtual int SetDepth(int depth);
	virtual ZafIChar SetHotKey(ZafIChar hotKeyChar, int index = -1);
	virtual ZafHzJustify SetHzJustify(ZafHzJustify hzJustify);
	virtual bool SetSelectOnDoubleClick(bool selectOnDoubleClick);
	virtual bool SetSelectOnDownClick(bool selectOnDownClick);
	virtual const ZafIChar *SetSendMessageText(const ZafIChar *text);
	virtual bool SetSendMessageWhenSelected(bool sendMessageWhenSelected);
	virtual ZafError SetStringData(ZafStringData *stringData);
	virtual ZafEventType SetValue(ZafEventType value);
	virtual ZafVtJustify SetVtJustify(ZafVtJustify vtJustify);

	// --- Window object members ---
	virtual void ConvertCoordinates(ZafCoordinateType coordinateType);
	virtual ZafEventType Event(const ZafEventStruct &event);
	ZafLogicalEvent LogicalEvent(const ZafEventStruct &event);
	virtual ZafRegionStruct Region(void) const;
	virtual ZafCoordinateType SetCoordinateType(ZafCoordinateType coordinateType);
	virtual bool SetParentPalette(bool parentPalette);
	virtual void SetRegion(const ZafRegionStruct &region);
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);
	virtual bool SetSelected(bool selected);
	virtual ZafError SetText(const ZafIChar *text);
	virtual bool SetVisible(bool visible);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }

protected:
	// --- General members ---
	ZafEventType value;
	ZafIChar *sendMessageText;
	ZafStringData *stringData;
	ZafBitmapData *bitmapData;
	int depth;

	bool allowDefault;
	bool allowToggling;
	bool autoRepeatSelection;
	bool autoSize;
	ZafButtonType buttonType;
	bool depressed;
	ZafIChar hotKeyChar;
	int hotKeyIndex;
	bool selectOnDoubleClick;
	bool selectOnDownClick;
	bool sendMessageWhenSelected;
	ZafHzJustify hzJustify;
	ZafVtJustify vtJustify;

	virtual ZafEventType DragDropEvent(const ZafEventStruct &event);
	virtual ZafEventType DrawBorder(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType DrawFocus(ZafRegionStruct &region, ZafEventType ccode);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual ZafEventType DrawShadow(ZafRegionStruct &region, int depth, ZafEventType ccode);
	virtual ZafWindowObject *Duplicate(void);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);
	ZafRegionStruct ComputeDrawRegions(ZafRegionStruct &drawRegion,
		ZafRegionStruct &imageRegion, ZafRegionStruct &textRegion,
		int margin = 0);

	// --- Data access ---
	static ZafError UpdateBitmap(ZafButton *button, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return button->OSSetImage();
		  else if (type == ZAF_UPDATE_DATA) return (ZAF_ERROR_NONE);
		  else return (ZAF_ERROR_INVALID); }
	static ZafError UpdateString(ZafButton *button, ZafUpdateType type)
		{ if (type == ZAF_UPDATE_OBJECT) return button->OSSetText();
		  else if (type == ZAF_UPDATE_DATA) return (ZAF_ERROR_NONE);
		  else return (ZAF_ERROR_INVALID); }

	// --- Special OS members ---
	virtual ZafEventType OSEvent(const ZafEventStruct &event);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetImage(void);
	virtual ZafError OSSetText(void);
	virtual void OSSize(void);

	// --- Persistent members ---
	void ReadData(ZafObjectPersistence &persist);
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafButton::Read); }
	void WriteData(ZafObjectPersistence &persist);

	// --- Image support ---
	static char ZAF_FARDATA checkName[];
	static char ZAF_FARDATA checkSelectedName[];
	static char ZAF_FARDATA radioName[];
	static char ZAF_FARDATA radioSelectedName[];
	static ZafBitmapData *checkBitmap;
	static ZafBitmapData *checkSelectedBitmap;
	static ZafBitmapData *radioBitmap;
	static ZafBitmapData *radioSelectedBitmap;
	static void ImageAllocate(void);
	static void ImageFree(bool globalRequest = false);

private:
	friend class ZAF_EXPORT OSButton;

	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];
	static ZafEventMap ZAF_FARDATA defaultEventMap[];
	ZafRegionStruct saveRegion;

#	if defined(ZAF_MSWINDOWS)
	bool OSDrawable(void);
#	elif defined(ZAF_MOTIF)
	XtIntervalId intervalID;
	ZafPositionStruct lastMousePosition;
	static void Repeat(ZafButton *object, XtIntervalId *intervalID);
#	endif
};

const int ZAF_DEFBTN_MARGIN = 5;

// --- inline functions ---
inline ZafBitmapData *ZafButton::BitmapData(void) const { return (bitmapData); }
inline ZafEventType ZafButton::Value(void) const { return (value); }
inline bool ZafButton::AllowDefault(void) const { return allowDefault; }
inline bool ZafButton::AllowToggling(void) const { return allowToggling; }
inline bool ZafButton::AutoRepeatSelection(void) const { return autoRepeatSelection; }
inline bool ZafButton::AutoSize(void) const { return autoSize; }
inline ZafButtonType ZafButton::ButtonType(void) const { return buttonType; }
inline bool ZafButton::Depressed(void) const { return depressed; }
inline int ZafButton::Depth(void) const { return depth; }
inline ZafIChar ZafButton::HotKeyChar(void) const { return hotKeyChar; }
inline int ZafButton::HotKeyIndex(void) const { return hotKeyIndex; }
inline ZafHzJustify ZafButton::HzJustify(void) const { return hzJustify; }
inline bool ZafButton::SelectOnDoubleClick(void) const { return selectOnDoubleClick; }
inline bool ZafButton::SelectOnDownClick(void) const { return selectOnDownClick; }
inline const ZafIChar *ZafButton::SendMessageText(void) const { return sendMessageText; }
inline bool ZafButton::SendMessageWhenSelected(void) const { return sendMessageWhenSelected; }
inline ZafStringData *ZafButton::StringData(void) const { return (stringData); }
inline ZafVtJustify ZafButton::VtJustify(void) const { return vtJustify; }

#endif // Z_BUTTON_HPP

