//	Zinc Application Framework - Z_BORDER.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_BORDER_HPP)
#define Z_BORDER_HPP
#include <z_win.hpp>
#include <z_mouse.hpp>

// --------------------------------------------------------------------------
// ----- ZafBorder ----------------------------------------------------------
// --------------------------------------------------------------------------

class ZAF_EXPORT ZafBorder : public ZafWindowObject
{
public:
	// --- General members ---
	ZafBorder(void);
	ZafBorder(const ZafBorder &copy);
	virtual ~ZafBorder(void);

	// --- Persist members ---
	ZafBorder(const ZafIChar *name, ZafObjectPersistence &persist);
	static ZafElement *Read(const ZafIChar *name, ZafObjectPersistence &persist);
	virtual void Write(ZafObjectPersistence &persist);

	// --- Attributes & data access ---
	// get
	int Width(void);
	// set
	virtual ZafError SetWidth(int width);

	// --- Window object members ---
	virtual ZafEventType Event(const ZafEventStruct &event);
	virtual bool SetAcceptDrop(bool acceptDrop);
	virtual bool SetBordered(bool bordered);
	virtual bool SetCopyDraggable(bool copyDraggable);
	virtual bool SetDisabled(bool disabled);
	virtual bool SetFocus(bool currentFocus);
	virtual ZafLogicalFont SetFont(ZafLogicalFont font);
	virtual const ZafIChar *SetHelpContext(const ZafIChar *helpContext);
	virtual const ZafIChar *SetHelpObjectTip(const ZafIChar *helpObjectTip);
	virtual bool SetLinkDraggable(bool linkDraggable);
	virtual bool SetMoveDraggable(bool moveDraggable);
	virtual bool SetNoncurrent(bool noncurrent);
	virtual bool SetParentDrawBorder(bool parentDrawBorder);
	virtual bool SetParentDrawFocus(bool parentDrawFocus);
	virtual bool SetParentPalette(bool parentPalette);
	virtual const ZafIChar *SetQuickTip(const ZafIChar *quickTip);
	virtual ZafRegionType SetRegionType(ZafRegionType regionType);
	virtual bool SetSelected(bool selected);
	virtual bool SetSupportObject(bool supportObject);
	virtual ZafLogicalColor SetTextColor(ZafLogicalColor color, ZafLogicalColor mono = ZAF_MONO_NULL);
	virtual ZafUserFunction SetUserFunction(ZafUserFunction userFunction);

	// --- Class identification ---
	static ZafClassID classID;
	static ZafClassNameChar ZAF_FARDATA className[];
	virtual ZafClassID ClassID(void) const { return (classID); }
	virtual ZafClassName ClassName(void) const { return (className); }
	virtual bool IsA(ZafClassID compareID) const { return ((compareID == classID) ? true : ZafWindowObject::IsA(compareID)); }
	virtual bool IsA(ZafClassName compareName) const { return ((compareName == className) ? true : ZafWindowObject::IsA(compareName)); }

protected:
	friend class ZAF_EXPORT OSBorder;

	// --- General members ---
	static int width;

	virtual ZafWindowObject *Duplicate(void);
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
	virtual void GetClip(ZafWindowObject *object, ZafRegionStruct &clip, ZafRegionStruct &virtualRegion);
	virtual const ZafPaletteStruct *MapClassPalette(ZafPaletteType type, ZafPaletteState state);

	// --- Special OS members ---
	virtual ZafError OSGetWidth(void);
	virtual void OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state);
	virtual void OSRegisterObject(void);
	virtual ZafError OSSetWidth(void);
	virtual void OSSize(void);
	virtual ZafError OSUpdatePalettes(ZafPaletteType zafTypes, ZafPaletteType osTypes);

private:
	static ZafPaletteMap ZAF_FARDATA defaultPaletteMap[];

	// --- Flag members ---
	bool SizeLeft(ZafRawCode sizeFlags) const { return ((sizeFlags & ZAF_SIZE_LEFT) ? true : false); }
	bool SizeTop(ZafRawCode sizeFlags) const { return ((sizeFlags & ZAF_SIZE_TOP) ? true : false); }
	bool SizeRight(ZafRawCode sizeFlags) const { return ((sizeFlags & ZAF_SIZE_RIGHT) ? true : false); }
	bool SizeBottom(ZafRawCode sizeFlags) const { return ((sizeFlags & ZAF_SIZE_BOTTOM) ? true : false); }

	// --- Persist members ---
	virtual ZafObjectConstructor ReadFunction(void) { return (ZafBorder::Read); }
};

#endif // Z_BORDER_HPP

