# Zinc Application Framework - ZAFMSC.MAK
# COPYRIGHT (C) 1990-1997.  All Rights Reserved.
# Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#############################################################################
#
# "zafmsc.mak" is the second in a series of three make files used to easily
# build ZAF projects from the command prompt -- it should not be invoked
# directly.  This file is also used when building the ZAF libraries.
#
# The three files used to build ZAF projects are:
# 1. makefile.mak - User supplied make file (see example below)
# 2. zafmsc.mak   - The main ZAF make file unique to each compiler
# 3. optsmsc.mak  - Compiler options and tools shared by ZAF and apps
#
# Your main make file should take the following form (example only):
#
# --- makefile.mak ----------------------------------------------------------
# # Define macros used by main make file
# ZAF_ROOT = c:\zaf500
# PLATFORM = WIN32
# TARGET_TYPE = EXEDLL
# TARGET = myapp.exe
# SOURCE_FILES = myapp1.cpp myapp2.cpp
# DEFINITION_FILE = myapp.def
# RESOURCE_FILE = bitmaps.rc
# DEBUG = off
#
# # Chain to main make file
# !include "$(ZAF_ROOT)\include\zafmsc.mak"
# ---------------------------------------------------------------------------
#
# Macro options and descriptions:
#
# ZAF_ROOT        - Root directory of the ZAF installation
#
# PLATFORM        - Target platform supported by this make file
#      options:   WIN32     - 32 bit windows
#                 WIN16     - 16 bit windows
#
# TARGET_TYPE     - The type target to be built
#      options:   EXE       - Executable file statically linked with ZAF
#                 EXEDLL    - Executable file dynamically linked with ZAF
#                 LIB       - Library file
#                 LIBDLL    - Library that calls functions in a ZAF DLL
#                 DLL       - Dynamically linked library file
#
# TARGET          - Name of the target file
#
# SOURCE_FILES    - Source files needed to build the target
#
# IMPORT_LIBRARY (DLLs only)
#                 - Name of import library used with DLL
#
# PERSISTENCE (optional)
#                 - Persistance jump table control.
#      options:   none      - No objects in jump table (default)
#                 all       - All objects in jump table
#                 user      - Jump table provided by user
#
# ADD_OBJECT_FILES (optional)
#                 - Additional object files, if any
#
# ADD_LIBRARIES (optional)
#                 - Additional libraries, if any
#
# DEFINITION_FILE (optional)
#                 - Windows definition file, if any
#
# RESOURCE_FILE (optional)
#                 - Windows Resource file, if any
#
# DEBUG (optional)
#                 - Build with debug information
#      options:   off       - No debug information (default)
#                 on        - Debug information included
#
#############################################################################


#
# Make sure all of the necessary macros are defined.
#
!ifndef ZAF_ROOT
error:
	@ECHO ERROR: "ZAF_ROOT" not defined.
!elseifndef TARGET
error:
	@ECHO ERROR: "TARGET" not defined.
!elseifndef TARGET_TYPE
error:
	@ECHO ERROR: "TARGET_TYPE" not defined.
!elseifndef PLATFORM
error:
	@ECHO ERROR: "PLATFORM" not defined.
!elseifndef SOURCE_FILES
error:
	@ECHO ERROR: "SOURCE_FILES" not defined.
!endif
!ifndef ADD_LIBRARIES
ADD_LIBRARIES=
!endif
!ifndef ADD_OBJECT_FILES
ADD_OBJECT_FILES=
!endif
!ifndef DEFINITION_FILE
DEFINITION_FILE=
!endif
!ifndef RESOURCE_FILE
RESOURCE_FILE=
!endif

#
# Include the microsoft C/C++ compiler options.
#
!include "$(ZAF_ROOT)\include\optsmsc.mak"

#
# Define the target macros.
#
!if "$(PLATFORM)" == "WIN16"

#
# Windows 16 bit macros.
#
!if "$(TARGET_TYPE)" == "EXE" || "$(TARGET_TYPE)" == "LIB"
OBJECT_FILE_EXTENSION=.ob1
COMPILER=$(W16_COMPILER)
COMPILE_OPTIONS=$(W16_COMPILE_OPTIONS)
LINKER=$(W16_LINKER)
LINK_OPTIONS=$(W16_LINK_OPTIONS)
LIBRARIAN=$(W16_LIBRARIAN)
LIBRARY_OPTIONS=$(W16_LIBRARY_OPTIONS)
RESOURCE_COMPILER=$(W16_RESOURCE_COMPILER)
RESOURCE_COMPILE_OPTIONS=$(W16_RESOURCE_OPTIONS)
OBJECT_FILES=$(W16_OBJECT_FILES) $(ADD_OBJECT_FILES)
LIBRARIES=$(W16_LIBRARIES) $(ADD_LIBRARIES)

#
# Invalid target type.
#
!else
error:
	@ECHO ERROR: Invalid target type: $(TARGET_TYPE)
!endif

!elseif "$(PLATFORM)" == "WIN32"
#
# Windows 32 bit macros (statically linked executable or library)
#
!if "$(TARGET_TYPE)" == "EXE" || "$(TARGET_TYPE)" == "LIB"
OBJECT_FILE_EXTENSION=.obw
COMPILER=$(W32_COMPILER)
COMPILE_OPTIONS=$(W32_COMPILE_OPTIONS)
LINKER=$(W32_LINKER)
LINK_OPTIONS=$(W32_LINK_OPTIONS)
LIBRARIAN=$(W32_LIBRARIAN)
LIBRARY_OPTIONS=$(W32_LIBRARY_OPTIONS)
RESOURCE_COMPILER=$(W32_RESOURCE_COMPILER)
RESOURCE_COMPILE_OPTIONS=$(W32_RESOURCE_OPTIONS)
OBJECT_FILES=$(W32_OBJECT_FILES) $(ADD_OBJECT_FILES)
LIBRARIES=$(W32_LIBRARIES) $(ADD_LIBRARIES)

#
# Windows 32 bit macros (dynamically linked executable or library)
#
!elseif "$(TARGET_TYPE)" == "EXEDLL" || "$(TARGET_TYPE)" == "LIBDLL"
OBJECT_FILE_EXTENSION=.obi
COMPILER=$(W32_COMPILER)
COMPILE_OPTIONS=$(W32_DLL_IMPORT_COMPILE_OPTIONS)
LINKER=$(W32_LINKER)
LINK_OPTIONS=$(W32_LINK_OPTIONS)
LIBRARIAN=$(W32_LIBRARIAN)
LIBRARY_OPTIONS=$(W32_LIBRARY_OPTIONS)
RESOURCE_COMPILER=$(W32_RESOURCE_COMPILER)
RESOURCE_COMPILE_OPTIONS=$(W32_RESOURCE_OPTIONS)
OBJECT_FILES=$(W32_DLL_IMPORT_OBJECT_FILES) $(ADD_OBJECT_FILES)
LIBRARIES=$(W32_DLL_IMPORT_LIBRARIES) $(ADD_LIBRARIES)

#
# Windows 32 bit DLL macros.
#
!elseif "$(TARGET_TYPE)" == "DLL"
OBJECT_FILE_EXTENSION=.obx
COMPILER=$(W32_COMPILER)
COMPILE_OPTIONS=$(W32_DLL_EXPORT_COMPILE_OPTIONS)
LINKER=$(W32_LINKER)
LINK_OPTIONS=$(W32_DLL_LINK_OPTIONS)
LIBRARIAN=$(W32_LIBRARIAN)
LIBRARY_OPTIONS=$(W32_LIBRARY_OPTIONS)
RESOURCE_COMPILER=$(W32_RESOURCE_COMPILER)
RESOURCE_COMPILE_OPTIONS=$(W32_RESOURCE_OPTIONS)
OBJECT_FILES=$(W32_DLL_EXPORT_OBJECT_FILES) $(ADD_OBJECT_FILES)
LIBRARIES=$(W32_DLL_EXPORT_LIBRARIES) $(ADD_LIBRARIES)

#
# Invalid target type.
#
!else
error:
	@ECHO ERROR: Invalid target type: $(TARGET_TYPE)
!endif

#
# Invalid platform
#
!else
error:
	@ECHO ERROR: Invalid platform: $(PLATFORM)
!endif

!if "$(OBJECT_FILE_EXTENSION)" == ".obw"
OBJECT_FILE_NAMES=$(SOURCE_FILES:cpp=obw)
!elseif "$(OBJECT_FILE_EXTENSION)" == ".obx"
OBJECT_FILE_NAMES=$(SOURCE_FILES:cpp=obx)
!elseif "$(OBJECT_FILE_EXTENSION)" == ".obi"
OBJECT_FILE_NAMES=$(SOURCE_FILES:cpp=obi)
!endif

#
# Explicit rule for building executables.
#
!if "$(TARGET_TYPE)" == "EXE" || "$(TARGET_TYPE)" == "EXEDLL"
$(TARGET): $(OBJECT_FILE_NAMES)
	$(LINKER) $(LINK_OPTIONS) /DEF:$(DEFINITION_FILE) -out:$(TARGET) @<<
$(OBJECT_FILE_NAMES) $(OBJECT_FILES) $(LIBRARIES)
<<
!endif

#
# Explicit rule for building DLL's
#
!if "$(TARGET_TYPE)" == "DLL"
$(TARGET): $(OBJECT_FILE_NAMES)
	$(LINKER) $(LINK_OPTIONS) /DEF:$(DEFINITION_FILE) -out:$(TARGET) /IMPLIB:$(IMPORT_LIBRARY) @<<
$(OBJECT_FILE_NAMES) $(OBJECT_FILES) $(LIBRARIES)
<<
!endif

#
# Explicit rule for building libraries.
#
!if "$(TARGET_TYPE)" == "LIB" || "$(TARGET_TYPE)" == "LIBDLL"
$(TARGET): $(OBJECT_FILE_NAMES)
	-@del $(TARGET)
	$(LIBRARIAN) /out:$(TARGET) $(LIBRARY_OPTIONS) @<<
$(OBJECT_FILE_NAMES)
<<
!endif
