//	Zinc Application Framework - W_ENV.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#ifndef W_ENV_HPP
#define W_ENV_HPP

// User Options:
#if !defined(__WATCOMC__)
#define ZAF_MSWINDOWS_3D
#endif

#if defined(ZAF_UNICODE)
#	define UNICODE
#endif

#if defined(__NT__) && !defined(WIN32)
#	define WIN32 __NT__
#endif

#define ZAF_LOCAL_FILE_STATICS

// ----- Compiler/Environment Default Dependencies --------------------------

#define ZAF_MSWINDOWS	WINVER
#if defined(__WIN32__) || defined(WIN32)
#	if defined(__WIN32__)
#		define ZAF_WIN32	__WIN32__
#	else
#		define ZAF_WIN32	WIN32
#	endif	
#	if defined(ZAF_DLL_EXPORT)
#		define ZAF_EXPORT		__declspec(dllexport)
#		if defined(ZAF_SHARED_DATA)
#			if defined(__BORLANDC__)
//???#   			pragma option -zRZAF_SHAREDATA
//???#   			pragma option -zSZAF_SHAREGROUP
//???#   			pragma option -zTZAF_SHARECLASS
#			elif defined(_MSC_VER)
#			elif defined(__WATCOMC__)
#			elif defined(__SC__)
#			else
#				???? define shared data segment.
#			endif
#		endif  
#	elif defined(ZAF_DLL_IMPORT)
#		define ZAF_EXPORT		__declspec(dllimport)
#	else
#		define ZAF_EXPORT
#	endif
#	define ZAF_FARDATA
#else
#	if defined(__BORLANDC__)
#		pragma option -zEZAF_FARDATA
#	else
#		pragma data_seg("ZAF_FARDATA")
#	endif
#	define ZAF_FARDATA		far
#	define ZAF_EXPORT
#endif

#define ZAF_LITTLEENDIAN
#define ZAF_LINKBUG
#if defined(ZAF_WIN32)
#	define ZAF_WORD_SIZE	   	32
#	define ZAF_BIGNUM_SIZE		16
#else
#	define ZAF_WORD_SIZE	   	16
#	define ZAF_BIGNUM_SIZE		16
#endif
#define ZAF_SIGNED_CHAR

// ----- bool, true/false ---------------------------------------------------

#if (defined(__BORLANDC__) && __BORLANDC__ < 0x0500) || \
	(defined(_MSC_VER) && _MSC_VER < 1100) || \
	(defined(__WATCOMC__) && __WATCOMC__ < 1100)
#	if defined (_MSC_VER)
#	define bool boolType
#	endif
typedef int bool;
#	if !defined(true)
#		define true 1
#	endif
#	if !defined(false)
#		define false 0
#	endif
#endif

// ----- Includes -----------------------------------------------------------

#define STRICT
#if defined(ZAF_WIN32)
#	define WINVER 0x0400
#	include <windows.h>
#	include <commctrl.h>
#else
#	include <windows.h>
#	include <commdlg.h>
#endif

#if defined(STRICT)
#	define WINDOWSPROC	WNDPROC
#else
#	define WINDOWSPROC	FARPROC
#endif

// ----- Miscelleneous ------------------------------------------------------

typedef char OSAPIChar;
typedef HBITMAP OSBitmapID;
typedef COLORREF OSColor;
typedef HCURSOR OSCursorID;
typedef HDC OSDisplayContext;
typedef HWND OSDrawContext;
typedef MSG OSEventStruct;
typedef HFONT OSFont;
typedef HICON OSIconID;
typedef int OSLineStyle;
typedef struct
{
	HBITMAP hBitmap;
	HPALETTE hPalette;
} OSImageID;
typedef struct
{
	int binary;
	DWORD ternary;
} OSMode;
typedef COLORREF OSMono;
typedef HCURSOR OSMouseID;
typedef HBITMAP OSFillPattern;
typedef POINT OSPosition;
typedef RECT OSRegion;
typedef HWND OSWindowID;
typedef WORD OSTimerHandle;

struct OSPaletteID
{
	COLORREF colorForeground;
	COLORREF colorBackground;
};

#define ID_ZAF_DIRECT 	(OSWindowID)0
#define ID_ZAF_SCREEN 	(OSWindowID)-1


// ----- Windows95 support --------------------------------------------------

#if !defined(WM_NOTIFY)
#	define WM_NOTIFY 0x004E
	typedef struct tagNMHDR
	{
		HWND hwndFrom;
		UINT idFrom;
		UINT code;
	} NMHDR;
#endif

#if !defined(TOOLBARCLASSNAME)
#	ifdef _WIN32
#		define TOOLBARCLASSNAMEW		L"ToolbarWindow32"
#		define TOOLBARCLASSNAMEA		"ToolbarWindow32"
#		ifdef  UNICODE
#			define TOOLBARCLASSNAME		TOOLBARCLASSNAMEW
#		else
#			define TOOLBARCLASSNAME		TOOLBARCLASSNAMEA
#		endif
#	else
#		define TOOLBARCLASSNAME			"ToolbarWindow"
#	endif
#endif

#if !defined(TRACKBAR_CLASS)
#	ifdef _WIN32
#		define TRACKBAR_CLASSA         "msctls_trackbar32"
#		define TRACKBAR_CLASSW         L"msctls_trackbar32"
#		ifdef UNICODE
#			define  TRACKBAR_CLASS         TRACKBAR_CLASSW
#		else
#			define  TRACKBAR_CLASS         TRACKBAR_CLASSA
#		endif
#	else
#		define TRACKBAR_CLASS          "msctls_trackbar"
#	endif
#	define TBS_AUTOTICKS           0x0001
#	define TBS_VERT                0x0002
#	define TBS_HORZ                0x0000
#	define TBS_TOP                 0x0004
#	define TBS_BOTTOM              0x0000
#	define TBS_LEFT                0x0004
#	define TBS_RIGHT               0x0000
#	define TBS_BOTH                0x0008
#	define TBS_NOTICKS             0x0010
#	define TBS_ENABLESELRANGE      0x0020
#	define TBS_FIXEDLENGTH         0x0040
#	define TBS_NOTHUMB             0x0080
#	define TBM_GETPOS              (WM_USER)
#	define TBM_GETRANGEMIN         (WM_USER+1)
#	define TBM_GETRANGEMAX         (WM_USER+2)
#	define TBM_GETTIC              (WM_USER+3)
#	define TBM_SETTIC              (WM_USER+4)
#	define TBM_SETPOS              (WM_USER+5)
#	define TBM_SETRANGE            (WM_USER+6)
#	define TBM_SETRANGEMIN         (WM_USER+7)
#	define TBM_SETRANGEMAX         (WM_USER+8)
#	define TBM_CLEARTICS           (WM_USER+9)
#	define TBM_SETSEL              (WM_USER+10)
#	define TBM_SETSELSTART         (WM_USER+11)
#	define TBM_SETSELEND           (WM_USER+12)
#	define TBM_GETPTICS            (WM_USER+14)
#	define TBM_GETTICPOS           (WM_USER+15)
#	define TBM_GETNUMTICS          (WM_USER+16)
#	define TBM_GETSELSTART         (WM_USER+17)
#	define TBM_GETSELEND           (WM_USER+18)
#	define TBM_CLEARSEL            (WM_USER+19)
#	define TBM_SETTICFREQ          (WM_USER+20)
#	define TBM_SETPAGESIZE         (WM_USER+21)
#	define TBM_GETPAGESIZE         (WM_USER+22)
#	define TBM_SETLINESIZE         (WM_USER+23)
#	define TBM_GETLINESIZE         (WM_USER+24)
#	define TBM_GETTHUMBRECT        (WM_USER+25)
#	define TBM_GETCHANNELRECT      (WM_USER+26)
#	define TBM_SETTHUMBLENGTH      (WM_USER+27)
#	define TBM_GETTHUMBLENGTH      (WM_USER+28)
#endif

#if !defined(UPDOWN_CLASS)
#	ifdef _WIN32
#		define UPDOWN_CLASSA           "msctls_updown32"
#		define UPDOWN_CLASSW           L"msctls_updown32"
#		ifdef UNICODE
#			define  UPDOWN_CLASS           UPDOWN_CLASSW
#		else
#			define  UPDOWN_CLASS           UPDOWN_CLASSA
#		endif
#	else
#		define UPDOWN_CLASS            "msctls_updown"
#	endif
#	define UDS_WRAP                0x0001
#	define UDS_SETBUDDYINT         0x0002
#	define UDS_ALIGNRIGHT          0x0004
#	define UDS_ALIGNLEFT           0x0008
#	define UDS_AUTOBUDDY           0x0010
#	define UDS_ARROWKEYS           0x0020
#	define UDS_HORZ                0x0040
#	define UDS_NOTHOUSANDS         0x0080
#	define UDM_SETRANGE            (WM_USER+101)
#	define UDM_GETRANGE            (WM_USER+102)
#	define UDM_SETPOS              (WM_USER+103)
#	define UDM_GETPOS              (WM_USER+104)
#	define UDM_SETBUDDY            (WM_USER+105)
#	define UDM_GETBUDDY            (WM_USER+106)
#	define UDM_SETACCEL            (WM_USER+107)
#	define UDM_GETACCEL            (WM_USER+108)
#	define UDM_SETBASE             (WM_USER+109)
#	define UDM_GETBASE             (WM_USER+110)
#endif


#if !defined(COLOR_3DDKSHADOW)
#	define COLOR_3DDKSHADOW			21
#endif
#if !defined(COLOR_3DLIGHT)
#	define COLOR_3DLIGHT			22
#endif
#if !defined(COLOR_3DSHADOW)
#	define COLOR_3DSHADOW			COLOR_BTNSHADOW
#endif
#if !defined(COLOR_3DHILIGHT)
#	define COLOR_3DHILIGHT			COLOR_BTNHIGHLIGHT
#endif
#if !defined(COLOR_3DFACE)
#	define COLOR_3DFACE				COLOR_BTNFACE
#endif
#if !defined(DEFAULT_GUI_FONT)
#	define DEFAULT_GUI_FONT			SYSTEM_FONT
#endif
#if !defined(WS_EX_CLIENTEDGE)
#	define WS_EX_CLIENTEDGE         0x00000200
#endif
#if !defined(DEFAULT_GUI_FONT)
#	define DEFAULT_GUI_FONT			17
#endif

//VOID WINAPI InitCommonControls(VOID);

/* START BLOCK COMMENT
**	//??? Development Only
**	#define ZAF_DEBUG
**	#if defined ZAF_DEBUG
**	#	include <stdio.h>
**	extern ZAF_EXPORT FILE *debug;
**	#endif
END BLOCK COMMENT */

#if defined(ZAF_WIN32) && defined(ZAF_UNICODE)
#undef CallWindowProc
#define CallWindowProc ZafCallWindowProc

#undef DefFrameProc
#define DefFrameProc ZafDefFrameProc

#undef DefWindowProc
#define DefWindowProc ZafDefWindowProc

#undef DefMDIChildProc
#define DefMDIChildProc ZafDefMDIChildProc

#undef DispatchMessage
#define DispatchMessage ZafDispatchMessage

#undef GetClassLong
#define GetClassLong ZafGetClassLong

#undef GetMessage
#define GetMessage ZafGetMessage

#undef PeekMessage
#define PeekMessage ZafPeekMessage

#undef PostMessage
#define PostMessage ZafPostMessage

#undef SendMessage
#define SendMessage ZafSendMessage

#undef GetObject
#define GetObject ZafGetObject

#undef GetWindowLong
#define GetWindowLong ZafGetWindowLong

#undef SetWindowLong
#define SetWindowLong ZafSetWindowLong


#undef CreateWindowEx
#define CreateWindowEx ZafCreateWindowEx

#undef DrawText
#define DrawText ZafDrawText

#undef AppendMenu
#define AppendMenu ZafAppendMenu

#undef ModifyMenu
#define ModifyMenu ZafModifyMenu

#undef LoadCursor
#define LoadCursor ZafLoadCursor

#undef GetProfileString
#define GetProfileString ZafGetProfileString

#undef GetProfileInt
#define GetProfileInt ZafGetProfileInt

#endif

#endif
