# Zinc Application Framework - ZAFMSC.MAK
# COPYRIGHT (C) 1990-1997.  All Rights Reserved.
# Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#############################################################################
#
# "optsmsc.mak" is the third in a series of three make files used to easily
# build ZAF projects from the command prompt -- it should not be invoked
# directly.  This file is also used when building the ZAF libraries.
#
# The three files used to build ZAF projects are:
# 1. makefile.mak - User supplied make file (see example below)
# 2. zafbor.mak   - The main ZAF make file unique to each compiler
# 3. optsmsc.mak  - Compiler options and tools shared by ZAF and apps
#
# Applications and ZAF libraries should be build with identical compiler
# options to ensure compatibility.  If changes are made to this file the
# ZAF libraries should be rebuilt prior to building applications.
#
#############################################################################

#
# ----- Shared  options -----------------------------------------------------
#
.SUFFIXES : .c .cpp .obw .obx .obi

#
# Debug options
#
!if "$(DEBUG)" == "on"
# /Zi   - generate debugging information
DEBUG_COMPILE_OPTIONS=/Zi
DEBUG_LINK_OPTIONS=/DEBUG:MAPPED,FULL /DEBUGTYPE:CV
!else
DEBUG_COMPILE_OPTIONS=
DEBUG_LINK_OPTIONS=
!endif

#
# Compile options
#
# /c    - compile only, no link
# /D    - define macro
SHARED_COMPILE_OPTIONS=$(DEBUG_COMPILE_OPTIONS) /c /DWIN32

#
# Link options
#
SHARED_LINK_OPTIONS=$(DEBUG_LINK_OPTIONS) /subsystem:windows

#
# Library options
#
SHARED_LIBRARY_OPTIONS=$(DEBUG_LIBRARY_OPTIONS) /machine:i386 /subsystem:WINDOWS

#
# ----- 32 bit Windows options ----------------------------------------------
#

W32_COMPILER=cl
W32_LINKER=link
W32_LIBRARIAN=lib
W32_RESOURCE_COMPILER=rc

W32_COMPILE_OPTIONS=$(SHARED_COMPILE_OPTIONS)
W32_LINK_OPTIONS=$(SHARED_LINK_OPTIONS)
W32_LIBRARY_OPTIONS=$(SHARED_LIBRARY_OPTIONS)
W32_RESOURCE_OPTIONS=

W32_OBJECT_FILES=

!if "$(PERSISTENCE)" == "none" || "$(PERSISTENCE)" == ""
PERSIST_LIBRARY32=
!elseif "$(PERSISTENCE)" == "all"
PERSIST_LIBRARY32= zafw32p.lib
!endif
W32_LIBRARIES=zafw32.lib $(PERSIST_LIBRARY32) libc.lib winspool.lib \
	kernel32.lib user32.lib gdi32.lib comctl32.lib comdlg32.lib oldnames.lib \
	ctl3d32.lib


#
# ----- 32 bit Windows DLL options ------------------------------------------
#

# /MD   - Link with MSVCRT.lib
# /D    - define macro
W32_DLL_EXPORT_COMPILE_OPTIONS=$(SHARED_COMPILE_OPTIONS) /MD /DZAF_DLL_EXPORT

# /MD   - Link with MSVCRT.lib
# /D    - define macro
W32_DLL_IMPORT_COMPILE_OPTIONS=$(SHARED_COMPILE_OPTIONS) /MD /DZAF_DLL_IMPORT

# -Tpd  - Build a Windows .DLL file 
# -aa   - Specifies application target type as Windows
W32_DLL_LINK_OPTIONS=$(SHARED_LINK_OPTIONS) /DLL

W32_DLL_EXPORT_OBJECT_FILES=
W32_DLL_EXPORT_LIBRARIES=kernel32.lib user32.lib gdi32.lib comctl32.lib \
	oldnames.lib ctl3d32.lib comdlg32.lib msvcrt.lib winspool.lib

W32_DLL_IMPORT_OBJECT_FILES=
W32_DLL_IMPORT_LIBRARIES=zafw32i.lib zafw32d.lib \
	kernel32.lib user32.lib gdi32.lib comctl32.lib oldnames.lib \
	ctl3d32.lib comdlg32.lib msvcrt.lib

#
# Impicit rule for building object files.
#

.cpp.obw:
	$(W32_COMPILER) $(W32_COMPILE_OPTIONS) /Fo$*.obw $<
.cpp.obx:
	$(W32_COMPILER) $(W32_DLL_EXPORT_COMPILE_OPTIONS) /Fo$*.obx $<
.cpp.obi:
	$(W32_COMPILER) $(W32_DLL_IMPORT_COMPILE_OPTIONS) /Fo$*.obi $<
