//	Zinc Application Framework - Z_WIN3.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_win.hpp>
#include <z_border.hpp>
#include <z_max.hpp>
#include <z_min.hpp>
#include <z_sys.hpp>
#include <z_title.hpp>

ZafWindow *ZafWindow::AddGenericObjects(ZafStringData *title, ZafWindowObject *minObject)
{
	// Add default window objects.
	if (minObject)
		Add(minObject);
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton(ZAF_NATIVE_SYSTEM_BUTTON));
	Add(new ZafTitle(title));

	// Return a pointer to the window.
	return (this);
}

