//	Zinc Application Framework - Z_WIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_win.hpp>
#include <z_mouse2.hpp>
#include <z_utils.hpp>

#if defined(ZAF_LOCAL_FILE_STATICS)
#define ZAF_WINDOW_INFO
#include "gbl_def.cpp"
#else
#if defined(ZAF_PERSIST_ALL)
#	include <zaf.hpp>
#endif
#include <z_winall.hpp>
#define ZAF_LOCAL_FILE_STATICS
#define ZAF_OBJECT_PERSISTENCE_INFO
#define ZAF_BIGNUM_INFO
#define ZAF_BORDER_INFO
#define ZAF_BUTTON_INFO
#define ZAF_COMBO_BOX_INFO
#define ZAF_DATE_INFO
#define ZAF_FORMATTED_STRING_INFO
#define ZAF_GROUP_INFO
#define ZAF_HZ_LIST_INFO
#define ZAF_ICON_INFO
#define ZAF_IMAGE_INFO
#define ZAF_INTEGER_INFO
#define ZAF_MAXIMIZE_BUTTON_INFO
#define ZAF_MINIMIZE_BUTTON_INFO
#define ZAF_NOTEBOOK_INFO
#define ZAF_POPUP_INFO
#define ZAF_PROMPT_INFO
#define ZAF_PROGRESS_BAR_INFO
#define ZAF_PULLDOWN_INFO
#define ZAF_REAL_INFO
#define ZAF_SCROLL_BAR_INFO
#define ZAF_SPIN_CONTROL_INFO
#define ZAF_STATUS_BAR_INFO
#define ZAF_STRING_INFO
#define ZAF_SYSTEM_BUTTON_INFO
#define ZAF_TABLE_INFO
#define ZAF_TEXT_INFO
#define ZAF_TIME_INFO
#define ZAF_TITLE_INFO
#define ZAF_TOOL_BAR_INFO
#define ZAF_TREE_INFO
#define ZAF_UTIME_INFO
#define ZAF_VT_LIST_INFO
#define ZAF_WINDOW_INFO
#define ZAF_GEOMETRY_INFO
#include "gbl_def.cpp"
#endif

// ----- ZafWindowManager ---------------------------------------------------

ZafWindowManager::ZafWindowManager(ZafExitFunction zExitFunction) :
	ZafWindow(0, 0, 0, 0),
	exitFunction(zExitFunction), dragObject(ZAF_NULLP(ZafWindowObject)),
	mouseObject(ZAF_NULLP(ZafWindowObject)), helpObject(ZAF_NULLP(ZafWindowObject))
{
	// Set the static variables.
	if (!ZafWindowObject::display)
		ZafWindowObject::display = zafDisplay;
	if (!ZafWindowObject::eventManager)
		ZafWindowObject::eventManager = zafEventManager;
	if (!ZafWindowObject::windowManager)
		ZafWindowObject::windowManager = this;

	// Initialize the window manager.
	zafRegion.coordinateType = ZAF_PIXEL;
	zafRegion.right = display->columns - 1;
	zafRegion.bottom = display->lines - 1;
	clientRegion = zafRegion;

	// Initialize the mouse cursor.
	eventManager->SetDeviceState(E_MOUSE, DM_VIEW);

#if defined(ZAF_MSDOS) || defined(ZAF_CURSES)
	// Initialize the display background.
	ZafRegionStruct drawRegion;
	drawRegion.Assign(0, 0, display->columns - 1, display->lines - 1);
	display->BeginDraw(ID_ZAF_SCREEN, 0, drawRegion, drawRegion);
	ZafPaletteStruct palette = LogicalPalette(ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE);
	display->SetPalette(palette);
	display->Rectangle(0, 0, display->columns - 1, display->lines - 1, 0, true);
	display->EndDraw();
#endif
}

void ZafWindowManager::Center(ZafWindowObject *object)
{
	// Change coordinates so we can work with the window.
	object->ConvertCoordinates(ZAF_PIXEL);

	// Check the window size.
	int columns = display->columns;
	int lines = display->lines;
	int width = object->zafRegion.Width();
	if (width > columns)
		width = (int)columns;
	int height = object->zafRegion.Height();
	if (height > lines)
		height = (int)lines;

	// Update the window according to the center position.
	object->zafRegion.left = (columns - width) / 2;
	object->zafRegion.top = (lines - height) / 2;
	object->zafRegion.right = object->zafRegion.left + width - 1;
	object->zafRegion.bottom = object->zafRegion.top + height - 1;

	// Re-display the window if it already is present on the screen.
	if (object->screenID)
		object->OSSize();
}

ZafWindowObject *ZafWindowManager::Duplicate(void)
{
	return (ZAF_NULLP(ZafWindowObject));
}

ZafWindowObject *ZafWindowManager::FocusObject(void) const
{
	// Return a pointer to self.
	if (first && First()->focus)
		return (First()->FocusObject());
	return (ZAF_NULLP(ZafWindowObject));
}

ZafWindowObject *ZafWindowManager::GetObject(ZafNumberID matchID)
{
	// Search the list of children.
	ZafWindowObject *match = ZAF_NULLP(ZafWindowObject);
	for (ZafWindowObject *object = First(); object && !match; object = object->Next())
		match = object->GetObject(matchID);
	return (match);
}

ZafWindowObject *ZafWindowManager::GetObject(const ZafIChar *matchID)
{
	// Check for a root directory separator.
	bool directory = false;
	if (*matchID == ZAF_DIRECTORY_SEPARATOR)
	{
		directory = true;
		matchID++;
	}

	// Re-point the arguments to do partial matching.
	ZafIChar parseID[ZAF_MAXNAMELEN];
	ZafIChar *tParseID = parseID;
	for ( ; *matchID && *matchID != ZAF_DIRECTORY_SEPARATOR; matchID++, tParseID++)
		*tParseID = *matchID;
	*tParseID = '\0';
	if (*matchID == ZAF_DIRECTORY_SEPARATOR)
	{
		directory = true;
		matchID++;
	}

	// Try to match with one of the children.
	ZafWindowObject *match = ZAF_NULLP(ZafWindowObject);
	for (ZafWindowObject *object = First(); object && !match; object = object->Next())
		if (!directory)
			match = object->GetObject(parseID);
		else if (!streq(parseID, object->StringID()))
			match = *matchID ? object->GetObject(matchID) : object;
	return (match);
}

ZafLogicalEvent ZafWindowManager::LogicalEvent(const ZafEventStruct &event)
{
	ZafLogicalEvent ccode = MapEvent(defaultEventMap, event);
	return ((ccode == L_NONE) ? ZafWindow::LogicalEvent(event) : ccode);
}

const ZafPaletteStruct *ZafWindowManager::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	return (MapPalette(defaultPaletteMap, type, state));
}

ZafWindowObject *ZafWindowManager::NotifyFocus(ZafWindowObject *focusObject, bool setFocus)
{
	// Remove focus from the current window without validation.
	if (Current() && Current() != focusObject && setFocus)
		Current()->NotifyFocus(ZAF_NULLP(ZafWindowObject), false);

	// Reset current object.
	if (setFocus)
	{
		// Move the object to the front of the list.
		if (focusObject != First())
		{
			ZafList::Subtract(focusObject);
			ZafList::Add(focusObject, First());
		}

		// Set the current pointer.
		ZafList::SetCurrent(focusObject);
	}

	// Validation is not performed at the window manager level.
	return (ZAF_NULLP(ZafWindowObject));
}

bool ZafWindowManager::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafWindowManager::SetAutomaticUpdate(bool )
{
	// automaticUpdate is true for this class.
	automaticUpdate = true;
	return (automaticUpdate);
}

bool ZafWindowManager::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

ZafExitFunction ZafWindowManager::SetExitFunction(ZafExitFunction tExitFunction)
{
	exitFunction = tExitFunction;
	return (exitFunction);
}

bool ZafWindowManager::SetOSDraw(bool )
{
	// osDraw is true for this class.
	osDraw = true;
	return (osDraw);
}

bool ZafWindowManager::SetParentDrawBorder(bool )
{
	// parentDrawBorder is false for this class.
	parentDrawBorder = false;
	return (parentDrawBorder);
}

bool ZafWindowManager::SetParentDrawFocus(bool )
{
	// parentDrawFocus is false for this class.
	parentDrawFocus = false;
	return (parentDrawFocus);
}

bool ZafWindowManager::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

ZafRegionType ZafWindowManager::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_AVAILABLE_REGION for this class.
	regionType = ZAF_AVAILABLE_REGION;
	return (regionType);
}

ZafSelectionType ZafWindowManager::SetSelectionType(ZafSelectionType )
{
	// selectionType is ZAF_SINGLE_SELECTION for this class.
	selectionType = ZAF_SINGLE_SELECTION;
	return (selectionType);
}

bool ZafWindowManager::SetTemporary(bool )
{
	// temporary is false for this class.
	temporary = false;
	return (temporary);
}

