//	Zinc Application Framework - Z_TITLE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_title.hpp>
#define ZAF_TITLE_INFO
#include "gbl_def.cpp"

ZafTitle *ZafWindow::Title(void) const
{
	for (ZafWindowObject *object = SupportFirst(); object; object = object->Next())
		if (object->NumberID() == ZAF_NUMID_TITLE)
			return (DynamicPtrCast(object, ZafTitle));
	return (ZAF_NULLP(ZafTitle));
}

// ----- ZafTitle -----------------------------------------------------------

static ZafStringIDChar ZAF_FARDATA _stringID[] = ZAF_ITEXT("ZAF_NUMID_TITLE");

ZafTitle::ZafTitle(ZafStringData *zStringData) :
#if defined(ZAF_MOTIF)
	ZafButton(0, 0, 0, 0, zStringData)
#else
	ZafButton(0, 0, 0, 0, zStringData, ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON)
#endif
{
	// Initialize the title information.
	SetBordered(false);
	SetAllowToggling(false);
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_AVAILABLE_REGION);
	SetNoncurrent(true);
	SetDepth(0);
	SetSelectOnDoubleClick(true);
	SetSelectOnDownClick(true);
	SetSendMessageWhenSelected(true);
	SetNumberID(ZAF_NUMID_TITLE);
	SetStringID(_stringID);
}

ZafTitle::ZafTitle(const ZafIChar *text) :
#if defined(ZAF_MOTIF)
	ZafButton(0, 0, 0, 0, text, ZAF_NULLP(ZafBitmapData))
#else
	ZafButton(0, 0, 0, 0, text, ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON)
#endif
{
	// Initialize the title information.
	SetBordered(false);
	SetAllowToggling(false);
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_AVAILABLE_REGION);
	SetNoncurrent(true);
	SetDepth(0);
	SetSelectOnDoubleClick(true);
	SetSelectOnDownClick(true);
	SetSendMessageWhenSelected(true);
	SetNumberID(ZAF_NUMID_TITLE);
	SetStringID(_stringID);
}

ZafTitle::ZafTitle(const ZafTitle &copy) :
	ZafButton(copy)
{
}

ZafTitle::~ZafTitle(void)
{
}

ZafWindowObject *ZafTitle::Duplicate(void)
{
	return (new ZafTitle(*this));
}

const ZafPaletteStruct *ZafTitle::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafButton::MapClassPalette(type, state));
}

bool ZafTitle::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafTitle::SetAllowDefault(bool )
{
	// allowDefault is false for this class.
	allowDefault = false;
	return (allowDefault);
}

bool ZafTitle::SetAllowToggling(bool )
{
	// allowToggling is false for this class.
	allowToggling = false;
	return (allowToggling);
}

bool ZafTitle::SetAutoRepeatSelection(bool )
{
	// autoRepeatSelection is false for this class.
	autoRepeatSelection = false;
	return (autoRepeatSelection);
}

bool ZafTitle::SetAutoSize(bool )
{
	// autoSize is true for this class.
	autoSize = true;
	return (autoSize);
}

ZafError ZafTitle::SetBitmapData(ZafBitmapData *)
{
	// bitmapData is null for this class.
	bitmapData = ZAF_NULLP(ZafBitmapData);
	return (ZAF_ERROR_INVALID);
}

bool ZafTitle::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

ZafButtonType ZafTitle::SetButtonType(ZafButtonType )
{
	// buttonType is ZAF_FLAT_BUTTON for this class.
	buttonType = ZAF_FLAT_BUTTON;
	return (buttonType);
}

bool ZafTitle::SetCopyDraggable(bool )
{
	// copyDraggable is false for this class.
	copyDraggable = false;
	return (copyDraggable);
}

bool ZafTitle::SetDepressed(bool )
{
	// depressed is false for this class.
	depressed = false;
	return (depressed);
}

int ZafTitle::SetDepth(int )
{
	// depth is 0 for this class.
	depth = 0;
	return (depth);
}

bool ZafTitle::SetDisabled(bool )
{
	// disabled is false for this class.
	disabled = false;
	return (disabled);
}

bool ZafTitle::SetFocus(bool )
{
	// focus is false for this class.
	focus = false;
	return (focus);
}

const ZafIChar *ZafTitle::SetHelpContext(const ZafIChar *)
{
	// help context is empty for this class.
	return (ZAF_NULLP(ZafIChar));
}

const ZafIChar *ZafTitle::SetHelpObjectTip(const ZafIChar *)
{
	// helpObjectTip cannot be set for this class.
	return (ZAF_NULLP(ZafIChar));
}

ZafIChar ZafTitle::SetHotKey(ZafIChar , int )
{
	// hotKeyChar and hotKeyIndex are null for this class.
	hotKeyChar = 0;
	hotKeyIndex = -1;
	return (hotKeyChar);
}

ZafHzJustify ZafTitle::SetHzJustify(ZafHzJustify )
{
	// hzJustify is ZAF_HZ_CENTER for this class.
	hzJustify = ZAF_HZ_CENTER;
	return (hzJustify);
}

bool ZafTitle::SetLinkDraggable(bool )
{
	// linkDraggable is false for this class.
	linkDraggable = false;
	return (linkDraggable);
}

bool ZafTitle::SetMoveDraggable(bool )
{
	// moveDraggable is false for this class.
	moveDraggable = false;
	return (moveDraggable);
}

bool ZafTitle::SetNoncurrent(bool )
{
	// noncurrent is true for this class.
	noncurrent = true;
	return (noncurrent);
}

bool ZafTitle::SetParentDrawBorder(bool )
{
	// parentDrawBorder is false for this class.
	parentDrawBorder = false;
	return (parentDrawBorder);
}

bool ZafTitle::SetParentDrawFocus(bool )
{
	// parentDrawFocus is false for this class.
	parentDrawFocus = false;
	return (parentDrawFocus);
}

bool ZafTitle::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

const ZafIChar *ZafTitle::SetQuickTip(const ZafIChar *)
{
	// quickTip cannot be set for this class.
	return (ZAF_NULLP(ZafIChar));
}

ZafRegionType ZafTitle::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_AVAILABLE_REGION for this class.
	regionType = ZAF_AVAILABLE_REGION;
	return (regionType);
}

bool ZafTitle::SetSelected(bool )
{
	// selected is false for this class.
	selected = false;
	return (selected);
}

bool ZafTitle::SetSelectOnDoubleClick(bool )
{
	// selectOnDoubleClick is true for this class.
	selectOnDoubleClick = true;
	return (selectOnDoubleClick);
}

bool ZafTitle::SetSelectOnDownClick(bool )
{
	// selectOnDownClick is true for this class.
	selectOnDownClick = true;
	return (selectOnDownClick);
}

bool ZafTitle::SetSendMessageWhenSelected(bool )
{
	// sendMessageWhenSelected is true for this class.
	sendMessageWhenSelected = true;
	memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
	return (sendMessageWhenSelected);
}

ZafEventType ZafTitle::SetValue(ZafEventType setValue)
{
	// value is either S_MAXIMIZE or S_RESTORE for this class.
	if (setValue == S_MAXIMIZE || setValue == S_RESTORE)
		value = setValue;
	return (value);
}

bool ZafTitle::SetSupportObject(bool )
{
	// SupportObject is automatically true for title.
	supportObject = true;
	return (supportObject);
}

ZafUserFunction ZafTitle::SetUserFunction(ZafUserFunction )
{
	// userFunction is null for this class.
	userFunction = ZAF_NULLF(ZafUserFunction);
	return (userFunction);
}

ZafVtJustify ZafTitle::SetVtJustify(ZafVtJustify )
{
	// vtJustify is ZAF_VT_CENTER for this class.
	vtJustify = ZAF_VT_CENTER;
	return (vtJustify);
}

// ----- Persistent functions -----------------------------------------------

ZafTitle::ZafTitle(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafButton(name, persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY))
{
	// Initialize the title information.
	SetBordered(false);
	SetButtonType(ZAF_FLAT_BUTTON);
	SetAllowToggling(false);
	SetSupportObject(true);
	SetSystemObject(false);
	SetRegionType(ZAF_AVAILABLE_REGION);
	SetNoncurrent(true);
	SetDepth(0);
	SetSelectOnDoubleClick(true);
	SetSelectOnDownClick(true);
	SetSendMessageWhenSelected(true);
	SetNumberID(ZAF_NUMID_TITLE);
	SetStringID(_stringID);

	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafTitle::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafTitle(name, persist));
}

void ZafTitle::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafButton::Write(persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

