//	Zinc Application Framework - Z_TBAR.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_tbar.hpp>
#define ZAF_TOOL_BAR_INFO
#include "gbl_def.cpp"

// ----- ZafToolBar ---------------------------------------------------------

ZafToolBar::ZafToolBar(int left, int top, int width, int height) :
	ZafWindow(left, top, width, height),
	dockType(ZAF_DOCK_TOP), wrapChildren(true)
{
	SetBordered(true);
	SetNoncurrent(true);
	SetRegionType(ZAF_AVAILABLE_REGION);
	SetSupportObject(true);
}

ZafToolBar::ZafToolBar(const ZafToolBar &copy) :
	ZafWindow(copy),
	dockType(copy.dockType), wrapChildren(copy.wrapChildren)
{
}

ZafToolBar::~ZafToolBar(void)
{
}

ZafWindowObject *ZafToolBar::Duplicate(void)
{
	return (new ZafToolBar(*this));
}

const ZafPaletteStruct *ZafToolBar::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafWindow::MapClassPalette(type, state));
}

bool ZafToolBar::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafToolBar::SetDestroyable(bool )
{
	// destroyable is false for this class.
	destroyable = false;
	return (destroyable);
}

ZafDockType ZafToolBar::SetDockType(ZafDockType setDockType)
{
	// Make sure the attribute has changed.
	if (dockType != setDockType && !screenID)
		dockType = setDockType;

	// Return the current attribute.
	return (dockType);
}

bool ZafToolBar::SetLocked(bool )
{
	// locked is false for this class.
	locked = false;
	return (locked);
}

bool ZafToolBar::SetMaximized(bool )
{
	// maximized is false for this class.
	maximized = false;
	return (maximized);
}

bool ZafToolBar::SetMinimized(bool )
{
	// minimized is false for this class.
	minimized = false;
	return (minimized);
}

bool ZafToolBar::SetMoveable(bool )
{
	// moveable is false for this class.
	moveable = false;
	return (moveable);
}

ZafRegionType ZafToolBar::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_AVAILABLE_REGION for this class.
	regionType = ZAF_AVAILABLE_REGION;
	return (regionType);
}

bool ZafToolBar::SetSizeable(bool )
{
	// sizeable is false for this class.
	sizeable = false;
	return (sizeable);
}

bool ZafToolBar::SetSupportObject(bool setSupportObject)
{
	// Make sure the attribute has changed.
	if (!parent && supportObject != setSupportObject)
		supportObject = setSupportObject;

	// Return the current attribute.
	return (supportObject);
}

bool ZafToolBar::SetTemporary(bool )
{
	// temporary is false for this class.
	temporary = false;
	return (temporary);
}

bool ZafToolBar::SetWrapChildren(bool setWrapChildren)
{
	// Make sure the attribute has changed.
	if (wrapChildren != setWrapChildren && !screenID)
		wrapChildren = setWrapChildren;

	// Return the current attribute.
	return (wrapChildren);
}

// ----- Persistent functions -----------------------------------------------

ZafToolBar::ZafToolBar(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafWindow(name, persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY))
{
	// Read the data.
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafToolBar::ReadData(persist);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafToolBar::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafToolBar(name, persist));
}

void ZafToolBar::ReadData(ZafObjectPersistence &persist)
{
	// Read the tool bar information.
	ZafUInt16 flag1, flag2;
	ZafFile *file = persist.CurrentFile();
	*file >> flag1 >> flag2;
	wrapChildren = (flag1 & 0x0001) ? true : false;
	dockType = (ZafDockType)((int)flag2 & 0x000F);
}

void ZafToolBar::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafWindow::Write(persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY));
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafToolBar::WriteData(persist);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

void ZafToolBar::WriteData(ZafObjectPersistence &persist)
{
	// Write the data.
	ZafUInt16 flag1 = 0, flag2 = 0;
	flag1 |= wrapChildren ? 0x0001 : 0;
	flag2 |= (ZafUInt16)(dockType & 0x000F);
	ZafFile *file = persist.CurrentFile();
	*file << flag1 << flag2;
}

