//	Zinc Application Framework - Z_POPUP1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_popup.hpp>
#include <z_string.hpp>
#include <z_app.hpp>
#define ZAF_POPUP_INFO
#include "lang_def.cpp"
#include "img_def.cpp"

static ZafStringID _menuName = ZAF_ITEXT("menu");

// ----- ZafPopUpItem -------------------------------------------------------

ZafPopUpItem::ZafPopUpItem(ZafStringData *zStringData, ZafPopUpItemType tItemType) :
	ZafButton(0, 0, zStringData ? strlen(zStringData->Text()) : 1, 1,
		zStringData, ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON),
	menu(0, 0), itemType(ZAF_NORMAL_ITEM)
{
	// Initialize the pop-up item information.
	SetAutoSize(false);

	// Check the image information.
	ImageAllocate();

	// Check the language and local information.
	LanguageAllocate();

	// Initialize the pop-up item information.
	SetItemType(tItemType);
	SetHzJustify(ZAF_HZ_LEFT);
	SetDepth(0);

	menu.parent = this;
	menu.SetStringID(_menuName);
}

ZafPopUpItem::ZafPopUpItem(const ZafIChar *text, ZafPopUpItemType tItemType) :
	ZafButton(0, 0, text ? strlen(text) : 1, 1, text, 
		ZAF_NULLP(ZafBitmapData), ZAF_FLAT_BUTTON),
	menu(0, 0), itemType(ZAF_NORMAL_ITEM)
{
	// Initialize the pop-up item information.
	SetAutoSize(false);

	// Check the image information.
	ImageAllocate();

	// Check the language and local information.
	LanguageAllocate();

	// Initialize the pop-up item information.
	SetItemType(tItemType);
	SetHzJustify(ZAF_HZ_LEFT);
	SetDepth(0);

	menu.parent = this;
	menu.SetStringID(_menuName);
}

ZafPopUpItem::ZafPopUpItem(const ZafPopUpItem &copy) :
	ZafButton(copy), menu(copy.menu),
	itemType(copy.itemType)
{
	// Check the image information.
	ImageAllocate();

	// Check the language and local information.
	LanguageAllocate();

	// Initialize the pop-up item information.
	menu.parent = this;
}

ZafPopUpItem::~ZafPopUpItem(void)
{
	// Free the image information.
	ImageFree();

	// Free the language information.
	LanguageFree();
}

ZafWindowObject *ZafPopUpItem::Duplicate(void)
{
	return (new ZafPopUpItem(*this));
}

ZafWindowObject *ZafPopUpItem::FocusObject(void) const
{
	// Return a pointer to self.
	if (menu.Focus())
		return (menu.Current() ? menu.FocusObject() : (ZafWindowObject *)&menu);
	else if (focus)
		return ((ZafWindowObject *)this);
	return (ZAF_NULLP(ZafWindowObject));
}

ZafWindowObject *ZafPopUpItem::GetObject(ZafNumberID zNumberID)
{
	ZafWindowObject *match = ZafWindowObject::GetObject(zNumberID);
	if (!match)
		match = menu.GetObject(zNumberID);
	return (match);
}

ZafWindowObject *ZafPopUpItem::GetObject(const ZafIChar *zStringID)
{
	ZafWindowObject *match = ZafWindowObject::GetObject(zStringID);
	if (!match)
		match = menu.GetObject(zStringID);
	return (match);
}

void ZafPopUpItem::ImageAllocate(void)
{
	// Initialize the images.
	if (!popupArrowBitmap)
	{
		ZafApplication::AddStaticModule(ImageFree);
		popupArrowBitmap = new ZafBitmapData(_popupArrow_ZafBitmap);
		popupArrowBitmap->staticHandle = true;
		popupArrowCurrentBitmap = new ZafBitmapData(_popupArrowCurrent_ZafBitmap);
		popupArrowCurrentBitmap->staticHandle = true;
		popupCheckBitmap = new ZafBitmapData(_popupCheck_ZafBitmap);
		popupCheckBitmap->staticHandle = true;
		popupCheckCurrentBitmap = new ZafBitmapData(_popupCheckCurrent_ZafBitmap);
		popupCheckCurrentBitmap->staticHandle = true;
	}
}

void ZafPopUpItem::ImageFree(bool globalRequest)
{
	// Destroy the static images.
	if (globalRequest && popupArrowBitmap)
	{
		popupArrowBitmap->staticHandle = false;
		delete popupArrowBitmap;
		popupArrowBitmap = ZAF_NULLP(ZafBitmapData);
		popupArrowCurrentBitmap->staticHandle = false;
		delete popupArrowCurrentBitmap;
		popupArrowCurrentBitmap = ZAF_NULLP(ZafBitmapData);
		popupCheckBitmap->staticHandle = false;
		delete popupCheckBitmap;
		popupCheckBitmap = ZAF_NULLP(ZafBitmapData);
		popupCheckCurrentBitmap->staticHandle = false;
		delete popupCheckCurrentBitmap;
		popupCheckCurrentBitmap = ZAF_NULLP(ZafBitmapData);
	}
}

void ZafPopUpItem::LanguageAllocate(void)
{
	// Check for initialization.
	if (language)
		return;
	ZafApplication::AddStaticModule(LanguageFree);

	// Try the zafDataManager.
	if (!language && zafDataManager)
		language = DynamicPtrCast(zafDataManager->AllocateData(className, ZafLanguageData::className, ZafLanguageData::classID), ZafLanguageData);

	// Default to code initialization.
	if (!language)
		language = new ZafLanguageData(defaultPopupStrings, true);
}

void ZafPopUpItem::LanguageFree(bool globalRequest)
{
	// Destroy the static language.
	if (globalRequest && language && language->Destroyable() &&
		language->NotifyCount() == 0)
	{
		delete language;
		language = ZAF_NULLP(ZafLanguageData);
	}
}

const ZafPaletteStruct *ZafPopUpItem::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafButton::MapClassPalette(type, state));
}

bool ZafPopUpItem::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafPopUpItem::SetAllowDefault(bool )
{
	// allowDefault is false for this class.
	allowDefault = false;
	return (allowDefault);
}

bool ZafPopUpItem::SetAutoRepeatSelection(bool )
{
	// autoRepeatSelection is false for this class.
	autoRepeatSelection = false;
	return (autoRepeatSelection);
}

bool ZafPopUpItem::SetAutoSize(bool )
{
	// autoSize is true for this class.
	autoSize = false;
	return (autoSize);
}

ZafError ZafPopUpItem::SetBitmapData(ZafBitmapData *)
{
	// bitmapData is null for this class.
	bitmapData = ZAF_NULLP(ZafBitmapData);
	return (ZAF_ERROR_INVALID);
}

bool ZafPopUpItem::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

ZafButtonType ZafPopUpItem::SetButtonType(ZafButtonType )
{
	// buttonType is ZAF_FLAT_BUTTON for this class.
	buttonType = ZAF_FLAT_BUTTON;
	return (buttonType);
}

bool ZafPopUpItem::SetCopyDraggable(bool )
{
	// copyDraggable is false for this class.
	copyDraggable = false;
	return (copyDraggable);
}

bool ZafPopUpItem::SetDepressed(bool )
{
	// depressed is false for this class.
	depressed = false;
	return (depressed);
}

int ZafPopUpItem::SetDepth(int )
{
	// depth is 0 for this class.
	depth = 0;
	return (depth);
}

ZafHzJustify ZafPopUpItem::SetHzJustify(ZafHzJustify )
{
	// hzJustify is ZAF_HZ_LEFT for this class.
	hzJustify = ZAF_HZ_LEFT;
	return (hzJustify);
}

ZafPopUpItemType ZafPopUpItem::SetItemType(ZafPopUpItemType newItemType)
{
	// Make sure the request is valid.
	if (itemType != newItemType && !screenID)
	{
		itemType = newItemType;

		// Check for special conditions.
		ZafIChar *message = ZAF_NULLP(ZafIChar);
		ZafIChar newHotKeyChar = 0;
		int newHotKeyIndex = -1;
		switch (itemType)
		{
		case ZAF_SEPARATOR:
			SetDisabled(true);
			SetNoncurrent(true);
			break;

		case ZAF_CLOSE_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_CLOSE);
			message = language->GetMessage(ZAF_CLOSE_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_MAXIMIZE_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_MAXIMIZE);
			message = language->GetMessage(ZAF_MAXIMIZE_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_MINIMIZE_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_MINIMIZE);
			message = language->GetMessage(ZAF_MINIMIZE_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_MOVE_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_MOVE_MODE);
			message = language->GetMessage(ZAF_MOVE_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_RESTORE_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_RESTORE);
			message = language->GetMessage(ZAF_RESTORE_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_SIZE_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_SIZE_MODE);
			message = language->GetMessage(ZAF_SIZE_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_COPY_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_COPY);
			message = language->GetMessage(ZAF_COPY_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_CUT_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_CUT);
			message = language->GetMessage(ZAF_CUT_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_PASTE_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_PASTE);
			message = language->GetMessage(ZAF_PASTE_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_EXIT_OPTION:
			memberUserFunction = (MemberUserFunction)&ZafButton::SendMessage;
			SetValue(S_EXIT);
			message = language->GetMessage(ZAF_EXIT_OPTION, false,
				&newHotKeyChar, &newHotKeyIndex);
			break;

		case ZAF_SWITCH_OPTION:
		case ZAF_ABOUT_OPTION:
		case ZAF_NORMAL_ITEM:
		default:
			break;
		}

		// Set the pop-up item information.
		if (message && stringData)
		{
			// Do not notify the data manager.
			ZafUpdateType updateType = stringData->Update(this);
			stringData->SetUpdate(this, ZAF_UPDATE_NONE);
			stringData->SetText(message);
			SetHotKey(newHotKeyChar, newHotKeyIndex);
			stringData->SetUpdate(this, updateType);
		}
	}
	return (itemType);
}

bool ZafPopUpItem::SetLinkDraggable(bool )
{
	// linkDraggable is false for this class.
	linkDraggable = false;
	return (linkDraggable);
}

bool ZafPopUpItem::SetMoveDraggable(bool )
{
	// moveDraggable is false for this class.
	moveDraggable = false;
	return (moveDraggable);
}

bool ZafPopUpItem::SetParentDrawBorder(bool )
{
	// parentDrawBorder is false for this class.
	parentDrawBorder = false;
	return (parentDrawBorder);
}

bool ZafPopUpItem::SetParentDrawFocus(bool )
{
	// parentDrawFocus is false for this class.
	parentDrawFocus = false;
	return (parentDrawFocus);
}

bool ZafPopUpItem::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

ZafRegionType ZafPopUpItem::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_INSIDE_REGION for this class.
	regionType = ZAF_INSIDE_REGION;
	return (regionType);
}

bool ZafPopUpItem::SetSelectOnDoubleClick(bool )
{
	// selectOnDoubleClick is false for this class.
	selectOnDoubleClick = false;
	return (selectOnDoubleClick);
}

bool ZafPopUpItem::SetSelectOnDownClick(bool )
{
	// selectOnDownClick is false for this class.
	selectOnDownClick = false;
	return (selectOnDownClick);
}

bool ZafPopUpItem::SetSupportObject(bool )
{
	// supportObject is false for this class.
	supportObject = false;
	return (supportObject);
}

ZafVtJustify ZafPopUpItem::SetVtJustify(ZafVtJustify )
{
	// vtJustify is ZAF_VT_CENTER for this class.
	vtJustify = ZAF_VT_CENTER;
	return (vtJustify);
}

// ----- Persistent functions -----------------------------------------------

ZafPopUpItem::ZafPopUpItem(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafButton(name, persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY)),
	menu(0, 0)
{
	// Check the image information.
	ImageAllocate();

	// Check the language and local information.
	LanguageAllocate();
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafPopUpItem::ReadData(persist);

	// Read the menu data.
	ZafIChar menuName[ZAF_MAXNAMELEN];
	ZafFile *file = persist.CurrentFile();
	*file >> menuName;
	if (*menuName)
	{
		menu.SetStringID(menuName);
		persist.PushLevel(menu.ClassName(), menu.ClassID(), ZAF_PERSIST_DIRECTORY);
		persist.AllocateFile(menu.StringID(), ZAF_FILE_READ);
		if (persist.Error() == ZAF_ERROR_NONE)
			menu.ZafWindowObject::ReadData(persist);
		if (persist.Error() == ZAF_ERROR_NONE)
			menu.ZafWindow::ReadData(persist);
		if (persist.Error() == ZAF_ERROR_NONE)
			menu.ZafWindow::ReadChildren(persist);
		persist.PopLevel();
	}
	menu.parent = this;

	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafPopUpItem::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafPopUpItem(name, persist));
}

void ZafPopUpItem::ReadData(ZafObjectPersistence &persist)
{
	// Read the data.
	ZafUInt16 flag1;
	ZafFile *file = persist.CurrentFile();
	*file >> flag1;
	itemType = (ZafPopUpItemType)flag1;
}

void ZafPopUpItem::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafButton::Write(persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY));
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafPopUpItem::WriteData(persist);

	// Write the menu data.
	const ZafIChar *menuName = menu.First() ? menu.StringID() : ZAF_NULLP(ZafIChar);
	ZafFile *file = persist.CurrentFile();
	*file << menuName;
	if (menu.First())
	{
		menu.Write(persist.PushLevel(menu.ClassName(), menu.ClassID(), ZAF_PERSIST_DIRECTORY));
		persist.PopLevel();
	}

	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

void ZafPopUpItem::WriteData(ZafObjectPersistence &persist)
{
	// Write the data.
	ZafUInt16 flag1 = (ZafUInt16)itemType;
	ZafFile *file = persist.CurrentFile();
	*file << flag1;
}

