//	Zinc Application Framework - Z_POPUP.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_popup.hpp>
#define ZAF_POPUP_INFO
#include "gbl_def.cpp"

// ----- ZafPopUpMenu -------------------------------------------------------

ZafPopUpMenu::ZafPopUpMenu(int left, int top) :
	ZafWindow(left, top, 0, 0)
{
	// Initialize the pop-up menu information.
	SetBordered(true);
	SetTemporary(true);
}

ZafPopUpMenu::ZafPopUpMenu(const ZafPopUpMenu &copy) :
	ZafWindow(copy)
{
}

ZafPopUpMenu::~ZafPopUpMenu(void)
{
}

ZafWindowObject *ZafPopUpMenu::Duplicate(void)
{
	return(new ZafPopUpMenu(*this));
}

bool ZafPopUpMenu::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafPopUpMenu::SetBordered(bool )
{
	// bordered is true for this class.
	bordered = true;
	return (bordered);
}

bool ZafPopUpMenu::SetDestroyable(bool )
{
	// destroyable is false for this class.
	destroyable = false;
	return (destroyable);
}

bool ZafPopUpMenu::SetDisabled(bool )
{
	// disabled is false for this class.
	disabled = false;
	return (disabled);
}

bool ZafPopUpMenu::SetLocked(bool )
{
	// locked is false for this class.
	locked = false;
	return (locked);
}

bool ZafPopUpMenu::SetMaximized(bool )
{
	// maximized is false for this class.
	maximized = false;
	return (maximized);
}

bool ZafPopUpMenu::SetMinimized(bool )
{
	// minimized is false for this class.
	minimized = false;
	return (minimized);
}

bool ZafPopUpMenu::SetMoveable(bool )
{
	// moveable is false for this class.
	moveable = false;
	return (moveable);
}

bool ZafPopUpMenu::SetNoncurrent(bool )
{
	// noncurrent is false for this class.
	noncurrent = false;
	return (noncurrent);
}

bool ZafPopUpMenu::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

ZafRegionType ZafPopUpMenu::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_INSIDE_REGION for this class.
	regionType = ZAF_INSIDE_REGION;
	return (regionType);
}

bool ZafPopUpMenu::SetSizeable(bool )
{
	// sizeable is false for this class.
	sizeable = false;
	return (sizeable);
}

bool ZafPopUpMenu::SetTemporary(bool )
{
	// temporary is true for this class.
	temporary = true;
	return (temporary);
}

// ----- Persistent functions -----------------------------------------------

ZafPopUpMenu::ZafPopUpMenu(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafWindow(name, persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY))
{
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafPopUpMenu::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafPopUpMenu(name, persist));
}

void ZafPopUpMenu::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafWindow::Write(persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

