//	Zinc Application Framework - Z_PLLDN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_plldn.hpp>
#define ZAF_PULLDOWN_INFO
#include "gbl_def.cpp"

ZafPullDownMenu *ZafWindow::PullDownMenu(void) const
{
	for (ZafWindowObject *object = SupportFirst(); object; object = object->Next())
		if (object->NumberID() == ZAF_NUMID_PULL_DOWN_MENU)
			return (DynamicPtrCast(object, ZafPullDownMenu));
	return (ZAF_NULLP(ZafPullDownMenu));
}

// ----- ZafPullDownMenu ----------------------------------------------------

static ZafStringID _stringID = ZAF_ITEXT("ZAF_NUMID_PULL_DOWN_MENU");

ZafPullDownMenu::ZafPullDownMenu(void) :
	ZafWindow(0, 0, 0, 0)
{
	// Initialize the pull-down menu information.
	SetBordered(true);
	SetSupportObject(true);
	SetRegionType(ZAF_AVAILABLE_REGION);
	SetNumberID(ZAF_NUMID_PULL_DOWN_MENU);
	SetStringID(_stringID);
}

ZafPullDownMenu::ZafPullDownMenu(const ZafPullDownMenu &copy) :
	ZafWindow(copy)
{
}

ZafPullDownMenu::~ZafPullDownMenu(void)
{
	// No menu information needs to be destroyed.
}

ZafWindowObject *ZafPullDownMenu::Duplicate(void)
{
	return (new ZafPullDownMenu(*this));
}

bool ZafPullDownMenu::SetAcceptDrop(bool )
{
	// acceptDrop is false for this class.
	acceptDrop = false;
	return (acceptDrop);
}

bool ZafPullDownMenu::SetBordered(bool )
{
	// bordered is true for this class.
	bordered = true;
	return (bordered);
}

bool ZafPullDownMenu::SetDestroyable(bool )
{
	// destroyable is false for this class.
	destroyable = false;
	return (destroyable);
}

bool ZafPullDownMenu::SetDisabled(bool )
{
	// disabled is false for this class.
	disabled = false;
	return (disabled);
}

bool ZafPullDownMenu::SetLocked(bool )
{
	// locked is false for this class.
	locked = false;
	return (locked);
}

bool ZafPullDownMenu::SetMaximized(bool )
{
	// maximized is false for this class.
	maximized = false;
	return (maximized);
}

bool ZafPullDownMenu::SetMinimized(bool )
{
	// minimized is false for this class.
	minimized = false;
	return (minimized);
}

bool ZafPullDownMenu::SetMoveable(bool )
{
	// moveable is false for this class.
	moveable = false;
	return (moveable);
}

bool ZafPullDownMenu::SetNoncurrent(bool )
{
	// noncurrent is false for this class.
	noncurrent = false;
	return (noncurrent);
}

bool ZafPullDownMenu::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

ZafRegionType ZafPullDownMenu::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_AVAILABLE_REGION for this class.
	regionType = ZAF_AVAILABLE_REGION;
	return (regionType);
}

ZafSelectionType ZafPullDownMenu::SetSelectionType(ZafSelectionType )
{
	// selectionType is ZAF_SINGLE_SELECTION for this class.
	selectionType = ZAF_SINGLE_SELECTION;
	return (selectionType);
}

bool ZafPullDownMenu::SetSizeable(bool )
{
	// sizeable is false for this class.
	sizeable = false;
	return (sizeable);
}

bool ZafPullDownMenu::SetSupportObject(bool )
{
	// supportObject is true for this class.
	supportObject = true;
	return (supportObject);
}

bool ZafPullDownMenu::SetTemporary(bool )
{
	// temporary is false for this class.
	temporary = false;
	return (temporary);
}

// ----- Persistent functions -----------------------------------------------

ZafPullDownMenu::ZafPullDownMenu(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafWindow(name, persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY))
{
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafPullDownMenu::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafPullDownMenu(name, persist));
}

void ZafPullDownMenu::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafWindow::Write(persist.PushLevel(className, classID, ZAF_PERSIST_DIRECTORY));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

