//	Zinc Application Framework - Z_MDIWIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_mdiwin.hpp>
#define ZAF_MDI_WINDOW_INFO
#include "gbl_def.cpp"

// ----- ZafMDIWindow -------------------------------------------------------

ZafMDIWindow::ZafMDIWindow(int left, int top, int width, int height, ZafMDIType type) :
	ZafWindow(left, top, width, height), mdiType(type)
{
}

ZafMDIWindow::ZafMDIWindow(const ZafMDIWindow &copy) :
	ZafWindow(copy), mdiType(copy.mdiType)
{
}

ZafMDIWindow::~ZafMDIWindow(void)
{
}

ZafLogicalEvent ZafMDIWindow::LogicalEvent(const ZafEventStruct &event)
{
	ZafLogicalEvent ccode = MapEvent(defaultEventMap, event);
	return ((ccode == L_NONE) ? ZafWindow::LogicalEvent(event) : ccode);
}

const ZafPaletteStruct *ZafMDIWindow::MapClassPalette(ZafPaletteType type, ZafPaletteState state)
{
	const ZafPaletteStruct *palette = MapPalette(defaultPaletteMap, type, state);
	return (palette ? palette : ZafWindow::MapClassPalette(type, state));
}

ZafWindowObject *ZafMDIWindow::RootObject(void) const
{
	// Since we can't have nested MDI windows, we know this is a child 
	// window when called from a child object in the MDI child. If called 
	// from a support object on the MDI parent, such as the toolbar, the 
	// MDI parent is returned. If called from the MDI parent, it also 
	// correctly returns the parent.
	return ((ZafWindowObject *)this);
}

bool ZafMDIWindow::SetAcceptDrop(bool setAcceptDrop)
{
	// acceptDrop is false for a parent MDI window.
	if (mdiType == ZAF_MDI_PARENT)
		acceptDrop = false;
	else
		ZafWindow::SetAcceptDrop(setAcceptDrop);
	return (acceptDrop);
}

bool ZafMDIWindow::SetBordered(bool )
{
	// bordered is false for this class.
	bordered = false;
	return (bordered);
}

bool ZafMDIWindow::SetDisabled(bool )
{
	// disabled is false for this class.
	disabled = false;
	return (disabled);
}

bool ZafMDIWindow::SetNoncurrent(bool )
{
	// noncurrent is false for this class.
	noncurrent = false;
	return (noncurrent);
}

bool ZafMDIWindow::SetParentPalette(bool )
{
	// parentPalette is false for this class.
	parentPalette = false;
	return (parentPalette);
}

ZafRegionType ZafMDIWindow::SetRegionType(ZafRegionType )
{
	// regionType is ZAF_INSIDE_REGION for this class.
	regionType = ZAF_INSIDE_REGION;
	return (regionType);
}

ZafSelectionType ZafMDIWindow::SetSelectionType(ZafSelectionType setSelectionType)
{
	// selectionType is ZAF_SINGLE_SELECTION for a parent MDI window.
	if (mdiType == ZAF_MDI_PARENT)
		selectionType = ZAF_SINGLE_SELECTION;
	else
		ZafWindow::SetSelectionType(setSelectionType);
	return (selectionType);
}

bool ZafMDIWindow::SetTemporary(bool )
{
	// temporary is false for this class.
	temporary = false;
	return (temporary);
}

// ----- Persistent functions -----------------------------------------------

ZafMDIWindow::ZafMDIWindow(const ZafIChar *name, ZafObjectPersistence &persist) :
	ZafWindow(name, persist.PushLevel(className, classID, ZAF_PERSIST_ROOT_DIRECTORY))
{
	// Read the data.
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafMDIWindow::ReadData(persist);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafMDIWindow::Read(const ZafIChar *name, ZafObjectPersistence &persist)
{
	return (new ZafMDIWindow(name, persist));
}

void ZafMDIWindow::ReadData(ZafObjectPersistence &persist)
{
	// Read the data.
	ZafUInt16 flag1;
	ZafFile *file = persist.CurrentFile();
	*file >> flag1;
	// flag2
	mdiType = (ZafMDIType)((int)flag1 & 0x000F);
}

void ZafMDIWindow::Write(ZafObjectPersistence &persist)
{
	// Write the object.
	ZafWindow::Write(persist.PushLevel(className, classID, ZAF_PERSIST_ROOT_DIRECTORY));
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafMDIWindow::WriteData(persist);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

void ZafMDIWindow::WriteData(ZafObjectPersistence &persist)
{
	// Write the general button data.
	ZafUInt16 flag1 = 0;
	// flag1
	flag1 |= (ZafUInt16)(mdiType & 0x000F);
	ZafFile *file = persist.CurrentFile();
	*file << flag1;
}

