//	Zinc Application Framework - Z_LIST1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_list.hpp>

// ----- ZafListBlock -------------------------------------------------------

ZafListBlock::ZafListBlock(int _noOfElements,
	int (*_compareFunction)(void *element1, void *element2)) :
	ZafList(_compareFunction), noOfElements(_noOfElements),
	elementArray(ZAF_NULLP(void)), freeList()
{
	// No other list block information is initialized.
}

ZafListBlock::~ZafListBlock(void)
{
	// Establish null lists so it doesn't free up an unknown block.
	first = last = ZAF_NULLP(ZafElement);
	freeList.first = freeList.last = ZAF_NULLP(ZafElement);
}

ZafElement *ZafListBlock::Add(ZafElement *position)
{
	ZafElement *newElement = freeList.first;

	// Add a new list element to the use list at specified location.
	if (newElement)
	{
		freeList.Subtract(newElement);
		ZafList::Add(newElement, position);
	}

	// Return a pointer to the new element.
	return (newElement);
}

ZafElement *ZafListBlock::Add(void)
{
	ZafElement *newElement = freeList.first;

	// Add a new list element to the use list according to compareFunction.
	if (newElement)
	{
		freeList.Subtract(newElement);
		ZafList::Add(newElement);
	}

	// Return a pointer to the new element.
	return (newElement);
}

ZafElement *ZafListBlock::Subtract(ZafElement *element)
{
	ZafElement *nextElement = element->Next();

	// Delete the element from the use list.
	ZafList::Subtract(element);
	freeList.Add(element, ZAF_NULLP(ZafElement));

	// Return the next element.
	return (nextElement);
}
