//	Zinc Application Framework - Z_ICON.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_icon.hpp>
#include <z_lang.hpp>
#define ZAF_ICON_DATA_INFO
#include "gbl_def.cpp"

// ----- ZafIconStruct ------------------------------------------------------

ZafIconStruct::ZafIconStruct(void)
{
	width = height = 0, array = ZAF_NULLP(ZafLogicalColor), staticArray = staticHandle = false;
#	if defined(ZAF_MSWINDOWS)
	handle = 0;
#	elif defined(ZAF_MOTIF)
	handle = mask = 0;
#	elif defined(ZAF_MACINTOSH)
	colorBitmap = ZAF_NULLH(PixMapHandle);
	monoBitmap = mask = ZAF_NULLH(BitMapHandle);
	iconHandle = ZAF_NULLH(Handle);
#	elif defined(ZAF_MSDOS)
	handle = mask = 0;
#	endif
}

ZafIconStruct::ZafIconStruct(const ZafImageStruct &data)
{
	width = data.width, height = data.height, array = data.array, staticHandle = false, staticArray = data.staticArray;
#	if defined(ZAF_MSWINDOWS)
	handle = 0;
#	elif defined(ZAF_MOTIF)
	handle = mask = 0;
#	elif defined(ZAF_MACINTOSH)
	colorBitmap = ZAF_NULLH(PixMapHandle);
	monoBitmap = mask = ZAF_NULLH(BitMapHandle);
	iconHandle = ZAF_NULLH(Handle);
#	elif defined(ZAF_MSDOS)
	handle = mask = 0;
#	endif
}

ZafIconStruct::ZafIconStruct(int tWidth, int tHeight, ZafLogicalColor *tArray, bool tStaticArray)
{
	width = tWidth, height = tHeight, array = tArray, staticHandle = false, staticArray = tStaticArray;
#	if defined(ZAF_MSWINDOWS)
	handle = 0;
#	elif defined(ZAF_MOTIF)
	handle = mask = 0;
#	elif defined(ZAF_MACINTOSH)
	colorBitmap = ZAF_NULLH(PixMapHandle);
	monoBitmap = mask = ZAF_NULLH(BitMapHandle);
	iconHandle = ZAF_NULLH(Handle);
#	elif defined(ZAF_MSDOS)
	handle = mask = 0;
#	endif
}

// ----- ZafIconData --------------------------------------------------------

ZafIconData::ZafIconData(const ZafImageStruct &data) :
	ZafImageData()
{
	// Initialize the image information.
	array = ZAF_NULLP(ZafLogicalColor);
	SetImage(*this, data);
	ZafDisplay::InitializeOSIcon(*this);
}

ZafIconData::ZafIconData(const ZafIconStruct &copy) :
	ZafImageData()
{
	// Initialize the information.
	array = ZAF_NULLP(ZafLogicalColor);
	SetImage(*this, copy);
	ZafDisplay::InitializeOSIcon(*this);
}

ZafIconData::ZafIconData(const ZafIconData &copy) :
	ZafImageData(copy)
{
	// Initialize the image information.
	array = ZAF_NULLP(ZafLogicalColor);
	SetIcon(copy);
}

ZafIconData::~ZafIconData(void)
{
	// Destroy the color handle and mask.
	if (zafDisplay)
	{
		if (!StaticHandle())
			zafDisplay->DestroyOSIcon(*this);
		if (!StaticArray())
			zafDisplay->DestroyZafIcon(*this);
	}
	else if (array && !StaticArray())
		delete []array;
}

void ZafIconData::Clear(void)
{
	// Destroy the color handle and mask.
	PushLevel();
	if (zafDisplay)
	{
		zafDisplay->DestroyOSIcon(*this);
		zafDisplay->DestroyZafIcon(*this);
	}
	PopLevel();
}

ZafData *ZafIconData::Duplicate(void)
{
	return (new ZafIconData(*this));
}

ZafError ZafIconData::SetIcon(int tWidth, int tHeight,
	ZafLogicalColor *tArray)
{
	// Clear the current os handles.
	if (zafDisplay)
		zafDisplay->DestroyOSIcon(*this);

	// Reset the icon information.
	PushLevel();
	SetImage(*this, tWidth, tHeight, tArray);
	PopLevel();

	// Return success.
	return (ZAF_ERROR_NONE);
}

ZafError ZafIconData::SetIcon(const ZafIconStruct &copy)
{
	// Clear the current os handles.
	if (zafDisplay)
		zafDisplay->DestroyOSIcon(*this);

	// Reset the icon information.
	PushLevel();
	SetImage(*this, copy);

	// Update the os handles.
	staticHandle = copy.staticHandle;
	if (staticHandle)
		ZafDisplay::ResetOSIcon(*this, copy);
	PopLevel();

	// Return success.
	return (ZAF_ERROR_NONE);
}

// ----- Persistent functions -----------------------------------------------

ZafIconData::ZafIconData(const ZafIChar *name, ZafDataPersistence &persist) :
	ZafImageData(name, persist.PushLevel(className, classID, ZAF_PERSIST_ROOT_DIRECTORY))
{
	// Set the default icon information.
	InitializeImage(*this);

	staticHandle = false;
	ZafDisplay::InitializeOSIcon(*this);

	// Read the data.
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafIconData::ReadData(persist);

	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafIconData::Read(const ZafIChar *name, ZafDataPersistence &persist)
{
	return (new ZafIconData(name, persist));
}

void ZafIconData::ReadData(ZafDataPersistence &persist)
{
	// Read the data.
	ZafFile *file = persist.CurrentFile();
	*file >> width >> height;
	array = new ZafLogicalColor[width * height];
	file->Read(array, sizeof(ZafLogicalColor), width * height);
}

void ZafIconData::Write(ZafDataPersistence &persist)
{
	// Read the image information.
	ZafImageData::Write(persist.PushLevel(className, classID, ZAF_PERSIST_ROOT_DIRECTORY));
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafIconData::WriteData(persist);
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

void ZafIconData::WriteData(ZafDataPersistence &persist)
{
	// Write the image information.
	ZafFile *file = persist.CurrentFile();
	*file << width << height;
	if (array)
		file->Write(array, sizeof(ZafLogicalColor), width * height);
}

