//	Zinc Application Framework - Z_HTIPS.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_htips.hpp>
#include <z_utils.hpp>
#define ZAF_HELP_TIPS_INFO
#include "gbl_def.cpp"

// ----- ZafHelpTips --------------------------------------------------------

ZafHelpTips::ZafHelpTips(ZafDeviceState state, ZafHelpTipsType tHelpTipsType) :
	ZafDevice(E_HELPTIPS, state),
	quickTipVisible(false), allowQuickSiblingDisplay(false), 
	helpTipsType(tHelpTipsType), replaceText(ZAF_NULLP(ZafIChar)),
	userPalette(ZAF_NULLP(ZafPaletteStruct))
{
	// Initialize the tool tips information.
	lastMousePosition.column = lastMousePosition.line = 0;
	quickTipRegion.left = quickTipRegion.top =
		quickTipRegion.right = quickTipRegion.bottom = 0;
#if defined(ZAF_MSWINDOWS)
	displayTimerHandle = 0;
	screenBuffer = ZAF_NULLH(HBITMAP);
	lastTime = clock();
#elif defined(ZAF_MOTIF)
	quickTipWindow = 0;
	displayTimerHandle = 0;
	lastTime = 0;
#elif defined(ZAF_MSDOS)
	displayTimerHandle = 0;
	lastTime = 0;
#elif defined(ZAF_MACINTOSH)
	displayTimerHandle.tmAddr = ZAF_NULLH(TimerUPP);
	displayTimerHandle.tmWakeUp = displayTimerHandle.tmReserved = 0L;
#endif
}

ZafHelpTips::~ZafHelpTips(void)
{
	// Clean up the help tip members.
	if (replaceText)
		delete []replaceText;

#if defined(ZAF_MOTIF)
	if (quickTipWindow)
		XDestroyWindow(display->xDisplay, quickTipWindow);
#endif
}

void ZafHelpTips::SetHelpObject(ZafWindowObject *newHelpObject)
{
	// Check for a new help object.
	// Check the window manager for updated help objects.
	if (zafWindowManager && newHelpObject != zafWindowManager->helpObject)
	{
		zafWindowManager->helpObject = newHelpObject;

		// Update the help object information.
		if (newHelpObject)
		{
			if (replaceText)
				delete []replaceText;
			const ZafIChar *text = newHelpObject->Text();
			replaceText = text ? strdup(text) : ZAF_NULLP(ZafIChar);
		}
	}
}

ZafHelpTipsType ZafHelpTips::SetHelpTipsType(ZafHelpTipsType tHelpTipsType)
{
	helpTipsType = tHelpTipsType;
	return (helpTipsType);
}

int ZafHelpTips::SetInitialDelay(int newInitialDelay)
{
	// Make sure the attribute has changed.
	if (initialDelay != newInitialDelay)
		initialDelay = newInitialDelay;

	// Return the current attribute.
	return (initialDelay);
}

int ZafHelpTips::SetNewHelpTipDelay(int newNewHelpTipDelay)
{
	// Make sure the attribute has changed.
	if (newHelpTipDelay != newNewHelpTipDelay)
		newHelpTipDelay = newNewHelpTipDelay;

	// Return the current attribute.
	return (newHelpTipDelay);
}

void ZafHelpTips::SetUserPalette(ZafPaletteStruct *newUserPalette)
{
	userPalette = newUserPalette;
}
