//	Zinc Application Framework - Z_GMGR1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_gmgr.hpp>
#include <z_utils.hpp>

// ----- ZafConstraint ------------------------------------------------------

ZafConstraint::ZafConstraint(ZafWindowObject *zObject) :
	object(zObject), objNumberID(-1), parent(ZAF_NULLP(ZafGeometryManager))
{
}

ZafConstraint::ZafConstraint(const ZafConstraint &copy) :
	object(ZAF_NULLP(ZafWindowObject)), objNumberID(copy.objNumberID),
	parent(ZAF_NULLP(ZafGeometryManager))
{
}

ZafConstraint::~ZafConstraint(void)
{
}

ZafConstraint *ZafConstraint::Duplicate(void)
{
	// Initialize objNumberID, since object may not have had its numberID 
	// assigned before.
	objNumberID = object ? object->NumberID() : (ZafNumberID)-1;

	// ZafConstraint is abstract -- can't duplicate.
	return (ZAF_NULLP(ZafConstraint));
}

ZafEventType ZafConstraint::Event(const ZafEventStruct &event)
{
	// Check for zinc events.
	ZafEventType ccode = event.type;
	if (ccode == S_INITIALIZE)
	{
		// Initialize numberID and stringID.
		if (!numberID && parent)
		{
			ZafWindowObject *root = DynamicPtrCast(parent->parent, ZafWindowObject)->RootObject();

			// Set the numberID.
			numberID = root->NumberID();
			root->SetNumberID((ZafNumberID)(numberID + 1));

			// Set the stringID.
			if (!stringID)
			{
				ZafIChar newStringID[ZAF_MAXNAMELEN];
				strcpy(newStringID, genericConstraintID);
				itoa(numberID, &newStringID[strlen(newStringID)], 10, 0);
				SetStringID(newStringID);
			}
		}

		// Get a pointer to the constrained object.
		if (!object && objNumberID >= 0)
			object = DynamicPtrCast(parent->parent, ZafWindow)->GetObject(objNumberID);
		return (ccode);
	}

	return (S_ERROR);
}

// ----- Persistent functions -----------------------------------------------

ZafConstraint::ZafConstraint(const ZafIChar *name, ZafObjectPersistence &persist) :
	object(ZAF_NULLP(ZafWindowObject)), objNumberID(-1),
	parent(ZAF_NULLP(ZafGeometryManager))
{
	// Set the string identification.
	if (name)
		SetStringID(name);

	// Prepare the file.
	persist.AllocateFile(stringID, ZAF_FILE_READ);

	// Read the data.
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafConstraint::ReadData(persist);
}

void ZafConstraint::ReadData(ZafObjectPersistence &persist)
{
	// Read the data.
	ZafFile *file = persist.CurrentFile();
	*file >> objNumberID;
}

void ZafConstraint::Write(ZafObjectPersistence &persist)
{
	// Prepare the file.
	persist.AllocateFile(stringID, ZAF_FILE_CREATE | ZAF_FILE_READWRITE);

	// Write the data.
	if (persist.Error() == ZAF_ERROR_NONE)
		ZafConstraint::WriteData(persist);

	// Register the read procedure.
	persist.AddObjectConstructor(ClassName(), ClassID(), ReadFunction());
}

void ZafConstraint::WriteData(ZafObjectPersistence &persist)
{
	// Write the data.
	ZafFile *file = persist.CurrentFile();

	// Initialize objNumberID, since object may not have had its numberID 
	// assigned before.
	objNumberID = object ? object->NumberID() : (ZafNumberID)-1;
	*file << objNumberID;
}

