//	Zinc Application Framework - Z_EVENT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_device.hpp>

// ----- ZafEventStruct -----------------------------------------------------

ZafEventStruct::ZafEventStruct(void) :
	type(0), rawCode(0), modifiers(0),
	route(ZAF_NULLP(ZafWindowObject)), converted(ZAF_NULLP(ZafWindowObject))
{
	data = ZAF_NULLP(void);
}

ZafEventStruct::ZafEventStruct(ZafEventType _type, ZafRawCode _rawCode) :
	type(_type), rawCode(_rawCode), modifiers(0),
	route(ZAF_NULLP(ZafWindowObject)), converted(ZAF_NULLP(ZafWindowObject))
{
	data = ZAF_NULLP(void);
#	if defined(ZAF_MOTIF)
	osEvent.type = 0;
#	endif
}

ZafEventStruct::ZafEventStruct(ZafEventType _type, OSEventStruct *_osEvent) :
	type(_type), rawCode(0), modifiers(0),
	route(ZAF_NULLP(ZafWindowObject)), converted(ZAF_NULLP(ZafWindowObject))
{
	// Handle null _osEvent cases.
#	if defined(ZAF_MOTIF)
	osEvent.type = 0;
#	endif

	// Set the members.
	if (_osEvent)
		osEvent = *_osEvent;
	data = ZAF_NULLP(void);
}

ZafEventStruct::ZafEventStruct(ZafEventType _type, ZafRawCode _rawCode, ZafKeyStruct _key) :
	type(_type), rawCode(_rawCode), modifiers(0),
	route(ZAF_NULLP(ZafWindowObject)), converted(ZAF_NULLP(ZafWindowObject))
{
	key = _key;
#	if defined(ZAF_MOTIF)
	osEvent.type = 0;
#	endif
}

ZafEventStruct::ZafEventStruct(ZafEventType _type, ZafRawCode _rawCode, ZafRegionStruct _region) :
	type(_type), rawCode(_rawCode), modifiers(0),
	route(ZAF_NULLP(ZafWindowObject)), converted(ZAF_NULLP(ZafWindowObject))
{
	region = _region;
#	if defined(ZAF_MOTIF)
	osEvent.type = 0;
#	endif
}

ZafEventStruct::ZafEventStruct(ZafEventType _type, ZafRawCode _rawCode, ZafPositionStruct _position) :
	type(_type), rawCode(_rawCode), modifiers(0),
	route(ZAF_NULLP(ZafWindowObject)), converted(ZAF_NULLP(ZafWindowObject))
{
	position = _position;
#	if defined(ZAF_MOTIF)
	osEvent.type = 0;
#	endif
}

ZafEventStruct::ZafEventStruct(ZafEventType _type, ZafRawCode _rawCode, ZafScrollStruct _scroll) :
	type(_type), rawCode(_rawCode), modifiers(0),
	route(ZAF_NULLP(ZafWindowObject)), converted(ZAF_NULLP(ZafWindowObject))
{
	scroll = _scroll;
#	if defined(ZAF_MOTIF)
	osEvent.type = 0;
#	endif
}

ZafEventType ZafEventStruct::InputType(ZafEventType ccode) const
{
	if (type == E_OSEVENT)
	{
#	if defined(ZAF_MSWINDOWS)
		if (osEvent.message == WM_KEYDOWN || osEvent.message == WM_KEYUP ||
			osEvent.message == WM_SYSKEYDOWN || osEvent.message == WM_SYSKEYUP)
			return (E_KEY);
		else if ((osEvent.message >= WM_MOUSEFIRST && osEvent.message <= WM_MOUSELAST) ||
			(osEvent.message >= WM_NCMOUSEMOVE && osEvent.message <= WM_NCMBUTTONDBLCLK))
			return (E_MOUSE);
#	elif defined(ZAF_MOTIF)
		if (osEvent.type == KeyPress || osEvent.type == KeyRelease)
			return (E_KEY);
		else if (osEvent.type == ButtonPress || osEvent.type == ButtonRelease)
			return (E_MOUSE);
		else if (osEvent.type == MotionNotify)
			return (E_MOUSE);
#	elif defined(ZAF_MACINTOSH)
		if (osEvent.what == keyDown || osEvent.what == keyUp || osEvent.what == autoKey)
			return (E_KEY);
		else if (osEvent.what == mouseDown || osEvent.what == mouseUp ||
			(osEvent.what == osEvt && ((osEvent.message >> 24) & 0x000000ffL) == mouseMovedMessage))
			return (E_MOUSE);
#	endif
	}
	else if (type == E_KEY)
		return (E_KEY);
	else if (type == E_MOUSE)
		return (E_MOUSE);

	if (type >= S_SYSTEM_FIRST && type <= S_SYSTEM_LAST ||
		ccode >= S_SYSTEM_FIRST && ccode <= S_SYSTEM_LAST)
		ccode = S_SYSTEM_EVENT;
	else if (type >= L_LOGICAL_FIRST && type <= L_LOGICAL_LAST ||
		ccode >= L_LOGICAL_FIRST && ccode <= L_LOGICAL_LAST)
		ccode = L_LOGICAL_EVENT;
	else
		ccode = E_DEVICE_EVENT;
	return (ccode);
}

