//	Zinc Application Framework - Z_ERROR.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_error.hpp>
#include <z_stdarg.hpp>
#define ZAF_ERROR_STUB_INFO
#include "gbl_def.cpp"

// ----- ZafErrorStub -------------------------------------------------------

ZafErrorStub::ZafErrorStub(void)
{
}

ZafErrorStub::~ZafErrorStub(void)
{
}

ZafDialogEvent ZafErrorStub::ReportError(ZafWindowObject *object,
	ZafIChar *title, ZafDialogFlags dlgFlags, ZafIChar *format, ...)
{
	// Format the error message then report the error.
	ZafIChar *message = new ZafIChar[1024];

	va_list args;
 	va_start(args, format);
	ZafStandardArg::vsprintf(message, format, &args);
	va_end(args);

	ZafDialogEvent ccode = ErrorMessage(object, title, dlgFlags, message);
	delete []message;
	return (ccode);
}

