//	Zinc Application Framework - Z_DATE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_date.hpp>
#define ZAF_DATE_DATA_INFO
#include "gbl_def.cpp"

// ----- ZafDateData --------------------------------------------------------

ZafDateData::ZafDateData(void) :
	ZafUTimeData()
{
	// No additional information needs to be initialized.
}

ZafDateData::ZafDateData(int year, int month, int day) :
	ZafUTimeData(year, month, day, 0, 0, 0, 0)
{
	// No additional information needs to be initialized.
}

ZafDateData::ZafDateData(const ZafIChar *string, const ZafIChar *format) :
	ZafUTimeData()
{
	// Set the date from the string argument.
	SetDate(string, format);
}

ZafDateData::ZafDateData(const ZafDateData &copy) :
	ZafUTimeData(copy)
{
	// No additional information needs to be initialized.
}

ZafDateData::ZafDateData(const ZafUTimeData &copy) :
	ZafUTimeData(copy)
{
	// No additional information needs to be initialized.
}

ZafDateData::~ZafDateData(void)
{
	// No information needs to be deleted.
}

void ZafDateData::Clear(void)
{
	// Defer to the base class.
	ZafUTimeData::Clear();
}

ZafData *ZafDateData::Duplicate(void)
{
	return (new ZafDateData(*this));
}

int ZafDateData::FormattedText(ZafIChar *buffer, int maxLength, const ZafIChar *format) const
{
	// Format the text.
	return (Sprintf(buffer, maxLength, format ? format : zafLocale->dateStringOutputFormat));
}

ZafError ZafDateData::SetDate(int year, int month, int day)
{
	// Defer to the base class.
	return SetUTime(year, month, day, 0, 0, 0, 0);
}

ZafError ZafDateData::SetDate(const ZafDateData &number)
{
	// Defer to the base class.
	return SetUTime(number);
}

ZafError ZafDateData::SetDate(const ZafIChar *buffer, const ZafIChar *format)
{
	// Reset the value.
	PushLevel();
	Sscanf(buffer, format ? format : zafLocale->dateStringInputFormat);
	PopLevel();

	// Return success.
	return (ZAF_ERROR_NONE);
}

// ----- Persistent functions -----------------------------------------------

ZafDateData::ZafDateData(const ZafIChar *name, ZafDataPersistence &persist) :
	ZafUTimeData(name, persist.PushLevel(className, classID, ZAF_PERSIST_FILE))
{
	Bind();
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

ZafElement *ZafDateData::Read(const ZafIChar *name, ZafDataPersistence &persist)
{
	return (new ZafDateData(name, persist));
}

void ZafDateData::Write(ZafDataPersistence &persist)
{
	// Write the object.
	ZafUTimeData::Write(persist.PushLevel(className, classID, ZAF_PERSIST_FILE));
	persist.PopLevel();
	if (persist.Error() != ZAF_ERROR_NONE)
		SetError(persist.Error());
}

