//	Zinc Application Framework - U_UNISTD.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

int chdir(const ZafIChar *path)
{
	char mappedPath[ZAF_MAXPATHLEN];
	zafCodeSet->ConvertToOSString(path, mappedPath, false);
	return chdir(mappedPath);
}

ZafIChar *getcwd(ZafIChar *path, unsigned int length)
{
	static char mappedPath[ZAF_MAXPATHLEN];
	if (getcwd(mappedPath, ZAF_MAXPATHLEN))
	{
		zafCodeSet->ConvertToZafString(mappedPath, path, false);
		return path;
	}
	return ZAF_NULLP(ZafIChar);
}

int rename(const ZafIChar *oldPath, const ZafIChar *newPath)
{
	char mappedOldPath[ZAF_MAXPATHLEN], mappedNewPath[ZAF_MAXPATHLEN];
	zafCodeSet->ConvertToOSString(oldPath, mappedOldPath, false);
	zafCodeSet->ConvertToOSString(newPath, mappedNewPath, false);

	return rename(mappedOldPath, mappedNewPath);
}

int unlink(const ZafIChar *path)
{
	char mappedPath[ZAF_MAXPATHLEN];
	zafCodeSet->ConvertToOSString(path, mappedPath, false);
	return unlink(mappedPath);
}

int remove(const ZafIChar *path) { return unlink(path); }
