//	Zinc Application Framework - U_STDIO.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

FILE *fopen(const ZafIChar *path, const ZafIChar *mode)
{
	// Convert the name to an OS string.
	char mappedPath[ZAF_MAXPATHLEN], mappedMode[ZAF_MAXPATHLEN];
	zafCodeSet->ConvertToOSString(path, mappedPath, false);
	zafCodeSet->ConvertToOSString(mode, mappedMode, false);

	// Open the file.
	return (fopen(mappedPath, mappedMode));
}

ZafIChar *tmpnam(ZafIChar *string)
{
	// Create the temporary name.
	static char mappedString[L_tmpnam];
	static ZafIChar newString[L_tmpnam];
	if (!string)
		string = newString;
	tmpnam(mappedString);
	zafCodeSet->ConvertToZafString(mappedString, string, false);
	return string;
}

