//	Zinc Application Framework - TABLE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

// ----- SampleTable --------------------------------------------------------

const int MAX_RECORDS = 3000;

ZafStringData *nameData, *departmentData, *deleteData;

class SampleTable : public ZafTable
{
public:
	SampleTable(void);
	virtual ZafError ReadRecord(ZafTableRecord &record, ZafWindowObject *row);
	virtual ZafError WriteRecord(ZafTableRecord &record, ZafWindowObject *row);

	struct SampleTableRecord
	{
		bool deleteData;
		ZafIChar department[32];
		ZafIChar name[32];
	};

private:
	static SampleTableRecord *data[MAX_RECORDS];
};

SampleTable::SampleTableRecord *SampleTable::data[MAX_RECORDS];

SampleTable::SampleTable(void) :
	ZafTable(2, 1, 55, 8, 5, 1, 1)
{
	// Set some table attributes.
//	SetGrid(false);
	SetRegionType(ZAF_AVAILABLE_REGION);

	// Create the field definitions.
	ZafButton *field1 = new ZafButton(0, 0, 4, 1, ZAF_NULLP(ZafIChar), ZAF_NULLP(ZafBitmapData), ZAF_CHECK_BOX);
	field1->SetOSDraw(false);
	field1->SetAllowToggling(true);
	Add(field1, ZAF_ITEXT("del"));
	ZafString *string = DynamicPtrCast(ColumnTableHeader()->First(), ZafString);
	string->SetHzJustify(ZAF_HZ_CENTER);
	Add(new ZafString(4, 0, 15, ZAF_NULLP(ZafIChar), -1), ZAF_ITEXT("Department"));
	Add(new ZafString(19, 0, 20, ZAF_NULLP(ZafIChar), -1), ZAF_ITEXT("Name"));

	// Add the scroll-bar.
	Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_VERTICAL_SCROLL));

	// Count the records.
	maxOffset = MAX_RECORDS - 1;
	for (int i = 0; i < MAX_RECORDS; i++)
	{
		data[i] = new SampleTableRecord;
		data[i]->deleteData = false;
		sprintf(data[i]->department, ZAF_ITEXT("Department %c"), 'A' + (i % 26));
		sprintf(data[i]->name, ZAF_ITEXT("Employee %d"), i);
	}
}

ZafError SampleTable::ReadRecord(ZafTableRecord &record, ZafWindowObject *rowField)
{
	// Read the record.
	record(0)->SetSelected(data[currentOffset]->deleteData);
	record(1)->SetText(data[currentOffset]->department);
	record(2)->SetText(data[currentOffset]->name);

	// Set the row field.
	ZafIChar text[32];
	sprintf(text, ZAF_ITEXT("%d"), currentOffset);
	rowField->SetText(text);
	return (ZAF_ERROR_NONE);
}

ZafError SampleTable::WriteRecord(ZafTableRecord &record, ZafWindowObject *)
{
	// Write the changed fields of the record.
	if (record(0)->Changed())
		data[currentOffset]->deleteData = record(0)->Selected();
	if (record(1)->Changed())
		strcpy(data[currentOffset]->department, record(1)->Text());
	if (record(2)->Changed())
		strcpy(data[currentOffset]->name, record(2)->Text());
	return (ZAF_ERROR_NONE);
}

// ----- SampleTableWindow --------------------------------------------------

class SampleTableWindow : public ZafWindow
{
public:
	SampleTableWindow(int left, int top);
};

SampleTableWindow::SampleTableWindow(int left, int top) :
	ZafWindow(left, top, 60, 16)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("TableWindow"));

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton(ZAF_NATIVE_SYSTEM_BUTTON));
	Add(new ZafTitle(new ZafStringData(ZAF_ITEXT("Table Window"))));

	// Add the menu bar.
	ZafPullDownMenu *menu = new ZafPullDownMenu();
	ZafPullDownItem *fileItem = new ZafPullDownItem(new ZafStringData(ZAF_ITEXT("File")));
	ZafPopUpItem *quitItem = new ZafPopUpItem(new ZafStringData(ZAF_ITEXT("Quit")));
	quitItem->SetSendMessageWhenSelected(true);
	quitItem->SetValue(L_EXIT);
	fileItem->Add(quitItem);
	menu->Add(fileItem);
	Add(menu);

	// Add the table object.
	Add(new SampleTable);
}

// ----- DataWindow ---------------------------------------------------------

class DataWindow : public ZafWindow
{
public:
	DataWindow(int left, int top);
};

DataWindow::DataWindow(int left, int top) :
	ZafWindow(left, top, 20, 5)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("DataWindow"));

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton(ZAF_NATIVE_SYSTEM_BUTTON));
	Add(new ZafTitle(new ZafStringData(ZAF_ITEXT("Data Window"))));

	// Add 3 strings to the window, tied to the global data objects.
	Add(new ZafString(1, 0, 15, nameData));
	Add(new ZafString(1, 1, 15, departmentData));
	Add(new ZafString(1, 2, 15, deleteData));
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	deleteData = new ZafStringData(ZAF_ITEXT("del"), 32);
	nameData = new ZafStringData(ZAF_ITEXT("Name"), 32);
	departmentData = new ZafStringData(ZAF_ITEXT("Department"), 32);

	// Add the table window to the window manager, which puts it on the screen.
//	zafWindowManager->Add(new DataWindow(1, 1));
//	zafWindowManager->Add(new DataWindow(1, 7));
//	zafWindowManager->Add(new DataWindow(1, 13));
	zafWindowManager->Add(new SampleTableWindow(25, 1));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

