//	Zinc Application Framework - MAP2DAT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// This program must not be compiled for unicode

//#include <string.h>
#include <z_lang.hpp>
#include <z_loc.hpp>
#include <z_store.hpp>
#include <z_utils.hpp>
#include <z_i18n.hpp>
#include <z_cset.hpp>
#include <z_prst.hpp>

class ZafMapChars
{
public:
	ZafIChar *localToIso;
	ZafIChar *isoToLocal;
	char *name;
};

#if !defined(MAP_NAME)

#include <z_stdio.hpp>
#if defined(ZAF_MACINTOSH)
#	include <console.h>
#endif
#define VERSION	"4.00"

typedef ZafMapChars *(*ZafMapFunction)(void);

extern ZafMapChars *_437_Initialize(void);
extern ZafMapChars *_737_Initialize(void);
extern ZafMapChars *_850_Initialize(void);
extern ZafMapChars *_852_Initialize(void);
extern ZafMapChars *_855_Initialize(void);
extern ZafMapChars *_857_Initialize(void);
extern ZafMapChars *_860_Initialize(void);
extern ZafMapChars *_861_Initialize(void);
extern ZafMapChars *_863_Initialize(void);
extern ZafMapChars *_865_Initialize(void);
extern ZafMapChars *_866_Initialize(void);
extern ZafMapChars *_869_Initialize(void);
extern ZafMapChars *_1250_Initialize(void);
extern ZafMapChars *_1251_Initialize(void);
extern ZafMapChars *_1252_Initialize(void);
extern ZafMapChars *_1253_Initialize(void);
extern ZafMapChars *_1254_Initialize(void);
extern ZafMapChars *_1255_Initialize(void);
extern ZafMapChars *_1256_Initialize(void);
extern ZafMapChars *_MAC_Initialize(void);
//extern ZafMapChars *_NeXT_Initialize(void);

ZafMapFunction Initialize[] =
{
	_437_Initialize,
	_737_Initialize,
	_850_Initialize,
	_852_Initialize,
	_855_Initialize,
	_857_Initialize,
	_860_Initialize,
	_861_Initialize,
	_863_Initialize,
	_865_Initialize,
	_866_Initialize,
	_869_Initialize,
	_1250_Initialize,
	_1251_Initialize,
	_1252_Initialize,
	_1253_Initialize,
	_1254_Initialize,
	_1255_Initialize,
	_1256_Initialize,
	_MAC_Initialize,
//	_NeXT_Initialize,
	NULL
};

int main(int argc, char *argv[])
{
#if defined(ZAF_MACINTOSH)
	argc = ccommand(&argv);
#endif

	// allocate the default locale and character mapping.
	ZafI18nData::I18nAllocate();

	// Display version.
	printf("Version %s Copyright (C) 1990-1997 Zinc Software Incorporated.\n\n", VERSION);
	if (argc != 2)
	{
		printf("Usage: map2dat <filename>\n");
		return (1);
	}
	ZafStorage *storage = new ZafStorage(argv[1], ZAF_FILE_OPENCREATE | ZAF_FILE_READWRITE);
	ZafDataPersistence persist(zafDefaultDataConstructor, storage);

	for (int i = 0; Initialize[i]; i++)
	{
		ZafMapChars *tmp = (Initialize[i])();
		ZafCodeSetData charMap(tmp->isoToLocal, tmp->localToIso);
		charMap.SetStringID(tmp->name);
		charMap.Write(persist);
		delete tmp;
	}
	storage->Save();
	delete storage;
	return (0);
}

#else

#define str(s)		#s
#define xstr(s)		str(s)
#define append(a,b,c)	a##b##c
#define FILENAME(x)	append(map, x, .cpp)
#define FUNCTIONNAME(x)	append(_, x, _Initialize)

#undef ZAF_MSDOS
#undef ZAF_MSWINDOWS
#undef ZAF_OS2
#undef ZAF_MACINTOSH
#if defined (ZAF_MOTIF)
#	if (MAP_NAME == MAC)
#		include "mapmac.cpp"
#	elif (MAP_NAME == NeXT)
#		include "mapnext.cpp"
#	else
#		include xstr(FILENAME(MAP_NAME))
#	endif
#else
#	include xstr(FILENAME(MAP_NAME))
#endif


ZafMapChars *FUNCTIONNAME(MAP_NAME)(void)
{
	ZafMapChars *tmp = new ZafMapChars;
	tmp->name = defaultCodeSetName;
	tmp->isoToLocal = i18nToLocal;
	tmp->localToIso = localToI18n;
	return tmp;
}
#endif

