//	Zinc Application Framework - LOC_US.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if defined(ZAF_UNICODE)
#	define locCodeset	CP_UNICODE
#else
#	define locCodeset	CP_ISO8859_1
#endif
#define LENGTHOF(x)	(sizeof(x)/sizeof((x)[0]))

// Locale definitions for the USA (US).
static ZafIChar defaultLocaleName[] = ZAF_ITEXT("US");

static ZafEraStruct ZAF_FARDATA eraTable[] =
{
	{ 1, 1, 1721424L, 0xffffffffL, ZAF_ITEXT("AD"), ZAF_ITEXT("%EC %Ey") },
	{ 0, 4713, 0L, 1721423L, ZAF_ITEXT("BC"), ZAF_ITEXT("%Ey %EC") }
};

static ZafLocaleStruct ZAF_FARDATA defaultLocale =
{
	ZAF_ITEXT("."),	// decimalSeparator
	ZAF_ITEXT("."),	// monDecimalSeparator
	ZAF_ITEXT(","),	// thousandsSeparator
	ZAF_ITEXT(","),	// monthousandsSeparator
	ZAF_ITEXT("$"),	// currencySymbol
	{ 3, 0 },	// grouping
	{ 3, 0 },	// monGrouping
	ZAF_ITEXT("USD "),	// intCurrencySymbol
	1,		// posCurrencyPrecedes
	1,		// negCurrencyPrecedes
	2,		// fractionDigits
	2,		// intFractionDigits
	ZAF_ITEXT(""),	// positiveSign
	1,		// posSignPreceides
	0,		// posSpaceSeparation
	ZAF_ITEXT("-"),	// negativeSign
	1,		// negSignPreceides
	0,		// negSpaceSeparation
	ZAF_ITEXT("("),
	ZAF_ITEXT(")"),
	ZAF_ITEXT("%d"),
	ZAF_ITEXT("%d"),
	ZAF_ITEXT("%g"),
	ZAF_ITEXT("%g"),
	(ZAF_ITEXT("%I:%M:%S%p\n")
				ZAF_ITEXT("%I:%M:%S\n")
				ZAF_ITEXT("%H:%M:%S\n")
				ZAF_ITEXT("%I%M%S%p\n")
				ZAF_ITEXT("%I%M%S\n")
				ZAF_ITEXT("%H%M%S\n")
				ZAF_ITEXT("%I:%M%p\n")
				ZAF_ITEXT("%I:%M\n")
				ZAF_ITEXT("%H:%M\n")
				ZAF_ITEXT("%I%M%p\n")
				ZAF_ITEXT("%I%M\n")
				ZAF_ITEXT("%H%M\n")
				ZAF_ITEXT("%I%p\n")
				ZAF_ITEXT("%I%\n")
				ZAF_ITEXT("%H%")),
	ZAF_ITEXT("%H:%M:%S"),
	ZAF_ITEXT("%I:%M:%S %p"),
	(ZAF_ITEXT("%m/%d/%y\n")
				ZAF_ITEXT("%d/%m/%y\n")
				ZAF_ITEXT("%m-%d-%y\n")
				ZAF_ITEXT("%d-%m-%y\n")
				ZAF_ITEXT("%m.%d.%y\n")
				ZAF_ITEXT("%d.%m.%y\n")
				ZAF_ITEXT("%m%d%y\n")
				ZAF_ITEXT("%d%m%y\n")
				ZAF_ITEXT("%h%d,%y\n")
				ZAF_ITEXT("%h%d%y\n")
				ZAF_ITEXT("%d%h,%y\n")
				ZAF_ITEXT("%d%h%y\n")
				ZAF_ITEXT("%m/%d/%Y\n")
				ZAF_ITEXT("%d/%m/%Y\n")
				ZAF_ITEXT("%m-%d-%Y\n")
				ZAF_ITEXT("%d-%m-%Y\n")
				ZAF_ITEXT("%m.%d.%Y\n")
				ZAF_ITEXT("%d.%m.%Y\n")
				ZAF_ITEXT("%m%d%Y\n")
				ZAF_ITEXT("%d%m%Y\n")
				ZAF_ITEXT("%h%d,%Y\n")
				ZAF_ITEXT("%h%d%Y\n")
				ZAF_ITEXT("%d%h,%Y\n")
				ZAF_ITEXT("%d%h%Y\n")
				ZAF_ITEXT("%m%d\n")
				ZAF_ITEXT("%d%m\n")
				ZAF_ITEXT("%h%d\n")
				ZAF_ITEXT("%d%h\n")
				ZAF_ITEXT("%d")),
	ZAF_ITEXT("%m/%d/%y"),
	ZAF_ITEXT("%D%T"),
	ZAF_ITEXT("%m/%d/%y %I:%M:%S %p"),
	ZAF_ITEXT("0123456789"),
	ZAF_ITEXT("0123456789"),
	ZAF_ITEXT(":"),
	ZAF_ITEXT("-"),
	2299160L,	// Oct 4, 1582
	11,		// to 2299171L	Oct 15, 1582
	LENGTHOF(eraTable),
	eraTable
};
