//	Zinc Application Framework - LOC2DAT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#define CP_ISO8859_1	1
#define CP_UNICODE	2
#define CP_OTHER	2

//#include <string.h>
#include <z_store.hpp>
#include <z_utils.hpp>
#include <z_i18n.hpp>
#include <z_loc.hpp>
#include <z_lang.hpp>
#include <z_cset.hpp>
#include <z_prst.hpp>

#if !defined(LOCALE_NAME)

//#include <stdio.h>
#if defined(ZAF_MACINTOSH)
#	include <console.h>
#endif
#define VERSION	"5.00"

typedef ZafLocaleData *(*ZafLocaleFunction)(void);

#if defined(ZAF_UNICODE)
	extern ZafLocaleData *_cn_Initialize(void);
	extern ZafLocaleData *_gr_Initialize(void);
	extern ZafLocaleData *_jp_Initialize(void);
	extern ZafLocaleData *_kr_Initialize(void);
	extern ZafLocaleData *_tw_Initialize(void);
#else
	extern ZafLocaleData *_at_Initialize(void);
	extern ZafLocaleData *_ca_Initialize(void);
	extern ZafLocaleData *_cafr_Initialize(void);
	extern ZafLocaleData *_de_Initialize(void);
	extern ZafLocaleData *_dk_Initialize(void);
	extern ZafLocaleData *_es_Initialize(void);
	extern ZafLocaleData *_fi_Initialize(void);
	extern ZafLocaleData *_fr_Initialize(void);
	extern ZafLocaleData *_gb_Initialize(void);
	extern ZafLocaleData *_it_Initialize(void);
	extern ZafLocaleData *_mx_Initialize(void);
	extern ZafLocaleData *_nl_Initialize(void);
	extern ZafLocaleData *_no_Initialize(void);
	extern ZafLocaleData *_se_Initialize(void);
	extern ZafLocaleData *_us_Initialize(void);
#endif

ZafLocaleFunction Initialize[] = 
{
#if defined(ZAF_UNICODE)
	_cn_Initialize,	// China
	_gr_Initialize,	// Greece
	_jp_Initialize,	// Japan
	_kr_Initialize,	// Korea, Republic of
	_tw_Initialize,	// Taiwan
#else
	_at_Initialize,	// Austria
	_ca_Initialize,	// Canada
	_cafr_Initialize,	// Canada, French
	_de_Initialize,	// Germany
	_dk_Initialize,	// Denmark
	_es_Initialize,	// Spain
	_fi_Initialize,	// Finland
	_fr_Initialize,	// France
	_gb_Initialize,	// United Kingdom
	_it_Initialize,	// Italy
	_mx_Initialize,	// Mexico
	_nl_Initialize,	// Netherlands
	_no_Initialize,	// Norway
	_se_Initialize,	// Sweden
	_us_Initialize,	// United States
#endif
	ZAF_NULLF(ZafLocaleFunction)
};

int main(int argc, char *argv[])
{
	// allocate the default locale and character mapping.
	ZafI18nData::I18nAllocate();

#if defined(ZAF_MACINTOSH)
	argc = ccommand(&argv);
#endif
//	ZIL_INTERNATIONAL::MachineName();
#if defined(ZAF_UNICODE)
	ZafIChar *pathName = zafCodeSet->ConvertToZafString(argv[0], 0, true);
#else
//	ZafIChar *pathName = strdup(argv[0]);
#endif
	// Display version.
	printf("Version %s Copyright (C) 1990-1997 Zinc Software Incorporated.\n\n", VERSION);
	if (argc != 2)
	{
		printf("Usage: loc2dat <filename>\n");
		return (1);
	}
#if defined(ZAF_UNICODE)
	ZafStorage *storage = new ZafStorage(zafCodeSet->ConvertToZafString(argv[1], 0, false),
		ZAF_FILE_OPENCREATE | ZAF_FILE_READWRITE);
#else
	ZafStorage *storage = new ZafStorage(argv[1], ZAF_FILE_OPENCREATE | ZAF_FILE_READWRITE);
#endif
	if (storage->Error())
	  {
	    printf("There was a problem\n");
	    delete storage;
	    return -1;
	  }
	ZafDataPersistence *persist = new ZafDataPersistence(zafDefaultDataConstructor,
		storage);
	for (int i = 0; Initialize[i]; i++)
	{
		ZafLocaleData *tmp = (Initialize[i])();
		tmp->Write(*persist);
		delete tmp;
	}
	storage->Save();
	delete persist;
	delete storage;
	return (0);
}

#else

#define str(s)		#s
#define xstr(s)		str(s)
#define append(a,b,c)	a##b##c
#define FILENAME(x)	append(loc_, x, .cpp)
#define FUNCTIONNAME(x)	append(_, x, _Initialize)

#undef ZIL_MSDOS
#undef ZIL_MSWINDOWS
#undef ZIL_OS2
#undef ZAF_MACINTOSH
#define LENGTHOF(x)	(sizeof(x)/sizeof((x)[0]))
#include xstr(FILENAME(LOCALE_NAME))

ZafLocaleData *FUNCTIONNAME(LOCALE_NAME)(void)
{
	ZafLocaleData *def = new ZafLocaleData;
//	ZIL_INTERNATIONAL::strcpy(def->name, _defaultLocaleName);
	def->SetStringID(defaultLocaleName);
	def->SetLocale(defaultLocale);
//	def->allocated = FALSE;
//	def->defaults = TRUE;
//	def->useCount = 0;
	return def;
}
#endif

