//	Zinc Application Framework - LANG_ES.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// In error statements, the %1%s is the data, the %2%s is the range.

#if defined(ZAF_LANGUAGE_INFO)
#	define langCodeset	CP_ISO8859_1
	// Language definitions for SPAINISH (ES).
	static ZafIChar ZAF_FARDATA defaultLanguageName[] = { 'e','s',0 };
#endif

#if defined(ZAF_LANGUAGE_DATA_INFO)
ZafIChar ZafLanguageData::blankString[] = ZAF_ITEXT("");
ZafIChar ZafLanguageData::errorString[] = ZAF_ITEXT("Error");
#endif

#if defined(ZAF_UTIME_DATA_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultDayStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Domingo"),	ZAF_DAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Lunes"),	ZAF_DAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Martes"),	ZAF_DAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mi\351rcoles"),	ZAF_DAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jueves"),	ZAF_DAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Viernes"),	ZAF_DAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("S\341bado"),	ZAF_DAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dom"),	ZAF_SHDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Lun"),	ZAF_SHDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar"),	ZAF_SHDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mi\351"),	ZAF_SHDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jue"),	ZAF_SHDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Vie"),	ZAF_SHDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("S\341b"),	ZAF_SHDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dom."),	ZAF_ABDAY_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Lun."),	ZAF_ABDAY_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar."),	ZAF_ABDAY_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mier."),	ZAF_ABDAY_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Juev."),	ZAF_ABDAY_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Vier."),	ZAF_ABDAY_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sab."),	ZAF_ABDAY_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultMonthStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Enero"),	ZAF_MON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Febrero"),	ZAF_MON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Marzo"),	ZAF_MON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Abril"),	ZAF_MON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mayo"),	ZAF_MON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Junio"),	ZAF_MON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Julio"),	ZAF_MON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Agosto"),	ZAF_MON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Septiembre"),	ZAF_MON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Octubre"),	ZAF_MON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Noviembre"),	ZAF_MON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Diciembre"),	ZAF_MON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ene"),	ZAF_SHMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Feb"),	ZAF_SHMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar"),	ZAF_SHMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Abr"),	ZAF_SHMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("May"),	ZAF_SHMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jun"),	ZAF_SHMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jul"),	ZAF_SHMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ago"),	ZAF_SHMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sep"),	ZAF_SHMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Oct"),	ZAF_SHMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Nov"),	ZAF_SHMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dic"),	ZAF_SHMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ene."),	ZAF_ABMON_1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Feb."),	ZAF_ABMON_2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mar."),	ZAF_ABMON_3, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Abr."),	ZAF_ABMON_4, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("May."),	ZAF_ABMON_5, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jun."),	ZAF_ABMON_6, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Jul."),	ZAF_ABMON_7, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ago."),	ZAF_ABMON_8, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Sept."),	ZAF_ABMON_9, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Oct."),	ZAF_ABMON_10, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Nov."),	ZAF_ABMON_11, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Dic."),	ZAF_ABMON_12, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
static ZafLanguageStruct ZAF_FARDATA defaultTimeStrings[] =
{
	{ ZAF_ITEXT(""), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("a.m."), ZAF_AM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("p.m."), ZAF_PM, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("xxxx"), ZAF_TZ, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_UTIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("La hora %s no est\341 en un formato v\341lido."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Debe introducir un valor de hora."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La hora %s no est\341 dentro del rango %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La hora %s es anterior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La hora %s es posterior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_BIGNUM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("El n\372mero %s no es v\341lido."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s no est\341 dentro del rango %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s es menor que %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s es mayor que %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_INTEGER_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("El n\372mero %s no es v\341lido."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s no est\341 dentro del rango %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s es menor que %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s es mayor que %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_REAL_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("El n\372mero %s no es v\341lido."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s no est\341 dentro del rango %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s es menor que %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El n\372mero %s es mayor que %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_DATE_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("La fecha %s no est\341 en un formato v\341lido."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El nombre del mes en la fecha %s es ambiguo."), ZAF_ERROR_AMBIGUOUS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("El nombre del mes en la fecha %s no es v\341lido."), ZAF_ERROR_INVALID_NAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Debe introducir un valor de fecha."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La fecha %s no est\341 dentro del rango %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La fecha %s es anterior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La fecha %s es posterior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_TIME_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("La hora %s no est\341 en un formato v\341lido."), ZAF_ERROR_INVALID, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Debe introducir un valor de hora."), ZAF_ERROR_VALUE_MISSING, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La hora %s no est\341 dentro del rango %s."), ZAF_ERROR_OUT_OF_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La hora %s es anterior a %s."), ZAF_ERROR_LESS_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("La hora %s es posterior a %s."), ZAF_ERROR_GREATER_THAN_RANGE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_ERROR_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("Error"), ZAF_MSG_TITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Aceptar"), ZAF_MSG_OK, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_ITEXT("Cancelar"), ZAF_MSG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'C', 0 },
	{ ZAF_ITEXT("Help"), ZAF_MSG_HELP, ZAF_NULLP(ZafStringIDChar), 'H', 0 },
	{ ZAF_ITEXT("ASTERISK"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Mover"), ZAF_MSG_MOVE, ZAF_NULLP(ZafStringIDChar), 'M', 0 },
	{ ZAF_ITEXT("Cerrar\tAlt+F4"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 'C', 0 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_FILE_DIALOG_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultFileStrings[] =
{
	{ ZAF_ITEXT("File New"), ZAF_MSG_NEW, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Open"), ZAF_MSG_OPEN, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("File Save"), ZAF_MSG_SAVEAS, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_HELP_SYSTEM_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultHelpStrings[] =
{
	{ ZAF_ITEXT("Elemento de la ayuda"), ZAF_MSG_HELP_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Indice de la ayuda"), ZAF_MSG_HELP_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ver un elemento"), ZAF_MSG_SHOW_TOPIC, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Ver indice"), ZAF_MSG_SHOW_INDEX, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Seleccione un Elemento"), ZAF_MSG_MESSAGE1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Teclee una palabra, o selecci\363nela de la lista."), ZAF_MSG_MESSAGE2, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Cerrar"), ZAF_MSG_CLOSE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Informaci\363n de Ayuda"), ZAF_MSG_ICONTITLE, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("QUESTION"), ZAF_MSG_ICONNAME, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_SYSTEM_BUTTON_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultStrings[] =
{
	{ ZAF_ITEXT("Restaurar"), ZAF_RESTORE_OPTION, ZAF_NULLP(ZafStringIDChar), 'R', 0 },		// S_RESTORE
	{ ZAF_ITEXT("Mover"), ZAF_MOVE_OPTION, ZAF_NULLP(ZafStringIDChar), 'M', 0 },			// S_MOVE_MODE
	{ ZAF_ITEXT("Tama\361o"), ZAF_SIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'T', 0 },		// S_SIZE_MODE
	{ ZAF_ITEXT("Minimizar"), ZAF_MINIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'N', 2 },	// S_MINIMIZE
	{ ZAF_ITEXT("Maximizar"), ZAF_MAXIMIZE_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 2 },	// S_MAXIMIZE
	{ ZAF_ITEXT(""), ZAF_SEPARATOR, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Cerrar"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', 0 },			// S_CLOSE
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_POPUP_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultPopupStrings[] =
{
#	if defined(ZAF_MACINTOSH)
	{ ZAF_ITEXT("Quit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'Q', -1 },
	{ ZAF_ITEXT("Cerrar"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'W', -1 },
	{ ZAF_ITEXT("Cut"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', -1 },
	{ ZAF_ITEXT("Copy"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', -1 },
	{ ZAF_ITEXT("Paste"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 'V', -1 },
#	else
	{ ZAF_ITEXT("Exit"), ZAF_EXIT_OPTION, ZAF_NULLP(ZafStringIDChar), 'X', 1 },
	{ ZAF_ITEXT("Cerrar"), ZAF_CLOSE_OPTION, ZAF_NULLP(ZafStringIDChar), 'C', 0 },
	{ ZAF_ITEXT("Cut\tCtl+X"), ZAF_CUT_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Copy\tCtl+C"), ZAF_COPY_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_ITEXT("Paste\tCtl+V"), ZAF_PASTE_OPTION, ZAF_NULLP(ZafStringIDChar), 0, -1 },
#	endif
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultErrorStrings[] =
{
	{ ZAF_ITEXT("ERROR"), (ZafNumberID)-1, ZAF_NULLP(ZafStringIDChar), 0, -1 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif

#if defined(ZAF_MESSAGE_WINDOW_INFO)
static ZafLanguageStruct ZAF_FARDATA defaultMessageStrings[] =
{
	{ ZAF_ITEXT("OK"), ZAF_DIALOG_OK, ZAF_NULLP(ZafStringIDChar), 'O', 0 },
	{ ZAF_ITEXT("Si"), ZAF_DIALOG_YES, ZAF_NULLP(ZafStringIDChar), 'S', 0 },
	{ ZAF_ITEXT("No"), ZAF_DIALOG_NO, ZAF_NULLP(ZafStringIDChar), 'N', 0 },
	{ ZAF_ITEXT("Abortar"), ZAF_DIALOG_ABORT, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_ITEXT("Repetir"), ZAF_DIALOG_RETRY, ZAF_NULLP(ZafStringIDChar), 'R', 0 },
	{ ZAF_ITEXT("Ignorar"), ZAF_DIALOG_IGNORE, ZAF_NULLP(ZafStringIDChar), 'I', 0 },
	{ ZAF_ITEXT("Cancelar"), ZAF_DIALOG_CANCEL, ZAF_NULLP(ZafStringIDChar), 'C', 0 },
	{ ZAF_ITEXT("Ayuda"), ZAF_DIALOG_HELP, ZAF_NULLP(ZafStringIDChar), 'A', 0 },
	{ ZAF_NULLP(ZafIChar), ZAF_NUMID_NULL, ZAF_NULLP(ZafStringIDChar), 0, -1 }
};
#endif
