//	Zinc Application Framework - IMG_US.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_dsp.hpp>

#define gnd	ZAF_CLR_BACKGROUND
#define blk	ZAF_CLR_BLACK
#define wte	ZAF_CLR_WHITE
#define gry	ZAF_CLR_LIGHTGRAY
#define dkg	ZAF_CLR_DARKGRAY
#define red	ZAF_CLR_RED
#define blu	ZAF_CLR_BLUE
#define grn	ZAF_CLR_GREEN
#define ylw	ZAF_CLR_YELLOW

#if defined(ZAF_MOUSE_INFO)
static ZafLogicalColor ZAF_FARDATA defaultViewArray[160] =
{
	blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,wte,wte,wte,wte,wte,blk,blk,blk,gnd,
	blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	blk,blk,blk,blk,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd
};
static ZafMouseStruct _view_ZafMouse(10,16,defaultViewArray,0,0,true);

static ZafLogicalColor ZAF_FARDATA defaultEditArray[75] =
{
	blk,blk,gnd,blk,blk,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	gnd,gnd,blk,gnd,gnd,
	blk,blk,gnd,blk,blk
};
static ZafMouseStruct _edit_ZafMouse(5,15,defaultEditArray,2,6,true);

static ZafLogicalColor ZAF_FARDATA defaultWaitArray[405] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	gnd,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,gnd,
	gnd,blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,gnd,
	gnd,blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,gnd,
	gnd,blk,blk,wte,wte,wte,wte,wte,wte,gry,wte,wte,blk,blk,gnd,
	gnd,blk,blk,wte,gry,wte,gry,wte,gry,wte,gry,wte,blk,blk,gnd,
	gnd,blk,blk,wte,wte,gry,wte,gry,wte,gry,wte,wte,blk,blk,gnd,
	gnd,gnd,blk,blk,wte,wte,gry,wte,gry,wte,wte,blk,blk,gnd,gnd,
	gnd,gnd,gnd,blk,blk,wte,wte,gry,wte,wte,blk,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,blk,wte,wte,wte,blk,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blk,wte,blk,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blk,wte,blk,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blk,wte,blk,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,blk,wte,wte,wte,blk,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,blk,wte,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,
	gnd,gnd,blk,blk,wte,wte,wte,gry,wte,wte,wte,blk,blk,gnd,gnd,
	gnd,blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,gnd,
	gnd,blk,blk,wte,wte,wte,wte,gry,wte,wte,wte,wte,blk,blk,gnd,
	gnd,blk,blk,wte,wte,wte,gry,wte,gry,wte,wte,wte,blk,blk,gnd,
	gnd,blk,blk,wte,wte,gry,wte,gry,wte,gry,wte,wte,blk,blk,gnd,
	gnd,blk,blk,wte,gry,wte,gry,wte,gry,wte,gry,wte,blk,blk,gnd,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafMouseStruct _wait_ZafMouse(15,27,defaultWaitArray,7,13,true);

static ZafLogicalColor ZAF_FARDATA defaultMoveArray[361] =
{
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,wte,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,
	gnd,gnd,blk,wte,blk,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,
	gnd,blk,wte,wte,blk,blk,blk,blk,blk,wte,blk,blk,blk,blk,blk,wte,wte,blk,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,gnd,wte,wte,wte,blk,
	gnd,blk,wte,wte,blk,blk,blk,blk,blk,wte,blk,blk,blk,blk,blk,wte,wte,blk,gnd,
	gnd,gnd,blk,wte,blk,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,
	gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,wte,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd
};
static ZafMouseStruct _move_ZafMouse(19,19,defaultMoveArray,9,9,true);

static ZafLogicalColor ZAF_FARDATA defaultHorizontalArray[192] =
{
	gnd,gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,
	gnd,gnd,blk,wte,wte,blk,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,
	gnd,blk,wte,wte,wte,blk,blk,blk,blk,blk,blk,wte,wte,wte,blk,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,
	gnd,blk,wte,wte,wte,blk,blk,blk,blk,blk,blk,wte,wte,wte,blk,gnd,
	gnd,gnd,blk,wte,wte,blk,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,gnd
};
static ZafMouseStruct _horizontal_ZafMouse(16,12,defaultHorizontalArray,7,5,true);

static ZafLogicalColor ZAF_FARDATA defaultVerticalArray[192] =
{
	gnd,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	gnd,gnd,blk,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,
	gnd,blk,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,
	blk,blk,blk,blk,blk,wte,wte,blk,blk,blk,blk,blk,
	gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,gnd,gnd,
	blk,blk,blk,blk,blk,wte,wte,blk,blk,blk,blk,blk,
	gnd,blk,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,
	gnd,gnd,blk,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd,gnd,gnd,gnd
};
static ZafMouseStruct _vertical_ZafMouse(12,16,defaultVerticalArray,5,7,true);

static ZafLogicalColor ZAF_FARDATA defaultLeftArray[144] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,blk,
	blk,wte,blk,blk,wte,wte,wte,blk,gnd,gnd,blk,blk,
	blk,blk,gnd,gnd,blk,wte,wte,wte,blk,blk,wte,blk,
	blk,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,blk,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,
	gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafMouseStruct _left_ZafMouse(12,12,defaultLeftArray,5,5,true);

static ZafLogicalColor ZAF_FARDATA defaultRightArray[144] =
{
	gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,blk,
	blk,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,
	blk,blk,gnd,gnd,blk,wte,wte,wte,blk,blk,wte,blk,
	blk,wte,blk,blk,wte,wte,wte,blk,gnd,gnd,blk,blk,
	blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,blk,
	blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,gnd,gnd,
	blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd
};
static ZafMouseStruct _right_ZafMouse(12,12,defaultRightArray,5,5,true);

static ZafLogicalColor ZAF_FARDATA defaultCrossHairsArray[121] =
{
	gnd,gnd,gnd,gnd,blk,blk,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,
	blk,blk,blk,blk,blk,wte,blk,blk,blk,blk,blk,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,
	blk,blk,blk,blk,blk,wte,blk,blk,blk,blk,blk,
	gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,wte,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,blk,blk,gnd,gnd,gnd,gnd
};
static ZafMouseStruct _crossHairs_ZafMouse(11,11,defaultCrossHairsArray,5,5,true);

static ZafLogicalColor ZAF_FARDATA defaultCancelArray[400] =
{
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,wte,wte,wte,wte,wte,wte,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,wte,wte,blk,blk,blk,blk,blk,blk,wte,wte,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,wte,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,wte,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,wte,blk,blk,blk,blk,wte,wte,wte,wte,blk,blk,blk,blk,wte,gnd,gnd,gnd,
	gnd,gnd,wte,blk,blk,blk,wte,wte,gnd,gnd,gnd,gnd,wte,wte,blk,blk,blk,wte,gnd,gnd,
	gnd,wte,blk,blk,blk,blk,blk,wte,gnd,gnd,gnd,gnd,gnd,gnd,wte,blk,blk,blk,wte,gnd,
	gnd,wte,blk,blk,wte,blk,blk,blk,wte,gnd,gnd,gnd,gnd,gnd,gnd,wte,blk,blk,wte,gnd,
	wte,blk,blk,blk,wte,wte,blk,blk,blk,wte,gnd,gnd,gnd,gnd,gnd,wte,blk,blk,blk,wte,
	wte,blk,blk,wte,gnd,gnd,wte,blk,blk,blk,wte,gnd,gnd,gnd,gnd,gnd,wte,blk,blk,wte,
	wte,blk,blk,wte,gnd,gnd,gnd,wte,blk,blk,blk,wte,gnd,gnd,gnd,gnd,wte,blk,blk,wte,
	wte,blk,blk,wte,gnd,gnd,gnd,gnd,wte,blk,blk,blk,wte,gnd,gnd,gnd,wte,blk,blk,wte,
	wte,blk,blk,wte,gnd,gnd,gnd,gnd,gnd,wte,blk,blk,blk,wte,gnd,gnd,wte,blk,blk,wte,
	wte,blk,blk,blk,wte,gnd,gnd,gnd,gnd,gnd,wte,blk,blk,blk,wte,wte,blk,blk,blk,wte,
	gnd,wte,blk,blk,wte,gnd,gnd,gnd,gnd,gnd,gnd,wte,blk,blk,blk,wte,blk,blk,wte,gnd,
	gnd,wte,blk,blk,blk,wte,gnd,gnd,gnd,gnd,gnd,gnd,wte,blk,blk,blk,blk,blk,wte,gnd,
	gnd,gnd,wte,blk,blk,blk,wte,wte,gnd,gnd,gnd,gnd,wte,wte,blk,blk,blk,wte,gnd,gnd,
	gnd,gnd,gnd,wte,blk,blk,blk,blk,wte,wte,wte,wte,blk,blk,blk,blk,wte,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,wte,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,wte,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,wte,wte,blk,blk,blk,blk,blk,blk,wte,wte,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,wte,wte,wte,wte,wte,wte,gnd,gnd,gnd,gnd,gnd,gnd,gnd
};
static ZafMouseStruct _cancel_ZafMouse(20,20,defaultCancelArray,7,7,true);

static ZafLogicalColor ZAF_FARDATA defaultDragMoveArray[390] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,wte,blk,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,blk,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,wte,blk,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,wte,wte,wte,blk,wte,blk,gnd,gnd,gnd,
	blk,blk,blk,blk,blk,blk,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,blk,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd
};
static ZafMouseStruct _dragMove_ZafMouse(15,26,defaultDragMoveArray,7,7,true);

static ZafLogicalColor ZAF_FARDATA defaultDragCopyArray[390] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,wte,blk,gnd,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,blk,wte,blk,blk,blk,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,blk,blk,blk,blk,blk,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,wte,blk,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,wte,wte,wte,blk,wte,wte,wte,blk,wte,blk,gnd,gnd,gnd,
	blk,blk,blk,blk,blk,blk,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,blk,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd
};
static ZafMouseStruct _dragCopy_ZafMouse(15,26,defaultDragCopyArray,7,7,true);

static ZafLogicalColor ZAF_FARDATA defaultDragMoveMultipleArray[494] =
{
	gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,blk,wte,blk,gnd,gnd,gnd,gnd,
	gnd,blk,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,blk,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,blk,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,wte,wte,blk,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,blk,blk,blk,blk,blk,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,wte,wte,wte,wte,wte,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,blk,blk,blk,blk,blk,blk,blk,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,blk,wte,wte,wte,wte,wte,wte,wte,blk,gnd,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,blk,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd
};
static ZafMouseStruct _dragMoveMultiple_ZafMouse(19,26,defaultDragMoveMultipleArray,7,7,true);

static ZafLogicalColor ZAF_FARDATA defaultDragCopyMultipleArray[494] =
{
	gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,blk,wte,blk,gnd,gnd,gnd,gnd,
	gnd,blk,blk,wte,blk,wte,wte,wte,wte,blk,wte,wte,blk,blk,blk,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,blk,blk,blk,blk,blk,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,blk,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,blk,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,wte,wte,wte,wte,blk,wte,wte,wte,blk,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,blk,blk,blk,blk,blk,blk,wte,wte,wte,wte,blk,blk,gnd,gnd,gnd,
	blk,wte,blk,wte,wte,wte,wte,wte,wte,blk,wte,wte,wte,wte,wte,blk,gnd,gnd,gnd,
	blk,wte,blk,blk,blk,blk,blk,blk,blk,blk,wte,wte,wte,wte,wte,wte,blk,gnd,gnd,
	blk,wte,wte,wte,wte,wte,wte,wte,wte,blk,wte,wte,wte,wte,wte,wte,wte,blk,gnd,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,wte,wte,wte,blk,blk,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,wte,wte,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,wte,wte,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,gnd,gnd
};
static ZafMouseStruct _dragCopyMultiple_ZafMouse(19,26,defaultDragCopyMultipleArray,7,7,true);

#endif // Mouse

#if defined(ZAF_CURSOR_INFO)
static ZafLogicalColor ZAF_FARDATA insertArray[42] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _insert_ZafCursor(2,14,insertArray,true);

static ZafLogicalColor ZAF_FARDATA overstrikeArray[21] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _overstrike_ZafCursor(1,14,overstrikeArray,true);

#endif // Cursor

#if defined(ZAF_BUTTON_INFO)
static ZafLogicalColor ZAF_FARDATA checkArray[169] =
{
	dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,wte,
	dkg,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte
};
static ZafBitmapStruct _check_ZafBitmap(13,13,checkArray,true);

static ZafLogicalColor ZAF_FARDATA checkDepressedArray[169] =
{
	dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,wte,
	dkg,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte
};
static ZafBitmapStruct _checkDepressed_ZafBitmap(13,13,checkDepressedArray,true);

static ZafLogicalColor ZAF_FARDATA checkSelectedArray[169] =
{
	dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,wte,
	dkg,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,blk,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,blk,blk,wte,gry,wte,
	dkg,blk,wte,blk,wte,wte,wte,blk,blk,blk,wte,gry,wte,
	dkg,blk,wte,blk,blk,wte,blk,blk,blk,wte,wte,gry,wte,
	dkg,blk,wte,blk,blk,blk,blk,blk,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,blk,blk,blk,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,blk,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte
};
static ZafBitmapStruct _checkSelected_ZafBitmap(13,13,checkSelectedArray,true);

static ZafLogicalColor ZAF_FARDATA checkSelectedDepressedArray[169] =
{
	dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,wte,
	dkg,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,blk,blk,gry,gry,wte,
	dkg,blk,gry,blk,gry,gry,gry,blk,blk,blk,gry,gry,wte,
	dkg,blk,gry,blk,blk,gry,blk,blk,blk,gry,gry,gry,wte,
	dkg,blk,gry,blk,blk,blk,blk,blk,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,blk,blk,blk,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,blk,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte
};
static ZafBitmapStruct _checkSelectedDepressed_ZafBitmap(13,13,checkSelectedDepressedArray,true);

static ZafLogicalColor ZAF_FARDATA radioArray[169] =
{
	gnd,gnd,gnd,gnd,dkg,dkg,dkg,dkg,dkg,gnd,gnd,gnd,gnd,
	gnd,gnd,dkg,dkg,blk,blk,blk,blk,blk,dkg,dkg,gnd,gnd,
	gnd,dkg,blk,blk,wte,wte,wte,wte,wte,blk,blk,wte,gnd,
	gnd,dkg,blk,wte,wte,wte,wte,wte,wte,wte,gry,wte,gnd,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,gry,wte,
	gnd,dkg,blk,wte,wte,wte,wte,wte,wte,wte,gry,wte,gnd,
	gnd,dkg,dkg,gry,wte,wte,wte,wte,wte,gry,wte,wte,gnd,
	gnd,gnd,wte,wte,gry,gry,gry,gry,gry,wte,wte,gnd,gnd,
	gnd,gnd,gnd,gnd,wte,wte,wte,wte,wte,gnd,gnd,gnd,gnd	
};
static ZafBitmapStruct _radio_ZafBitmap(13,13,radioArray,true);

static ZafLogicalColor ZAF_FARDATA radioDepressedArray[169] =
{
	gnd,gnd,gnd,gnd,dkg,dkg,dkg,dkg,dkg,gnd,gnd,gnd,gnd,
	gnd,gnd,dkg,dkg,blk,blk,blk,blk,blk,dkg,dkg,gnd,gnd,
	gnd,dkg,blk,blk,gry,gry,gry,gry,gry,blk,blk,wte,gnd,
	gnd,dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,wte,gnd,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	gnd,dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,wte,gnd,
	gnd,dkg,dkg,gry,gry,gry,gry,gry,gry,gry,wte,wte,gnd,
	gnd,gnd,wte,wte,gry,gry,gry,gry,gry,wte,wte,gnd,gnd,
	gnd,gnd,gnd,gnd,wte,wte,wte,wte,wte,gnd,gnd,gnd,gnd	
};
static ZafBitmapStruct _radioDepressed_ZafBitmap(13,13,radioDepressedArray,true);

static ZafLogicalColor ZAF_FARDATA radioSelectedArray[169] =
{
	gnd,gnd,gnd,gnd,dkg,dkg,dkg,dkg,dkg,gnd,gnd,gnd,gnd,
	gnd,gnd,dkg,dkg,blk,blk,blk,blk,blk,dkg,dkg,gnd,gnd,
	gnd,dkg,blk,blk,wte,wte,wte,wte,wte,blk,blk,wte,gnd,
	gnd,dkg,blk,wte,wte,wte,wte,wte,wte,wte,gry,wte,gnd,
	dkg,blk,wte,wte,wte,blk,blk,blk,wte,wte,wte,gry,wte,
	dkg,blk,wte,wte,blk,blk,blk,blk,blk,wte,wte,gry,wte,
	dkg,blk,wte,wte,blk,blk,blk,blk,blk,wte,wte,gry,wte,
	dkg,blk,wte,wte,blk,blk,blk,blk,blk,wte,wte,gry,wte,
	dkg,blk,wte,wte,wte,blk,blk,blk,wte,wte,wte,gry,wte,
	gnd,dkg,blk,wte,wte,wte,wte,wte,wte,wte,gry,wte,gnd,
	gnd,dkg,dkg,gry,wte,wte,wte,wte,wte,gry,wte,wte,gnd,
	gnd,gnd,wte,wte,gry,gry,gry,gry,gry,wte,wte,gnd,gnd,
	gnd,gnd,gnd,gnd,wte,wte,wte,wte,wte,gnd,gnd,gnd,gnd	
};
static ZafBitmapStruct _radioSelected_ZafBitmap(13,13,radioSelectedArray,true);

static ZafLogicalColor ZAF_FARDATA radioSelectedDepressedArray[169] =
{
	gnd,gnd,gnd,gnd,dkg,dkg,dkg,dkg,dkg,gnd,gnd,gnd,gnd,
	gnd,gnd,dkg,dkg,blk,blk,blk,blk,blk,dkg,dkg,gnd,gnd,
	gnd,dkg,blk,blk,gry,gry,gry,gry,gry,blk,blk,wte,gnd,
	gnd,dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,wte,gnd,
	dkg,blk,gry,gry,gry,blk,blk,blk,gry,gry,gry,gry,wte,
	dkg,blk,gry,gry,blk,blk,blk,blk,blk,gry,gry,gry,wte,
	dkg,blk,gry,gry,blk,blk,blk,blk,blk,gry,gry,gry,wte,
	dkg,blk,gry,gry,blk,blk,blk,blk,blk,gry,gry,gry,wte,
	dkg,blk,gry,gry,gry,blk,blk,blk,gry,gry,gry,gry,wte,
	gnd,dkg,blk,gry,gry,gry,gry,gry,gry,gry,gry,wte,gnd,
	gnd,dkg,dkg,gry,gry,gry,gry,gry,gry,gry,wte,wte,gnd,
	gnd,gnd,wte,wte,gry,gry,gry,gry,gry,wte,wte,gnd,gnd,
	gnd,gnd,gnd,gnd,wte,wte,wte,wte,wte,gnd,gnd,gnd,gnd	
};
static ZafBitmapStruct _radioSelectedDepressed_ZafBitmap(13,13,radioSelectedDepressedArray,true);

#endif // Button

#if defined(ZAF_MINIMIZE_BUTTON_INFO)
static ZafLogicalColor ZAF_FARDATA minNormalArray[224] =
{
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _min_ZafBitmap(16,14,minNormalArray,true);

static ZafLogicalColor ZAF_FARDATA minDepressedArray[224] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,gry,wte,
	blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte
};
static ZafBitmapStruct _minDepressed_ZafBitmap(16,14,minDepressedArray,true);
#endif // Minimize Button

#if defined(ZAF_MAXIMIZE_BUTTON_INFO)
static ZafLogicalColor ZAF_FARDATA maxNormalArray[224] =
{
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,gry,dkg,blk,
	wte,gry,gry,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,dkg,blk,
	wte,gry,gry,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _max_ZafBitmap(16,14,maxNormalArray,true);

static ZafLogicalColor ZAF_FARDATA maxNormDepressedArray[224] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,gry,wte,
	blk,dkg,gry,gry,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,gry,gry,gry,blk,gry,gry,wte,
	blk,dkg,gry,gry,blk,blk,blk,blk,blk,blk,blk,blk,blk,gry,gry,wte,
	blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,
};
static ZafBitmapStruct _maxDepressed_ZafBitmap(16,14,maxNormDepressedArray,true);

static ZafLogicalColor ZAF_FARDATA maximizedArray[224] =
{
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,blk,gry,gry,gry,gry,blk,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,blk,blk,blk,blk,blk,gry,blk,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,blk,blk,blk,blk,blk,gry,blk,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,blk,blk,blk,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,blk,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,gry,gry,gry,gry,blk,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _maximized_ZafBitmap(16,14,maximizedArray,true);

static ZafLogicalColor ZAF_FARDATA maximizedDepressedArray[224] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,wte,
	blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,blk,gry,gry,gry,gry,blk,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,blk,blk,blk,blk,blk,gry,blk,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,blk,blk,blk,blk,blk,gry,blk,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,blk,blk,blk,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,blk,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,gry,gry,gry,gry,blk,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,blk,blk,blk,blk,blk,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte
};
static ZafBitmapStruct _maximizedDepressed_ZafBitmap(16,14,maximizedDepressedArray,true);
#endif // Maximize Button

#if defined(ZAF_CLOSE_BUTTON_INFO)
static ZafLogicalColor ZAF_FARDATA closeNormalArray[224] =
{
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,blk,gry,gry,gry,gry,gry,blk,blk,gry,gry,dkg,blk,
	wte,gry,gry,gry,blk,blk,gry,gry,gry,blk,blk,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,blk,blk,gry,blk,blk,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,blk,blk,blk,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,blk,blk,blk,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,blk,blk,gry,blk,blk,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,blk,blk,gry,gry,gry,blk,blk,gry,gry,gry,dkg,blk,
	wte,gry,gry,blk,blk,gry,gry,gry,gry,gry,blk,blk,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _close_ZafBitmap(16,14,closeNormalArray,true);

static ZafLogicalColor ZAF_FARDATA closeDepressedArray[224] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,blk,gry,gry,gry,gry,gry,blk,blk,gry,gry,wte,
	blk,dkg,gry,gry,gry,blk,blk,gry,gry,gry,blk,blk,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,blk,blk,gry,blk,blk,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,blk,blk,blk,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,gry,blk,blk,blk,gry,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,gry,blk,blk,gry,blk,blk,gry,gry,gry,gry,wte,
	blk,dkg,gry,gry,gry,blk,blk,gry,gry,gry,blk,blk,gry,gry,gry,wte,
	blk,dkg,gry,gry,blk,blk,gry,gry,gry,gry,gry,blk,blk,gry,gry,wte,
	blk,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,wte,
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte
};
static ZafBitmapStruct _closeDepressed_ZafBitmap(16,14,closeDepressedArray,true);

static ZafLogicalColor ZAF_FARDATA closeDisabledArray[224] =
{
	wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,dkg,dkg,gry,gry,gry,gry,gry,dkg,dkg,wte,gry,dkg,blk,
	wte,gry,gry,gry,dkg,dkg,gry,gry,gry,dkg,dkg,wte,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,dkg,dkg,gry,dkg,dkg,wte,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,dkg,dkg,dkg,wte,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,gry,dkg,dkg,dkg,gry,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,gry,dkg,dkg,wte,dkg,dkg,gry,gry,gry,gry,dkg,blk,
	wte,gry,gry,gry,dkg,dkg,wte,gry,gry,dkg,dkg,gry,gry,gry,dkg,blk,
	wte,gry,gry,dkg,dkg,wte,gry,gry,gry,gry,dkg,dkg,gry,gry,dkg,blk,
	wte,gry,gry,gry,wte,gry,gry,gry,gry,gry,wte,gry,wte,gry,dkg,blk,
	wte,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _closeDisabled_ZafBitmap(16,14,closeDisabledArray,true);
#endif // Close Button

#if defined(ZAF_SYSTEM_BUTTON_INFO)
static ZafLogicalColor ZAF_FARDATA sysButtonArray[21] =
{
	blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _sys_ZafBitmap(7,3,sysButtonArray,true);
#endif // System Button

#if defined(ZAF_SCROLL_BUTTON_INFO)
static ZafLogicalColor ZAF_FARDATA scrollUpArrowArray[28] =
{
	gnd,gnd,gnd,blk,gnd,gnd,gnd,
	gnd,gnd,blk,blk,blk,gnd,gnd,
	gnd,blk,blk,blk,blk,blk,gnd,
	blk,blk,blk,blk,blk,blk,blk
};
static ZafBitmapStruct _scrollUpArrow_ZafBitmap(7,4,scrollUpArrowArray,true);

static ZafLogicalColor ZAF_FARDATA scrollDownArrowArray[28] =
{
	blk,blk,blk,blk,blk,blk,blk,
	gnd,blk,blk,blk,blk,blk,gnd,
	gnd,gnd,blk,blk,blk,gnd,gnd,
	gnd,gnd,gnd,blk,gnd,gnd,gnd
};
static ZafBitmapStruct _scrollDownArrow_ZafBitmap(7,4,scrollDownArrowArray,true);

static ZafLogicalColor ZAF_FARDATA scrollLeftArrowArray[28] =
{
	gnd,gnd,gnd,blk,
	gnd,gnd,blk,blk,
	gnd,blk,blk,blk,
	blk,blk,blk,blk,
	gnd,blk,blk,blk,
	gnd,gnd,blk,blk,
	gnd,gnd,gnd,blk
};
static ZafBitmapStruct _scrollLeftArrow_ZafBitmap(4,7,scrollLeftArrowArray,true);

static ZafLogicalColor ZAF_FARDATA scrollRightArrowArray[28] =
{
	blk,gnd,gnd,gnd,
	blk,blk,gnd,gnd,
	blk,blk,blk,gnd,
	blk,blk,blk,blk,
	blk,blk,blk,gnd,
	blk,blk,gnd,gnd,
	blk,gnd,gnd,gnd
};
static ZafBitmapStruct _scrollRightArrow_ZafBitmap(4,7,scrollRightArrowArray,true);
#endif // Scroll Button

#if defined(ZAF_SPIN_BUTTON_INFO)
static ZafLogicalColor ZAF_FARDATA spinUpArrowArray[6] =
{
	gnd,blk,gnd,
	blk,blk,blk
};
static ZafBitmapStruct _spinUpArrow_ZafBitmap(3,2,spinUpArrowArray,true);

static ZafLogicalColor ZAF_FARDATA spinDownArrowArray[6] =
{
	blk,blk,blk,
	gnd,blk,gnd
};
static ZafBitmapStruct _spinDownArrow_ZafBitmap(3,2,spinDownArrowArray,true);
#endif // Spin Button

#if defined(ZAF_POPUP_INFO)
static ZafLogicalColor ZAF_FARDATA popupCheckNormalArray[90] =
{
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,gnd,
	gnd,blk,gnd,gnd,gnd,gnd,blk,gnd,gnd,
	blk,blk,blk,gnd,gnd,blk,blk,gnd,gnd,
	gnd,gnd,blk,blk,gnd,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,blk,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd
};
static ZafBitmapStruct _popupCheck_ZafBitmap(9,10,popupCheckNormalArray,true);

static ZafLogicalColor ZAF_FARDATA popupCheckCurrentArray[90] =
{
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,wte,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,wte,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,wte,wte,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,wte,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,wte,wte,gnd,
	gnd,wte,gnd,gnd,gnd,gnd,wte,gnd,gnd,
	wte,wte,wte,gnd,gnd,wte,wte,gnd,gnd,
	gnd,gnd,wte,wte,gnd,wte,gnd,gnd,gnd,
	gnd,gnd,gnd,wte,wte,wte,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,wte,gnd,gnd,gnd,gnd
};
static ZafBitmapStruct _popupCheckCurrent_ZafBitmap(9,10,popupCheckCurrentArray,true);

static ZafLogicalColor ZAF_FARDATA popupArrowNormalArray[45] =
{
	blk,gnd,gnd,gnd,gnd,
	blk,blk,gnd,gnd,gnd,
	blk,blk,blk,gnd,gnd,
	blk,blk,blk,blk,gnd,
	blk,blk,blk,blk,blk,
	blk,blk,blk,blk,gnd,
	blk,blk,blk,gnd,gnd,
	blk,blk,gnd,gnd,gnd,
	blk,gnd,gnd,gnd,gnd
};
static ZafBitmapStruct _popupArrow_ZafBitmap(5,9,popupArrowNormalArray,true);

static ZafLogicalColor ZAF_FARDATA popupArrowCurrentArray[45] =
{															   
	wte,gnd,gnd,gnd,gnd,
	wte,wte,gnd,gnd,gnd,
	wte,wte,wte,gnd,gnd,
	wte,wte,wte,wte,gnd,
	wte,wte,wte,wte,wte,
	wte,wte,wte,wte,gnd,
	wte,wte,wte,gnd,gnd,
	wte,wte,gnd,gnd,gnd,
	wte,gnd,gnd,gnd,gnd
};
static ZafBitmapStruct _popupArrowCurrent_ZafBitmap(5,9,popupArrowCurrentArray,true);
#endif // Pop-up item

#if defined(ZAF_TREE_INFO)
#	if defined(ZAF_MSWINDOWS) || defined(ZAF_MSDOS)
static ZafLogicalColor ZAF_FARDATA defaultCompressArray[81] =
{
	dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,
	dkg,gnd,gnd,gnd,gnd,gnd,gnd,gnd,dkg,
	dkg,gnd,gnd,gnd,blk,gnd,gnd,gnd,dkg,
	dkg,gnd,gnd,gnd,blk,gnd,gnd,gnd,dkg,
	dkg,gnd,blk,blk,blk,blk,blk,gnd,dkg,
	dkg,gnd,gnd,gnd,blk,gnd,gnd,gnd,dkg,
	dkg,gnd,gnd,gnd,blk,gnd,gnd,gnd,dkg,
	dkg,gnd,gnd,gnd,gnd,gnd,gnd,gnd,dkg,
	dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,
};
static ZafBitmapStruct _compress_ZafBitmap(9,9,defaultCompressArray,true);

static ZafLogicalColor ZAF_FARDATA defaultExpandArray[81] =
{
	dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,
	dkg,gnd,gnd,gnd,gnd,gnd,gnd,gnd,dkg,
	dkg,gnd,gnd,gnd,gnd,gnd,gnd,gnd,dkg,
	dkg,gnd,gnd,gnd,gnd,gnd,gnd,gnd,dkg,
	dkg,gnd,blk,blk,blk,blk,blk,gnd,dkg,
	dkg,gnd,gnd,gnd,gnd,gnd,gnd,gnd,dkg,
	dkg,gnd,gnd,gnd,gnd,gnd,gnd,gnd,dkg,
	dkg,gnd,gnd,gnd,gnd,gnd,gnd,gnd,dkg,
	dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,dkg,
};
static ZafBitmapStruct _expand_ZafBitmap(9,9,defaultExpandArray,true);
#	elif defined(ZAF_MACINTOSH)
static ZafLogicalColor ZAF_FARDATA defaultCompressArray[66] =
{
	blk,gnd,gnd,gnd,gnd,gnd,
	blk,blk,gnd,gnd,gnd,gnd,
	blk,gry,blk,gnd,gnd,gnd,
	blk,gry,gry,blk,gnd,gnd,
	blk,gry,gry,gry,blk,gnd,
	blk,gry,gry,gry,gry,blk,
	blk,gry,gry,gry,blk,gnd,
	blk,gry,gry,blk,gnd,gnd,
	blk,gry,blk,gnd,gnd,gnd,
	blk,blk,gnd,gnd,gnd,gnd,
	blk,gnd,gnd,gnd,gnd,gnd
};
static ZafBitmapStruct _compress_ZafBitmap(6,11,defaultCompressArray,true);

static ZafLogicalColor ZAF_FARDATA defaultExpandArray[66] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	gnd,blk,gry,gry,gry,gry,gry,gry,gry,blk,gnd,
	gnd,gnd,blk,gry,gry,gry,gry,gry,blk,gnd,gnd,
	gnd,gnd,gnd,blk,gry,gry,gry,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,gry,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd,gnd
};
static ZafBitmapStruct _expand_ZafBitmap(11,6,defaultExpandArray,true);
#	else
static ZafLogicalColor ZAF_FARDATA defaultCompressArray[45] =
{
	blk,gnd,gnd,gnd,gnd,
	blk,blk,gnd,gnd,gnd,
	blk,blk,blk,gnd,gnd,
	blk,blk,blk,blk,gnd,
	blk,blk,blk,blk,blk,
	blk,blk,blk,blk,gnd,
	blk,blk,blk,gnd,gnd,
	blk,blk,gnd,gnd,gnd,
	blk,gnd,gnd,gnd,gnd
};
static ZafBitmapStruct _compress_ZafBitmap(5,9,defaultCompressArray,true);

static ZafLogicalColor ZAF_FARDATA defaultExpandArray[45] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,
	gnd,blk,blk,blk,blk,blk,blk,blk,gnd,
	gnd,gnd,blk,blk,blk,blk,blk,gnd,gnd,
	gnd,gnd,gnd,blk,blk,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,gnd,gnd,gnd,gnd
};
static ZafBitmapStruct _expand_ZafBitmap(9,5,defaultExpandArray,true);
#	endif
#endif // Tree

#if defined(ZAF_ICON_INFO)
static ZafLogicalColor ZAF_FARDATA applicationIconArray[1024] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafIconStruct _application_ZafIcon(32,32,applicationIconArray,true);

static ZafLogicalColor ZAF_FARDATA asteriskIconArray[1024] =
{
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blu,blu,blu,blu,blu,blu,blu,blu,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blu,blu,blu,blu,blu,wte,wte,wte,wte,blu,blu,blu,blu,blu,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,gnd,
	gnd,gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,
	gnd,gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,
	gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,
	gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,
	gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,
	blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,
	blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,
	blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,
	blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,
	blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,
	blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,
	blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,
	blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,
	gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,
	gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,
	gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,
	gnd,gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,
	gnd,gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,
	gnd,gnd,gnd,blk,blu,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blu,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,blu,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blu,blu,blu,blu,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,blu,blu,blu,blu,blu,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,blu,blu,blu,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blu,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blu,blu,blu,blu,blu,blu,blu,blu,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd
};
static ZafIconStruct _asterisk_ZafIcon(32,32,asteriskIconArray,true);

static ZafLogicalColor ZAF_FARDATA exclamationIconArray[1024] =
{
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,gnd,
	gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,
	gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,
	gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,
	gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,
	gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,
	blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,
	blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,
	blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,
	blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,
	blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,
	blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,
	blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,
	blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,
	gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,
	gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,
	gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,
	gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,
	gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,
	gnd,gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,ylw,ylw,ylw,ylw,ylw,ylw,ylw,ylw,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd
};
static ZafIconStruct _exclamation_ZafIcon(32,32,exclamationIconArray,true);

static ZafLogicalColor ZAF_FARDATA handIconArray[1024] =
{
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,
	gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,
	gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,red,wte,wte,red,red,wte,wte,wte,wte,wte,red,red,wte,wte,red,red,red,wte,wte,wte,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,wte,red,red,wte,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,gnd,
	gnd,red,red,red,red,red,wte,red,red,wte,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,gnd,
	gnd,red,red,red,red,red,wte,red,red,red,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,gnd,
	gnd,red,red,red,red,red,wte,red,red,red,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,gnd,
	gnd,red,red,red,red,red,red,wte,wte,red,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,wte,wte,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,red,red,red,wte,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,red,red,red,wte,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,wte,red,red,wte,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,wte,red,red,wte,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,wte,red,red,wte,red,red,red,wte,red,red,red,wte,red,red,wte,red,red,wte,red,red,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,red,wte,wte,red,red,red,red,wte,red,red,red,red,wte,wte,red,red,red,wte,red,red,red,red,red,red,red,gnd,
	gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,
	gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,
	gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,red,red,red,red,red,red,red,red,red,red,red,red,red,red,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd
};
static ZafIconStruct _hand_ZafIcon(32,32,handIconArray,true);

static ZafLogicalColor ZAF_FARDATA questionIconArray[1024] =
{
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,grn,grn,grn,grn,grn,grn,grn,grn,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,blk,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,gnd,
	gnd,gnd,blk,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,
	gnd,gnd,blk,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,
	gnd,blk,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,blk,gnd,
	gnd,blk,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,blk,gnd,
	gnd,blk,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,blk,gnd,
	blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,
	blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,
	blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,
	blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,
	blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,
	blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,
	blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,
	blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,
	gnd,blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,gnd,
	gnd,blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,gnd,
	gnd,blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,gnd,
	gnd,gnd,blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,
	gnd,gnd,blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,
	gnd,gnd,gnd,blk,grn,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,blk,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,blk,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,blk,grn,grn,grn,grn,grn,grn,grn,wte,wte,wte,wte,grn,grn,grn,grn,grn,grn,grn,blk,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,grn,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,grn,grn,grn,grn,grn,grn,grn,grn,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,
	gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,blk,blk,blk,blk,blk,blk,blk,blk,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd,gnd
};
static ZafIconStruct _question_ZafIcon(32,32,questionIconArray,true);
#endif // Icon

#if defined(ZAF_ERROR_ICON_INFO)
static ZafLogicalColor ZAF_FARDATA errorIconArray[1024] =
{
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,
	red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red,red
};
static ZafBitmapStruct _error_ZafIcon(32,32,errorIconArray,true);
#endif // Error Icon

#if defined(ZAF_HELP_SYSTEM_INFO)
static ZafLogicalColor ZAF_FARDATA defaultHelpIconArray[81] =
{
	blk,blk,blk,blk,blk,blk,blk,blk,blk,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,
	blk,wte,wte,wte,blk,wte,wte,wte,blk,
	blk,wte,wte,wte,blk,wte,wte,wte,blk,
	blk,wte,blk,blk,blk,blk,blk,wte,blk,
	blk,wte,wte,wte,blk,wte,wte,wte,blk,
	blk,wte,wte,wte,blk,wte,wte,wte,blk,
	blk,wte,wte,wte,wte,wte,wte,wte,blk,
	blk,blk,blk,blk,blk,blk,blk,blk,blk
};
static ZafIconStruct _help_ZafIcon(9,9,defaultHelpIconArray,true);
#endif // Help Icon

#if defined(ZAF_COMBO_BUTTON_INFO)
static ZafLogicalColor ZAF_FARDATA comboDownArrowArray[28] =
{
	blk,blk,blk,blk,blk,blk,blk,
	gnd,blk,blk,blk,blk,blk,gnd,
	gnd,gnd,blk,blk,blk,gnd,gnd,
	gnd,gnd,gnd,blk,gnd,gnd,gnd
};
static ZafBitmapStruct _comboDownArrow_ZafBitmap(7,4,comboDownArrowArray,true);
#endif // Combo button

#if defined(ZAF_NOTEBOOK_SCROLL_ARROWS_INFO)
static ZafLogicalColor ZAF_FARDATA scrollLeftArrowArray[28] =
{
	gnd,gnd,gnd,blk,
	gnd,gnd,blk,blk,
	gnd,blk,blk,blk,
	blk,blk,blk,blk,
	gnd,blk,blk,blk,
	gnd,gnd,blk,blk,
	gnd,gnd,gnd,blk
};
static ZafBitmapStruct _scrollLeftArrow_ZafBitmap(4,7,scrollLeftArrowArray,true);

static ZafLogicalColor ZAF_FARDATA scrollRightArrowArray[28] =
{
	blk,gnd,gnd,gnd,
	blk,blk,gnd,gnd,
	blk,blk,blk,gnd,
	blk,blk,blk,blk,
	blk,blk,blk,gnd,
	blk,blk,gnd,gnd,
	blk,gnd,gnd,gnd
};
static ZafBitmapStruct _scrollRightArrow_ZafBitmap(4,7,scrollRightArrowArray,true);
#endif // Notebook Scroll Arrows

#undef gnd
#undef blk
#undef wte
#undef gry
#undef dkg
#undef red
#undef blu
#undef grn
#undef ylw
