//	Zinc Application Framework - GBL_DEF.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// Place all global data in this module in a shared data segment.
// (DLL's, shared libraries, etc.)
#define ZAF_SHARED_DATA
#include <z_keymap.hpp>

// --- Application objects (defined in z_app1.cpp) ---
#if defined(ZAF_REGION_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
int ZafCoordinateStruct::cellHeight;
int ZafCoordinateStruct::cellWidth;
long ZafCoordinateStruct::miniNumeratorX = 1;
long ZafCoordinateStruct::miniDenominatorX = 1;
long ZafCoordinateStruct::miniNumeratorY = 10;
long ZafCoordinateStruct::miniDenominatorY = 10;
long ZafCoordinateStruct::pixelsPerInchX;
long ZafCoordinateStruct::pixelsPerInchY;
#endif

#if defined(ZAF_APPLICATION_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafStaticModule *ZafApplication::staticModule = ZAF_NULLP(ZafStaticModule);
#endif

// --- Data objects (defined in z_data2.cpp) ---
#if defined(ZAF_BIGNUM_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafBignumData::classID = ID_ZAF_BIGNUM_DATA;
ZafClassNameChar ZAF_FARDATA ZafBignumData::className[] = ZAF_ITEXT("ZafBignumData");
#endif

#if defined(ZAF_BITMAP_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafBitmapData::classID = ID_ZAF_BITMAP_DATA;
ZafClassNameChar ZAF_FARDATA ZafBitmapData::className[] = ZAF_ITEXT("ZafBitmapData");
#endif

#if defined(ZAF_CODE_SET_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafCodeSetData::classID = ID_ZAF_CODE_SET_DATA;
ZafClassNameChar ZAF_FARDATA ZafCodeSetData::className[] = ZAF_ITEXT("ZafCodeSetData");

ZafCodeSetData *zafCodeSet = ZAF_NULLP(ZafCodeSetData);
#endif

#if defined(ZAF_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafData::classID = ID_ZAF_DATA;
ZafClassNameChar ZAF_FARDATA ZafData::className[] = ZAF_ITEXT("ZafData");
ZafClassID ZafDataRecord::classID = ID_ZAF_DATA_RECORD;
ZafClassNameChar ZAF_FARDATA ZafDataRecord::className[] = ZAF_ITEXT("ZafDataRecord");
ZafClassID ZafDataManager::classID = ID_ZAF_DATA_MANAGER;
ZafClassNameChar ZAF_FARDATA ZafDataManager::className[] = ZAF_ITEXT("ZafDataManager");

ZafDataManager *zafDataManager = ZAF_NULLP(ZafDataManager);
ZafDataPersistence *zafDataPersistence = ZAF_NULLP(ZafDataPersistence);
#endif

#if defined(ZAF_DATE_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafDateData::classID = ID_ZAF_DATE_DATA;
ZafClassNameChar ZAF_FARDATA ZafDateData::className[] = ZAF_ITEXT("ZafDateData");
#endif

#if defined(ZAF_FORMAT_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafFormatData::classID = ID_ZAF_FORMAT_DATA;
ZafClassNameChar ZAF_FARDATA ZafFormatData::className[] = ZAF_ITEXT("ZafFormatData");
#endif

#if defined(ZAF_ICON_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafIconData::classID = ID_ZAF_ICON_DATA;
ZafClassNameChar ZAF_FARDATA ZafIconData::className[] = ZAF_ITEXT("ZafIconData");
#endif

#if defined(ZAF_IMAGE_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafImageData::classID = ID_ZAF_IMAGE_DATA;
ZafClassNameChar ZAF_FARDATA ZafImageData::className[] = ZAF_ITEXT("ZafImageData");
#endif

#if defined(ZAF_INTEGER_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafIntegerData::classID = ID_ZAF_INTEGER_DATA;
ZafClassNameChar ZAF_FARDATA ZafIntegerData::className[] = ZAF_ITEXT("ZafIntegerData");
#endif

#if defined(ZAF_I18N_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafI18nData::classID = ID_ZAF_I18N_DATA;
ZafClassNameChar ZAF_FARDATA ZafI18nData::className[] = ZAF_ITEXT("ZafI18nData");
ZafIChar ZafI18nData::i18nName[64] = { 0 };
#endif

#if defined(ZAF_LANGUAGE_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafLanguageData::classID = ID_ZAF_LANGUAGE_DATA;
ZafClassNameChar ZAF_FARDATA ZafLanguageData::className[] = ZAF_ITEXT("ZafLanguageData");
ZafLanguageData *zafLanguage = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_LOCALE_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafLocaleData::classID = ID_ZAF_LOCALE_DATA;
ZafClassNameChar ZAF_FARDATA ZafLocaleData::className[] = ZAF_ITEXT("ZafLocaleData");
ZafLocaleData *zafLocale = ZAF_NULLP(ZafLocaleData);
ZafLocaleData *ZafLocaleData::canonicalLocale = ZAF_NULLP(ZafLocaleData);
#endif

#if defined(ZAF_MOUSE_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafMouseData::classID = ID_ZAF_MOUSE_DATA;
ZafClassNameChar ZAF_FARDATA ZafMouseData::className[] = ZAF_ITEXT("ZafMouseData");
#endif

#if defined(ZAF_PALETTE_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafPaletteData::classID = ID_ZAF_PALETTE_DATA;
ZafClassNameChar ZAF_FARDATA ZafPaletteData::className[] = ZAF_ITEXT("ZafPaletteData");
#endif

#if defined(ZAF_REAL_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafRealData::classID = ID_ZAF_REAL_DATA;
ZafClassNameChar ZAF_FARDATA ZafRealData::className[] = ZAF_ITEXT("ZafRealData");
#endif

#if defined(ZAF_SCROLL_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafScrollData::classID = ID_ZAF_SCROLL_DATA;
ZafClassNameChar ZAF_FARDATA ZafScrollData::className[] = ZAF_ITEXT("ZafScrollData");
#endif

#if defined(ZAF_STRING_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafStringData::classID = ID_ZAF_STRING_DATA;
ZafClassNameChar ZAF_FARDATA ZafStringData::className[] = ZAF_ITEXT("ZafStringData");
#endif

#if defined(ZAF_TIME_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafTimeData::classID = ID_ZAF_TIME_DATA;
ZafClassNameChar ZAF_FARDATA ZafTimeData::className[] = ZAF_ITEXT("ZafTimeData");
#endif

#if defined(ZAF_UTIME_DATA_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafUTimeData::classID = ID_ZAF_UTIME_DATA;
ZafClassNameChar ZAF_FARDATA ZafUTimeData::className[] = ZAF_ITEXT("ZafUTimeData");

ZafIChar ZAF_FARDATA ZafUTimeData::dayName[] = ZAF_ITEXT("ZafDayStrings");
ZafIChar ZAF_FARDATA ZafUTimeData::monthName[] = ZAF_ITEXT("ZafMonthStrings");
ZafIChar ZAF_FARDATA ZafUTimeData::timeName[] = ZAF_ITEXT("ZafTimeStrings");

ZafLanguageData *ZafUTimeData::dayStrings = ZAF_NULLP(ZafLanguageData);
ZafLanguageData *ZafUTimeData::monthStrings = ZAF_NULLP(ZafLanguageData);
ZafLanguageData *ZafUTimeData::timeStrings = ZAF_NULLP(ZafLanguageData);
#endif

// --- Device objects (defined in z_evtmgr.cpp) ---
#if defined(ZAF_LIST_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafElement::classID = ID_DEFAULT;
ZafClassNameChar ZAF_FARDATA ZafElement::className[] = ZAF_ITEXT("ZafElement");
#endif

#if defined(ZAF_FILE_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafIChar *ZafFileSystem::rootDirectoryName = ZAF_ITEXT("~");
ZafIChar *ZafFileSystem::parentDirectoryName = ZAF_ITEXT("..");
ZafIChar *ZafFileSystem::currentDirectoryName = ZAF_ITEXT(".");
#endif

#if defined(ZAF_CURSOR_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafCursor::classID = ID_ZAF_CURSOR;
ZafClassNameChar ZAF_FARDATA ZafCursor::className[] = ZAF_ITEXT("ZafCursor");

#if defined(ZAF_MACINTOSH)
int ZafCursor::blinkRate = 40;
ZafBitmapData *ZafCursor::imageTable[ZAF_MAXCURSORIMAGES] =
{
	ZAF_NULLP(ZafBitmapData)
};
#endif
#endif

#if defined(ZAF_DEVICE_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafDevice::classID = ID_ZAF_DEVICE;
ZafClassNameChar ZAF_FARDATA ZafDevice::className[] = ZAF_ITEXT("ZafDevice");
ZafDevice::ZafAltState ZafDevice::altState = ZAF_ALT_NOT_PRESSED;
ZafDisplay *ZafDevice::display = ZAF_NULLP(ZafDisplay);
ZafEventManager *ZafDevice::eventManager = ZAF_NULLP(ZafEventManager);
ZafEventManager *zafEventManager = ZAF_NULLP(ZafEventManager);
#endif

#if defined(ZAF_KEYBOARD_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafKeyboard::classID = ID_ZAF_KEYBOARD;
ZafClassNameChar ZAF_FARDATA ZafKeyboard::className[] = ZAF_ITEXT("ZafKeyboard");
#endif

#if defined(ZAF_MOUSE_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafMouse::classID = ID_ZAF_MOUSE;
ZafClassNameChar ZAF_FARDATA ZafMouse::className[] = ZAF_ITEXT("ZafMouse");

#if defined(ZAF_MACINTOSH)
ZafMouseData **ZafMouse::imageTable = ZAF_NULLP(ZafMouseData *);
#endif
#endif

#if defined(ZAF_TIMER_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafTimer::classID = ID_ZAF_TIMER;
ZafClassNameChar ZAF_FARDATA ZafTimer::className[] = ZAF_ITEXT("ZafTimer");
#endif

#if defined(ZAF_HELP_TIPS_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafHelpTips::classID = ID_ZAF_HELPTIPS;
ZafClassNameChar ZAF_FARDATA ZafHelpTips::className[] = ZAF_ITEXT("ZafHelpTips");
int ZafHelpTips::initialDelay = 50;
int ZafHelpTips::newHelpTipDelay = 50;
#endif

// --- Display ---
#if defined(ZAF_DISPLAY_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafDisplay *zafDisplay = ZAF_NULLP(ZafDisplay);

#if defined(ZAF_MACINTOSH)
// See Inside Macintosh: Imaging With QuickDraw, page 4-71 for the 8
// ImageWriter II color matches, which are used here.
OSColor ZAF_FARDATA ZafDisplay::colorTable[ZAF_MAXCOLORS] =
{
	{ 0x0000, 0x0000, 0x0000 },							// ZAF_CLR_BLACK
	{ 0x0000, 0x0000, 0xD400 },							// ZAF_CLR_BLUE
	{ 0x0000, 0x64AF, 0x11B0 },							// ZAF_CLR_GREEN
	{ 0x0241, 0xAB54, 0xEAFF },							// ZAF_CLR_CYAN
	{ 0xDD6B, 0x08C2, 0x06A2 },							// ZAF_CLR_RED
	{ 0xF2D7, 0x0856, 0x84EC },							// ZAF_CLR_MAGENTA
	{ 0x8B00, 0x2D00, 0x1300 },							// ZAF_CLR_BROWN
	{ 0xC100, 0xC100, 0xC100 },							// ZAF_CLR_LIGHTGRAY
	{ 0x8000, 0x8000, 0x8000 },							// ZAF_CLR_DARKGRAY
	{ 0x0000, 0x6000, 0xFFFF },							// ZAF_CLR_LIGHTBLUE
	{ 0x0000, 0xFFFF, 0x11B0 },							// ZAF_CLR_LIGHTGREEN
	{ 0x0241, 0xFFFF, 0xFFFF },							// ZAF_CLR_LIGHTCYAN
	{ 0xFFFF, 0x2000, 0x0000 },							// ZAF_CLR_LIGHTRED
	{ 0xFFFF, 0x8056, 0xFFFF },							// ZAF_CLR_LIGHTMAGENTA
	{ 0xFC00, 0xF37D, 0x052F },							// ZAF_CLR_YELLOW
	{ 0xFFFF, 0xFFFF, 0xFFFF }							// ZAF_CLR_WHITE
};
OSFont ZAF_FARDATA ZafDisplay::fontTable[ZAF_MAXFONTS] =
{
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },	// ZAF_FNT_SMALL
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },	// ZAF_FNT_DIALOG
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },	// ZAF_FNT_APPLICATION
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },	// ZAF_FNT_SYSTEM
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },	// ZAF_FNT_FIXED
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } },
	{ systemFont, normal, srcOr, 12, { 0, 0, 0, 0 } }
};
OSLineStyle ZAF_FARDATA ZafDisplay::lineTable[ZAF_MAXLINES];
OSMode ZAF_FARDATA ZafDisplay::modeTable[ZAF_MAXMODES] =
{
	{ patCopy, srcCopy },								// ZAF_MODE_COPY
	{ patXor, srcXor }									// ZAF_MODE_XOR
};
OSMono ZAF_FARDATA ZafDisplay::monoTable[ZAF_MAXCOLORS] =
{
	blackColor,											// ZAF_MONO_BLACK
	whiteColor,											// ZAF_MONO_DIM
	whiteColor,											// ZAF_MONO_WHITE/MONO_NORMAL
	whiteColor											// ZAF_MONO_HIGH
};
OSFillPattern ZAF_FARDATA ZafDisplay::patternTable[ZAF_MAXPATTERNS];
#endif
#endif

// --- Window objects ---
#if defined(ZAF_BIGNUM_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafBignum::classID = ID_ZAF_BIGNUM;
ZafClassNameChar ZAF_FARDATA ZafBignum::className[] = ZAF_ITEXT("ZafBignum");
ZafLanguageData *ZafBignum::errorStrings = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_BORDER_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafBorder::classID = ID_ZAF_BORDER;
ZafClassNameChar ZAF_FARDATA ZafBorder::className[] = ZAF_ITEXT("ZafBorder");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafBorder::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ACTIVE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIACTIVE, ZAF_CLR_MDIACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIINACTIVE, ZAF_CLR_MDIINACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_LIGHT_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_WHITE, ZAF_CLR_WHITE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_DARK_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DARKGRAY, ZAF_CLR_DARKGRAY, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafBorder::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
int ZafBorder::width = 0;
#endif
#endif

#if defined(ZAF_BUTTON_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafButton::classID = ID_ZAF_BUTTON;
ZafClassNameChar ZAF_FARDATA ZafButton::className[] = ZAF_ITEXT("ZafButton");

char ZAF_FARDATA ZafButton::checkName[] = "check";
char ZAF_FARDATA ZafButton::checkSelectedName[] = "checkSelected";
char ZAF_FARDATA ZafButton::radioName[] = "radio";
char ZAF_FARDATA ZafButton::radioSelectedName[] = "radioSelected";

ZafBitmapData *ZafButton::checkBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafButton::checkSelectedBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafButton::radioBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafButton::radioSelectedBitmap = ZAF_NULLP(ZafBitmapData);

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafButton::defaultEventMap[] =
{
	{ L_NONE, 0, 0, 0 }
};
ZafPaletteMap ZAF_FARDATA ZafButton::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafButton::defaultEventMap[] =
{
	{ L_NONE, 0, 0, 0 }
};
ZafPaletteMap ZAF_FARDATA ZafButton::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_LIGHTGRAY, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_COMBO_BOX_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafComboBox::classID = ID_ZAF_COMBO_BOX;
ZafClassNameChar ZAF_FARDATA ZafComboBox::className[] = ZAF_ITEXT("ZafComboBox");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafComboBox::defaultEventMap[] =
{
	{ L_NONE, 0, 0, 0 }
};
ZafPaletteMap ZAF_FARDATA ZafComboBox::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafComboBox::defaultEventMap[] =
{
	{ L_NONE, 0, 0, 0 }
};
ZafPaletteMap ZAF_FARDATA ZafComboBox::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_DATE_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafDate::classID = ID_ZAF_DATE;
ZafClassNameChar ZAF_FARDATA ZafDate::className[] = ZAF_ITEXT("ZafDate");
ZafLanguageData *ZafDate::errorStrings = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_FORMATTED_STRING_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafFormattedString::classID = ID_ZAF_FORMATTED_STRING;
ZafClassNameChar ZAF_FARDATA ZafFormattedString::className[] = ZAF_ITEXT("ZafFormattedString");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafFormattedString::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafFormattedString::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_GROUP_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafGroup::classID = ID_ZAF_GROUP;
ZafClassNameChar ZAF_FARDATA ZafGroup::className[] = ZAF_ITEXT("ZafGroup");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafGroup::defaultEventMap[] =
{
	{ L_NONE, 0, 0, 0 }
};
ZafPaletteMap ZAF_FARDATA ZafGroup::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafGroup::defaultEventMap[] =
{
	{ L_NONE,	0,	0,	0 }
};
ZafPaletteMap ZAF_FARDATA ZafGroup::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_PARENT, ZAF_MONO_NULL, ZAF_MONO_PARENT, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_HZ_LIST_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafHzList::classID = ID_ZAF_HZ_LIST;
ZafClassNameChar ZAF_FARDATA ZafHzList::className[] = ZAF_ITEXT("ZafHzList");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafHzList::defaultEventMap[] =
{
	{ L_DOWN,	E_KEY,	GRAY_DOWN_ARROW,	S_KEYDOWN },
	{ L_DOWN,	E_KEY,	WHITE_DOWN_ARROW,	S_KEYDOWN },
	{ L_FIRST,	E_KEY,	GRAY_HOME,			S_KEYDOWN },
	{ L_FIRST,	E_KEY,	WHITE_HOME,			S_KEYDOWN },
	{ L_LAST, 	E_KEY, 	GRAY_END, 			S_KEYDOWN },
	{ L_LAST, 	E_KEY, 	WHITE_END, 			S_KEYDOWN },
	{ L_PGDN, 	E_KEY, 	GRAY_PGDN, 			S_KEYDOWN },
	{ L_PGDN, 	E_KEY, 	WHITE_PGDN, 		S_KEYDOWN },
	{ L_PGUP, 	E_KEY, 	GRAY_PGUP, 			S_KEYDOWN },
	{ L_PGUP, 	E_KEY, 	WHITE_PGUP, 		S_KEYDOWN },
	{ L_RIGHT,	E_KEY,	GRAY_RIGHT_ARROW,	S_KEYDOWN },
	{ L_RIGHT,	E_KEY,	WHITE_RIGHT_ARROW,	S_KEYDOWN },
	{ L_UP,		E_KEY,	GRAY_UP_ARROW,		S_KEYDOWN },
	{ L_UP,		E_KEY,	WHITE_UP_ARROW,		S_KEYDOWN },
	{ L_NONE,	0,		0,					0 }
};
ZafPaletteMap ZAF_FARDATA ZafHzList::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafHzList::defaultEventMap[] =
{
	{ L_FIRST,		E_KEY,	GRAY_HOME,	S_KEYDOWN },
	{ L_LAST,		E_KEY,	GRAY_END,	S_KEYDOWN },
	{ S_UNKNOWN,	E_KEY, 	ENTER,		S_KEYDOWN },
	{ L_NONE,		0,		0,			0 }
};
ZafPaletteMap ZAF_FARDATA ZafHzList::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_SELECTED, { ZAF_LINE_NULL, ZAF_PTN_DEFAULT, ZAF_CLR_NULL, ZAF_CLR_BLUE, ZAF_MONO_NULL, ZAF_MONO_BLACK, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_SELECTED, { ZAF_LINE_NULL, ZAF_PTN_DEFAULT, ZAF_CLR_BLACK, ZAF_CLR_BLUE, ZAF_MONO_WHITE, ZAF_MONO_BLACK, ZAF_FNT_DIALOG, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_ICON_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafIcon::classID = ID_ZAF_ICON;
ZafClassNameChar ZAF_FARDATA ZafIcon::className[] = ZAF_ITEXT("ZafIcon");

ZafStringIDChar ZAF_FARDATA ZafIcon::applicationName[] = ZAF_ITEXT("APPLICATION");
ZafStringIDChar ZAF_FARDATA ZafIcon::asteriskName[] = ZAF_ITEXT("ASTERISK");
ZafStringIDChar ZAF_FARDATA ZafIcon::exclamationName[] = ZAF_ITEXT("EXCLAMATION");
ZafStringIDChar ZAF_FARDATA ZafIcon::handName[] = ZAF_ITEXT("HAND");
ZafStringIDChar ZAF_FARDATA ZafIcon::questionName[] = ZAF_ITEXT("QUESTION");
ZafIconData **ZafIcon::imageTable = ZAF_NULLP(ZafIconData *);

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafIcon::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafIcon::defaultPaletteMap[] =
{
	{ ZAF_PM_TEXT, ZAF_PM_CURRENT, { ZAF_LINE_NULL, ZAF_PTN_DEFAULT, ZAF_CLR_BLACK, ZAF_CLR_BLUE, ZAF_MONO_WHITE, ZAF_MONO_BLACK, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_DISABLED, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_DARKGRAY, ZAF_CLR_PARENT, ZAF_MONO_BLACK, ZAF_MONO_PARENT, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_PARENT, ZAF_MONO_BLACK, ZAF_MONO_PARENT, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_IMAGE_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafImage::classID = ID_ZAF_IMAGE;
ZafClassNameChar ZAF_FARDATA ZafImage::className[] = ZAF_ITEXT("ZafImage");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafImage::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafImage::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_INTEGER_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafInteger::classID = ID_ZAF_INTEGER;
ZafClassNameChar ZAF_FARDATA ZafInteger::className[] = ZAF_ITEXT("ZafInteger");
ZafLanguageData *ZafInteger::errorStrings = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_MAXIMIZE_BUTTON_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafMaximizeButton::classID = ID_ZAF_MAXIMIZE_BUTTON;
ZafClassNameChar ZAF_FARDATA ZafMaximizeButton::className[] = ZAF_ITEXT("ZafMaximizeButton");

char ZafMaximizeButton::maxName[] = "max";
char ZAF_FARDATA ZafMaximizeButton::maxDepressedName[] = "maxDepressed";
char ZAF_FARDATA ZafMaximizeButton::maximizedName[] = "maximized";
char ZAF_FARDATA ZafMaximizeButton::maximizedDepressedName[] = "maximizedDepressed";

ZafBitmapData *ZafMaximizeButton::maxBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafMaximizeButton::maxDepressedBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafMaximizeButton::maximizedBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafMaximizeButton::maximizedDepressedBitmap = ZAF_NULLP(ZafBitmapData);

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafMaximizeButton::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ACTIVE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIACTIVE, ZAF_CLR_MDIACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIINACTIVE, ZAF_CLR_MDIINACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_LIGHT_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_WHITE, ZAF_CLR_WHITE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_DARK_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DARKGRAY, ZAF_CLR_DARKGRAY, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafMaximizeButton::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_MINIMIZE_BUTTON_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafMinimizeButton::classID = ID_ZAF_MINIMIZE_BUTTON;
ZafClassNameChar ZAF_FARDATA ZafMinimizeButton::className[] = ZAF_ITEXT("ZafMinimizeButton");

char ZafMinimizeButton::minName[] = "min";
char ZAF_FARDATA ZafMinimizeButton::minDepressedName[] = "minDepressed";

ZafBitmapData *ZafMinimizeButton::minBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafMinimizeButton::minDepressedBitmap = ZAF_NULLP(ZafBitmapData);

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafMinimizeButton::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ACTIVE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIACTIVE, ZAF_CLR_MDIACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIINACTIVE, ZAF_CLR_MDIINACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_LIGHT_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_WHITE, ZAF_CLR_WHITE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_DARK_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DARKGRAY, ZAF_CLR_DARKGRAY, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafMinimizeButton::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_NOTEBOOK_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafNotebook::classID = ID_ZAF_NOTEBOOK;
ZafClassNameChar ZAF_FARDATA ZafNotebook::className[] = ZAF_ITEXT("ZafNotebook");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafNotebook::defaultEventMap[] =
{
	{ L_FIRST,	E_KEY,	GRAY_HOME,	S_KEYDOWN | S_CTRL },
	{ L_FIRST,	E_KEY,	WHITE_HOME,	S_KEYDOWN | S_CTRL },
	{ L_LAST, 	E_KEY, 	GRAY_END, 	S_KEYDOWN | S_CTRL },
	{ L_LAST, 	E_KEY, 	WHITE_END, 	S_KEYDOWN | S_CTRL },
	{ L_PGUP, 	E_KEY, 	GRAY_PGUP, 	S_KEYDOWN | S_CTRL },
	{ L_PGUP, 	E_KEY, 	WHITE_PGUP, S_KEYDOWN | S_CTRL },
	{ L_PGDN, 	E_KEY, 	GRAY_PGDN,	S_KEYDOWN | S_CTRL },
	{ L_PGDN, 	E_KEY, 	WHITE_PGDN, S_KEYDOWN | S_CTRL },
	{ L_NONE, 	0, 		0, 			0 }
};
ZafPaletteMap ZAF_FARDATA ZafNotebook::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafNotebook::defaultEventMap[] =
{
	{ L_NONE, 0, 0, 0 }
};
ZafPaletteMap ZAF_FARDATA ZafNotebook::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_LIGHTGRAY, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_LIGHTGRAY, ZAF_MONO_BLACK, ZAF_MONO_WHITE, ZAF_FNT_DIALOG, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};

int ZafNotebookTab::chisel = 3;
char ZafNotebookScrollArrows::scrollLeftArrowName[] = "scrollLeftArrow";
char ZafNotebookScrollArrows::scrollRightArrowName[] = "scrollRightArrow";
ZafBitmapData *ZafNotebookScrollArrows::scrollLeftArrowBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafNotebookScrollArrows::scrollRightArrowBitmap = ZAF_NULLP(ZafBitmapData);
#endif
#endif

#if defined(ZAF_POPUP_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafPopUpItem::classID = ID_ZAF_POP_UP_ITEM;
ZafClassNameChar ZAF_FARDATA ZafPopUpItem::className[] = ZAF_ITEXT("ZafPopUpItem");
ZafClassID ZafPopUpMenu::classID = ID_ZAF_POP_UP_MENU;
ZafClassNameChar ZAF_FARDATA ZafPopUpMenu::className[] = ZAF_ITEXT("ZafPopUpMenu");

char ZAF_FARDATA ZafPopUpItem::popupArrowName[] = "popupArrow";
char ZAF_FARDATA ZafPopUpItem::popupArrowCurrentName[] = "popupArrowCurrent";
char ZAF_FARDATA ZafPopUpItem::popupCheckName[] = "popupCheck";
char ZAF_FARDATA ZafPopUpItem::popupCheckCurrentName[] = "popupCheckCurrent";

ZafBitmapData *ZafPopUpItem::popupArrowBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafPopUpItem::popupArrowCurrentBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafPopUpItem::popupCheckBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafPopUpItem::popupCheckCurrentBitmap = ZAF_NULLP(ZafBitmapData);

ZafLanguageData *ZafPopUpItem::language = ZAF_NULLP(ZafLanguageData);

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafPopUpItem::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafPopUpItem::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_PROMPT_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafPrompt::classID = ID_ZAF_PROMPT;
ZafClassNameChar ZAF_FARDATA ZafPrompt::className[] = ZAF_ITEXT("ZafPrompt");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafPrompt::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafPrompt::defaultPaletteMap[] =
{
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_PARENT, ZAF_MONO_BLACK, ZAF_MONO_PARENT, ZAF_FNT_DIALOG, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_PROGRESS_BAR_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafProgressBar::classID = ID_ZAF_PROGRESS_BAR;
ZafClassNameChar ZAF_FARDATA ZafProgressBar::className[] = ZAF_ITEXT("ZafProgressBar");

ZafPaletteMap ZAF_FARDATA ZafProgressBar::defaultPaletteMap[] =
{
#	if defined(ZAF_MOTIF)
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
#	else
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_WHITE, ZAF_CLR_WHITE, ZAF_MONO_WHITE, ZAF_MONO_WHITE, ZAF_FNT_DIALOG } },
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLUE, ZAF_CLR_BLUE, ZAF_MONO_BLACK, ZAF_MONO_BLACK, ZAF_FNT_DIALOG } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0 } }
#	endif
};
#endif

#if defined(ZAF_PULLDOWN_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafPullDownItem::classID = ID_ZAF_PULL_DOWN_ITEM;
ZafClassNameChar ZAF_FARDATA ZafPullDownItem::className[] = ZAF_ITEXT("ZafPullDownItem");
ZafClassID ZafPullDownMenu::classID = ID_ZAF_PULL_DOWN_MENU;
ZafClassNameChar ZAF_FARDATA ZafPullDownMenu::className[] = ZAF_ITEXT("ZafPullDownMenu");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafPullDownItem::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafPullDownItem::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_REAL_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafReal::classID = ID_ZAF_REAL;
ZafClassNameChar ZAF_FARDATA ZafReal::className[] = ZAF_ITEXT("ZafReal");

ZafLanguageData *ZafReal::errorStrings = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_SCROLL_BAR_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafScrollBar::classID = ID_ZAF_SCROLL_BAR;
ZafClassNameChar ZAF_FARDATA ZafScrollBar::className[] = ZAF_ITEXT("ZafScrollBar");

ZafNumberID ZafScrollBar::vNumberID = ZAF_NUMID_VT_SCROLL;
ZafStringID ZafScrollBar::vStringID = ZAF_ITEXT("ZAF_VERTICAL_SCROLL");
ZafNumberID ZafScrollBar::hNumberID = ZAF_NUMID_HZ_SCROLL;
ZafStringID ZafScrollBar::hStringID = ZAF_ITEXT("ZAF_HORIZONTAL_SCROLL");
ZafNumberID ZafScrollBar::cNumberID = ZAF_NUMID_C_SCROLL;
ZafStringID ZafScrollBar::cStringID = ZAF_ITEXT("ZAF_CORNER_SCROLL");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafScrollBar::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafScrollBar::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_SPIN_CONTROL_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafSpinControl::classID = ID_ZAF_SPIN_CONTROL;
ZafClassNameChar ZAF_FARDATA ZafSpinControl::className[] = ZAF_ITEXT("ZafSpinControl");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafSpinControl::defaultEventMap[] =
{
	{ L_DOWN,		E_KEY,		GRAY_DOWN_ARROW,	S_KEYDOWN },
	{ L_DOWN,		E_KEY,		WHITE_DOWN_ARROW,	S_KEYDOWN },
	{ L_UP,			E_KEY,		GRAY_UP_ARROW,		S_KEYDOWN },
	{ L_UP,			E_KEY,		WHITE_UP_ARROW,		S_KEYDOWN },
	{ L_NONE, 		0, 			0, 					0 }
};
ZafPaletteMap ZAF_FARDATA ZafSpinControl::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafSpinControl::defaultEventMap[] =
{
	{ L_UP,		E_KEY,	GRAY_UP_ARROW,		S_KEYDOWN },
	{ L_DOWN,	E_KEY,	GRAY_DOWN_ARROW,	S_KEYDOWN },
	{ L_NONE,	0,		0,					0 }
};
ZafPaletteMap ZAF_FARDATA ZafSpinControl::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_PARENT, ZAF_MONO_NULL, ZAF_MONO_PARENT, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_STATUS_BAR_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafStatusBar::classID = ID_ZAF_STATUS_BAR;
ZafClassNameChar ZAF_FARDATA ZafStatusBar::className[] = ZAF_ITEXT("ZafStatusBar");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafStatusBar::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafStatusBar::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_NULL, ZAF_CLR_NULL, ZAF_CLR_LIGHTGRAY, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_LIGHTGRAY, ZAF_MONO_BLACK, ZAF_MONO_WHITE, ZAF_FNT_DIALOG, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_STRING_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafString::classID = ID_ZAF_STRING;
ZafClassNameChar ZAF_FARDATA ZafString::className[] = ZAF_ITEXT("ZafString");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafString::defaultEventMap[] =
{
	{ L_BACKSPACE,	E_KEY,	BACKSPACE,			S_KEYDOWN },
	{ L_BOL,		E_KEY,	GRAY_HOME,			S_KEYDOWN },
	{ L_BOL,		E_KEY,	WHITE_HOME,			S_KEYDOWN },
	{ L_COPY,		E_KEY,	XK_F16,				S_KEYDOWN },
	{ L_CUT,		E_KEY,	XK_F20,				S_KEYDOWN },
	{ L_DELETE,		E_KEY,	GRAY_DELETE,		S_KEYDOWN },
	{ L_DELETE,		E_KEY,	WHITE_DELETE,		S_KEYDOWN },
	{ L_EOL,		E_KEY,	GRAY_END,			S_KEYDOWN },
	{ L_EOL,		E_KEY,	WHITE_END,			S_KEYDOWN },
	{ L_LEFT,		E_KEY, 	GRAY_LEFT_ARROW,	S_KEYDOWN },
	{ L_LEFT,		E_KEY, 	WHITE_LEFT_ARROW,	S_KEYDOWN },
	{ L_PASTE,		E_KEY, 	XK_F18, 			S_KEYDOWN },
	{ L_RIGHT,		E_KEY, 	GRAY_RIGHT_ARROW, 	S_KEYDOWN },
	{ L_RIGHT,		E_KEY, 	WHITE_RIGHT_ARROW,	S_KEYDOWN },
	{ L_NONE, 		0, 		0, 					0 }
};
ZafPaletteMap ZAF_FARDATA ZafString::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafString::defaultEventMap[] =
{
	{ L_SELECT,		E_KEY, 	ENTER,				S_KEYDOWN },
	{ L_BACKSPACE,	E_KEY, 	BACKSPACE,			S_KEYDOWN },
	{ L_DELETE,		E_KEY, 	GRAY_DELETE,		S_KEYDOWN },
	{ L_BOL,		E_KEY,	GRAY_HOME,			S_KEYDOWN },
	{ L_EOL,		E_KEY,	GRAY_END,			S_KEYDOWN },
	{ L_COPY,		E_KEY,	WHITE_C,			S_CMD | S_KEYDOWN },
	{ L_CUT,		E_KEY,	WHITE_X,			S_CMD | S_KEYDOWN },
	{ L_PASTE,		E_KEY,	WHITE_V,			S_CMD | S_KEYDOWN },
	{ L_WORD_LEFT,	E_KEY,	GRAY_LEFT_ARROW,	S_OPT | S_KEYDOWN },
	{ L_WORD_RIGHT,	E_KEY,	GRAY_RIGHT_ARROW,	S_OPT | S_KEYDOWN },
	{ L_NONE,		0,		0,					0 }
};
ZafPaletteMap ZAF_FARDATA ZafString::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_SYSTEM_BUTTON_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafSystemButton::classID = ID_ZAF_SYSTEM_BUTTON;
ZafClassNameChar ZAF_FARDATA ZafSystemButton::className[] = ZAF_ITEXT("ZafSystemButton");

char ZafSystemButton::sysName[] = "sys";
ZafBitmapData *ZafSystemButton::sysBitmap = ZAF_NULLP(ZafBitmapData);
ZafLanguageData *ZafSystemButton::language = ZAF_NULLP(ZafLanguageData);

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafSystemButton::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ACTIVE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIACTIVE, ZAF_CLR_MDIACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIINACTIVE, ZAF_CLR_MDIINACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_LIGHT_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_WHITE, ZAF_CLR_WHITE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_DARK_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DARKGRAY, ZAF_CLR_DARKGRAY, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafSystemButton::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_TABLE_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafTable::classID = ID_ZAF_TABLE;
ZafClassNameChar ZAF_FARDATA ZafTable::className[] = ZAF_ITEXT("ZafTable");
ZafClassID ZafTableHeader::classID = ID_ZAF_TABLE_HEADER;
ZafClassNameChar ZAF_FARDATA ZafTableHeader::className[] = ZAF_ITEXT("ZafTableHeader");
ZafClassID ZafTableRecord::classID = ID_ZAF_TABLE_RECORD;
ZafClassNameChar ZAF_FARDATA ZafTableRecord::className[] = ZAF_ITEXT("ZafTableRecord");

#if defined(ZAF_MOTIF) || defined(ZAF_MSWINDOWS)
ZafEventMap ZAF_FARDATA ZafTable::defaultEventMap[] =
{
	{ L_SELECT,		E_KEY, 		ENTER,				S_KEYDOWN },
	{ L_DOWN,		E_KEY,		GRAY_DOWN_ARROW,	S_KEYDOWN },
	{ L_DOWN,		E_KEY,		WHITE_DOWN_ARROW,	S_KEYDOWN },
	{ L_FIRST,		E_KEY,		GRAY_HOME,			S_KEYDOWN | S_CTRL },
	{ L_FIRST,		E_KEY,		WHITE_HOME,			S_KEYDOWN | S_CTRL },
	{ L_BOL,		E_KEY,		GRAY_HOME,			S_KEYDOWN },
	{ L_BOL,		E_KEY,		WHITE_HOME,			S_KEYDOWN },
	{ L_LAST, 		E_KEY, 		GRAY_END, 			S_KEYDOWN | S_CTRL },
	{ L_LAST, 		E_KEY, 		WHITE_END, 			S_KEYDOWN | S_CTRL },
	{ L_EOL, 		E_KEY, 		GRAY_END, 			S_KEYDOWN },
	{ L_EOL, 		E_KEY, 		WHITE_END, 			S_KEYDOWN },
	{ L_LEFT,		E_KEY,		GRAY_LEFT_ARROW,	S_KEYDOWN },
	{ L_LEFT,		E_KEY,		WHITE_LEFT_ARROW,	S_KEYDOWN },
	{ L_PGDN, 		E_KEY, 		GRAY_PGDN, 			S_KEYDOWN },
	{ L_PGDN, 		E_KEY, 		WHITE_PGDN, 		S_KEYDOWN },
	{ L_PGUP, 		E_KEY, 		GRAY_PGUP, 			S_KEYDOWN },
	{ L_PGUP, 		E_KEY, 		WHITE_PGUP, 		S_KEYDOWN },
	{ L_RIGHT,		E_KEY,		GRAY_RIGHT_ARROW,	S_KEYDOWN },
	{ L_RIGHT,		E_KEY,		WHITE_RIGHT_ARROW,	S_KEYDOWN },
	{ L_UP,			E_KEY,		GRAY_UP_ARROW,		S_KEYDOWN },
	{ L_UP,			E_KEY,		WHITE_UP_ARROW,		S_KEYDOWN },
	{ L_NEXT, 		E_KEY,		TAB, 				S_KEYDOWN | S_CTRL },
	{ L_PREVIOUS, 	E_KEY,		TAB, 				S_KEYDOWN | S_CTRL | S_SHIFT },
	{ L_NONE, 		0, 			0, 					0 }
};

ZafPaletteMap ZAF_FARDATA ZafTable::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};

ZafPaletteMap ZAF_FARDATA ZafTableHeader::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafTable::defaultEventMap[] =
{
	{ L_NONE,	0,	0,	0 }
};
ZafPaletteMap ZAF_FARDATA ZafTable::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};

ZafPaletteMap ZAF_FARDATA ZafTableHeader::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_LIGHTGRAY, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_LIGHTGRAY, ZAF_MONO_BLACK, ZAF_MONO_WHITE, ZAF_FNT_DIALOG, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_TEXT_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafText::classID = ID_ZAF_TEXT;
ZafClassNameChar ZAF_FARDATA ZafText::className[] = ZAF_ITEXT("ZafText");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafText::defaultEventMap[] =
{
	{ L_BACKSPACE,	E_KEY,	BACKSPACE,			S_KEYDOWN },
	{ L_BOL,		E_KEY,	GRAY_HOME,			S_KEYDOWN },
	{ L_BOL,		E_KEY,	WHITE_HOME,			S_KEYDOWN },
	{ L_COPY,		E_KEY,	XK_F16,				S_KEYDOWN },
	{ L_CUT,		E_KEY,	XK_F20,				S_KEYDOWN },
	{ L_DELETE,		E_KEY,	GRAY_DELETE,		S_KEYDOWN },
	{ L_DELETE,		E_KEY,	WHITE_DELETE,		S_KEYDOWN },
	{ L_DOWN,		E_KEY,	GRAY_DOWN_ARROW,	S_KEYDOWN },
	{ L_DOWN,		E_KEY,	WHITE_DOWN_ARROW,	S_KEYDOWN },
	{ L_EOL,		E_KEY,	GRAY_END,			S_KEYDOWN },
	{ L_EOL,		E_KEY,	WHITE_END,			S_KEYDOWN },
	{ L_LEFT,		E_KEY, 	GRAY_LEFT_ARROW,	S_KEYDOWN },
	{ L_LEFT,		E_KEY, 	WHITE_LEFT_ARROW,	S_KEYDOWN },
	{ L_PASTE,		E_KEY, 	XK_F18, 			S_KEYDOWN },
	{ L_PGDN, 		E_KEY, 	GRAY_PGDN, 			S_KEYDOWN },
	{ L_PGDN, 		E_KEY, 	WHITE_PGDN, 		S_KEYDOWN },
	{ L_PGUP, 		E_KEY, 	GRAY_PGUP, 			S_KEYDOWN },
	{ L_PGUP, 		E_KEY, 	WHITE_PGUP, 		S_KEYDOWN },
	{ L_RIGHT,		E_KEY, 	GRAY_RIGHT_ARROW, 	S_KEYDOWN },
	{ L_RIGHT,		E_KEY, 	WHITE_RIGHT_ARROW,	S_KEYDOWN },
	{ L_UP,			E_KEY, 	GRAY_UP_ARROW, 		S_KEYDOWN },
	{ L_UP,			E_KEY, 	WHITE_UP_ARROW,		S_KEYDOWN },
	{ L_NONE, 		0, 		0, 					0 }
};
ZafPaletteMap ZAF_FARDATA ZafText::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafText::defaultEventMap[] =
{
	{ L_SELECT,		E_KEY, 	ENTER,				S_KEYDOWN },
	{ L_BACKSPACE,	E_KEY, 	BACKSPACE,			S_KEYDOWN },
	{ L_DELETE,		E_KEY, 	GRAY_DELETE,		S_KEYDOWN },
	{ L_BOL,		E_KEY,	GRAY_HOME,			S_KEYDOWN },
	{ L_EOL,		E_KEY,	GRAY_END,			S_KEYDOWN },
	{ L_COPY,		E_KEY,	WHITE_C,			S_CMD | S_KEYDOWN },
	{ L_CUT,		E_KEY,	WHITE_X,			S_CMD | S_KEYDOWN },
	{ L_PASTE,		E_KEY,	WHITE_V,			S_CMD | S_KEYDOWN },
	{ L_WORD_LEFT,	E_KEY,	GRAY_LEFT_ARROW,	S_OPT | S_KEYDOWN },
	{ L_WORD_RIGHT,	E_KEY,	GRAY_RIGHT_ARROW,	S_OPT | S_KEYDOWN },
	{ L_NONE,		0,		0,					0 }
};
ZafPaletteMap ZAF_FARDATA ZafText::defaultPaletteMap[] =
{
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_WHITE, ZAF_MONO_BLACK, ZAF_MONO_WHITE, ZAF_FNT_APPLICATION, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_TIME_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafTime::classID = ID_ZAF_TIME;
ZafClassNameChar ZAF_FARDATA ZafTime::className[] = ZAF_ITEXT("ZafTime");

ZafLanguageData *ZafTime::errorStrings = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_TITLE_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafTitle::classID = ID_ZAF_TITLE;
ZafClassNameChar ZAF_FARDATA ZafTitle::className[] = ZAF_ITEXT("ZafTitle");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafTitle::defaultPaletteMap[] =
{
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_APPLICATION } },
	{ ZAF_PM_BACKGROUND, ZAF_PM_ACTIVE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIACTIVE, ZAF_CLR_MDIACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_MDIINACTIVE, ZAF_CLR_MDIINACTIVE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_LIGHT_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_WHITE, ZAF_CLR_WHITE, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_DARK_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DARKGRAY, ZAF_CLR_DARKGRAY, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } },
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafTitle::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_TOOL_BAR_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafToolBar::classID = ID_ZAF_TOOL_BAR;
ZafClassNameChar ZAF_FARDATA ZafToolBar::className[] = ZAF_ITEXT("ZafToolBar");

#if defined(ZAF_MOTIF)
ZafPaletteMap ZAF_FARDATA ZafToolBar::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafPaletteMap ZAF_FARDATA ZafToolBar::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_NULL, ZAF_CLR_NULL, ZAF_CLR_LIGHTGRAY, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_TREE_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafTreeItem::classID = ID_ZAF_TREE_ITEM;
ZafClassNameChar ZAF_FARDATA ZafTreeItem::className[] = ZAF_ITEXT("ZafTreeItem");
ZafClassID ZafTreeList::classID = ID_ZAF_TREE_LIST;
ZafClassNameChar ZAF_FARDATA ZafTreeList::className[] = ZAF_ITEXT("ZafTreeList");

char ZAF_FARDATA ZafTreeItem::expandName[] = "expand";
char ZAF_FARDATA ZafTreeItem::compressName[] = "compress";

ZafBitmapData *ZafTreeItem::expandBitmap = ZAF_NULLP(ZafBitmapData);
ZafBitmapData *ZafTreeItem::compressBitmap = ZAF_NULLP(ZafBitmapData);

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafTreeList::defaultEventMap[] =
{
	{ L_DOWN,	E_KEY,	GRAY_DOWN_ARROW,	S_KEYDOWN },
	{ L_DOWN,	E_KEY,	WHITE_DOWN_ARROW,	S_KEYDOWN },
	{ L_FIRST,	E_KEY,	GRAY_HOME,			S_KEYDOWN },
	{ L_FIRST,	E_KEY,	WHITE_HOME,			S_KEYDOWN },
	{ L_LAST, 	E_KEY, 	GRAY_END, 			S_KEYDOWN },
	{ L_LAST, 	E_KEY, 	WHITE_END, 			S_KEYDOWN },
	{ L_PGDN, 	E_KEY, 	GRAY_PGDN, 			S_KEYDOWN },
	{ L_PGDN, 	E_KEY, 	WHITE_PGDN, 		S_KEYDOWN },
	{ L_PGUP, 	E_KEY, 	GRAY_PGUP, 			S_KEYDOWN },
	{ L_PGUP, 	E_KEY, 	WHITE_PGUP, 		S_KEYDOWN },
	{ L_UP,		E_KEY,	GRAY_UP_ARROW,		S_KEYDOWN },
	{ L_UP,		E_KEY,	WHITE_UP_ARROW,		S_KEYDOWN },
	{ L_NONE, 	0, 		0, 					0 }
};
ZafPaletteMap ZAF_FARDATA ZafTreeList::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};

ZafPaletteMap ZAF_FARDATA ZafTreeItem::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafTreeList::defaultEventMap[] =
{
	{ L_FIRST,	E_KEY,	GRAY_HOME,	S_KEYDOWN },
	{ L_LAST,	E_KEY,	GRAY_END,	S_KEYDOWN },
	{ L_PGDN,	E_KEY,	GRAY_PGDN,	S_KEYDOWN },
	{ L_PGUP,	E_KEY,	GRAY_PGUP,	S_KEYDOWN },
	{ L_NONE,	0,		0,			0 }
};
ZafPaletteMap ZAF_FARDATA ZafTreeList::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_WHITE, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_CURRENT, { ZAF_LINE_NULL, ZAF_PTN_DEFAULT, ZAF_CLR_BLACK, ZAF_CLR_BLUE, ZAF_MONO_WHITE, ZAF_MONO_BLACK, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_DISABLED, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_DARKGRAY, ZAF_CLR_PARENT, ZAF_MONO_BLACK, ZAF_MONO_PARENT, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_PARENT, ZAF_MONO_BLACK, ZAF_MONO_PARENT, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};

ZafPaletteMap ZAF_FARDATA ZafTreeItem::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_WHITE, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_CURRENT, { ZAF_LINE_NULL, ZAF_PTN_DEFAULT, ZAF_CLR_BLACK, ZAF_CLR_BLUE, ZAF_MONO_WHITE, ZAF_MONO_BLACK, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_DISABLED, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_DARKGRAY, ZAF_CLR_PARENT, ZAF_MONO_BLACK, ZAF_MONO_PARENT, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_PARENT, ZAF_MONO_BLACK, ZAF_MONO_PARENT, ZAF_FNT_SMALL, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_UTIME_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafUTime::classID = ID_ZAF_UTIME;
ZafClassNameChar ZAF_FARDATA ZafUTime::className[] = ZAF_ITEXT("ZafUTime");

ZafLanguageData *ZafUTime::errorStrings = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_VT_LIST_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafVtList::classID = ID_ZAF_VT_LIST;
ZafClassNameChar ZAF_FARDATA ZafVtList::className[] = ZAF_ITEXT("ZafVtList");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafVtList::defaultEventMap[] =
{
	{ L_SELECT,	E_KEY,	SPACE,				S_KEYDOWN },
	{ L_CANCEL,	E_KEY,	ESCAPE,				S_KEYDOWN },
	{ L_DOWN,	E_KEY,	GRAY_DOWN_ARROW,	S_KEYDOWN },
	{ L_DOWN,	E_KEY,	WHITE_DOWN_ARROW,	S_KEYDOWN },
	{ L_FIRST,	E_KEY,	GRAY_HOME,			S_KEYDOWN },
	{ L_FIRST,	E_KEY,	WHITE_HOME,			S_KEYDOWN },
	{ L_LAST, 	E_KEY, 	GRAY_END, 			S_KEYDOWN },
	{ L_LAST, 	E_KEY, 	WHITE_END, 			S_KEYDOWN },
	{ L_PGDN, 	E_KEY, 	GRAY_PGDN, 			S_KEYDOWN },
	{ L_PGDN, 	E_KEY, 	WHITE_PGDN, 		S_KEYDOWN },
	{ L_PGUP, 	E_KEY, 	GRAY_PGUP, 			S_KEYDOWN },
	{ L_PGUP, 	E_KEY, 	WHITE_PGUP, 		S_KEYDOWN },
	{ L_UP,		E_KEY,	GRAY_UP_ARROW,		S_KEYDOWN },
	{ L_UP,		E_KEY,	WHITE_UP_ARROW,		S_KEYDOWN },
	{ L_NONE,	0,		0,					0 }
};
ZafPaletteMap ZAF_FARDATA ZafVtList::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafVtList::defaultEventMap[] =
{
	{ L_FIRST,		E_KEY,	GRAY_HOME,	S_KEYDOWN },
	{ L_LAST,		E_KEY,	GRAY_END,	S_KEYDOWN },
	{ S_UNKNOWN,	E_KEY, 	ENTER,		S_KEYDOWN },
	{ L_NONE,		0,		0,			0 }
};
ZafPaletteMap ZAF_FARDATA ZafVtList::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_SELECTED, { ZAF_LINE_NULL, ZAF_PTN_DEFAULT, ZAF_CLR_NULL, ZAF_CLR_BLUE, ZAF_MONO_NULL, ZAF_MONO_BLACK, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_SELECTED, { ZAF_LINE_NULL, ZAF_PTN_DEFAULT, ZAF_CLR_BLACK, ZAF_CLR_BLUE, ZAF_MONO_WHITE, ZAF_MONO_BLACK, ZAF_FNT_DIALOG, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_WINDOW_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafWindow::classID = ID_ZAF_WINDOW;
ZafClassNameChar ZAF_FARDATA ZafWindow::className[] = ZAF_ITEXT("ZafWindow");
ZafClassID ZafWindowManager::classID = ID_ZAF_WINDOW_MANAGER;
ZafClassNameChar ZAF_FARDATA ZafWindowManager::className[] = ZAF_ITEXT("ZafWindowManager");
ZafClassID ZafWindowObject::classID = ID_ZAF_WINDOW_OBJECT;
ZafClassNameChar ZAF_FARDATA ZafWindowObject::className[] = ZAF_ITEXT("ZafWindowObject");
ZafStringID ZafWindowObject::genericFieldID = ZAF_ITEXT("FIELD_");
ZafEventManager *ZafWindowObject::eventManager = ZAF_NULLP(ZafEventManager);
ZafDisplay *ZafWindowObject::display = ZAF_NULLP(ZafDisplay);
ZafWindowManager *ZafWindowObject::windowManager = ZAF_NULLP(ZafWindowManager);

ZafWindowManager *zafWindowManager = ZAF_NULLP(ZafWindowManager);
ZafObjectPersistence *zafObjectPersistence = ZAF_NULLP(ZafObjectPersistence);

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafWindowManager::defaultEventMap[] =
{
	{ L_CLOSE,				E_KEY,	F4,		S_KEYDOWN | S_ALT },
	{ L_CLOSE_TEMPORARY,	E_KEY,	ESCAPE,	S_KEYDOWN },
//	{ L_EXIT,				E_KEY,	,		S_KEYDOWN },
	{ L_NONE,				0,		0,		0 }
};
ZafPaletteMap ZAF_FARDATA ZafWindowManager::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};

ZafEventMap ZAF_FARDATA ZafWindow::defaultEventMap[] =
{
	{ L_NEXT, 		E_KEY,	TAB, 	S_KEYDOWN },
	{ L_PREVIOUS, 	E_KEY,	TAB, 	S_KEYDOWN | S_SHIFT },
	{ L_NONE, 		0, 		0, 		0 }
};
ZafPaletteMap ZAF_FARDATA ZafWindow::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};

ZafEventMap ZAF_FARDATA ZafWindowObject::defaultEventMap[] =
{
	{ L_BEGIN_ESCAPE,		E_MOUSE,	M_RIGHT | M_RIGHT_CHANGE,					0 },
	{ L_BEGIN_SELECT,		E_MOUSE,	M_LEFT | M_LEFT_CHANGE,						0 },
	{ L_CANCEL,				E_KEY,		XK_Cancel,									S_KEYDOWN },
	{ L_CONTINUE_ESCAPE,	E_MOUSE,	M_RIGHT,									0 },
	{ L_CONTINUE_SELECT,	E_MOUSE,	M_LEFT,										0 },
	{ L_DOUBLE_CLICK,		E_MOUSE,	M_LEFT_CHANGE | S_DOUBLE_CLICK,				0 },
	{ L_END_ESCAPE,			E_MOUSE,	M_RIGHT_CHANGE,								0 },
	{ L_END_SELECT,			E_MOUSE,	M_LEFT_CHANGE,								0 },
	{ L_HELP,				E_KEY,		XK_Help,									S_KEYDOWN },
	{ L_VIEW,				E_MOUSE,	0,											0 },
	{ L_NONE, 				0, 			0, 											0 }
};
ZafPaletteMap ZAF_FARDATA ZafWindowObject::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafWindowManager::defaultEventMap[] =
{
	{ L_NONE, 0, 0, 0 }
};
ZafPaletteMap ZAF_FARDATA ZafWindowManager::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};

ZafEventMap ZAF_FARDATA ZafWindow::defaultEventMap[] =
{
	{ L_SELECT,		E_KEY,	ENTER,				S_KEYDOWN },
	{ L_SELECT,		E_KEY,	GRAY_ENTER,			S_KEYDOWN },
	{ L_PREVIOUS,	E_KEY,	TAB,				S_SHIFT | S_KEYDOWN },
	{ L_NEXT,		E_KEY,	TAB,				S_KEYDOWN },
	{ L_UP,			E_KEY,	GRAY_UP_ARROW,		S_KEYDOWN },
	{ L_DOWN,		E_KEY,	GRAY_DOWN_ARROW,	S_KEYDOWN },
	{ L_PGDN,		E_KEY,	GRAY_PGDN,			S_KEYDOWN },
	{ L_PGUP,		E_KEY,	GRAY_PGUP,			S_KEYDOWN },
	{ L_FIRST,		E_KEY,	GRAY_HOME,			S_KEYDOWN },
	{ L_LAST,		E_KEY,	GRAY_END,			S_KEYDOWN },
	{ L_NONE,		0,		0,					0 }
};
ZafPaletteMap ZAF_FARDATA ZafWindow::defaultPaletteMap[] =
{
	// ZAF_PM_BACKGROUND entry blocks the ZAF_PM_CURRENT entry in ZafWindowObject.
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_WHITE, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};

int ZafWindowObject::initialDelay = 50;
int ZafWindowObject::repeatDelay = 7;
ZafEventMap ZAF_FARDATA ZafWindowObject::defaultEventMap[] =
{
	// Mouse events.
	{ L_VIEW,				E_MOUSE,	0,						0 },
	{ L_CONTINUE_SELECT,	E_MOUSE,	M_LEFT,					0 },
	{ L_BEGIN_SELECT,		E_MOUSE,	M_LEFT | M_LEFT_CHANGE,	0 },
	{ L_END_SELECT,			E_MOUSE,	M_LEFT_CHANGE,			0 },

	// Keyboard events.
	{ L_CANCEL,				E_KEY,		ESCAPE,					S_KEYDOWN },
	{ L_UP,					E_KEY,		GRAY_UP_ARROW,			S_KEYDOWN },
	{ L_DOWN,				E_KEY,		GRAY_DOWN_ARROW,		S_KEYDOWN },
	{ L_LEFT,				E_KEY,		GRAY_LEFT_ARROW,		S_KEYDOWN },
	{ L_RIGHT,				E_KEY,		GRAY_RIGHT_ARROW,		S_KEYDOWN },
	{ L_HELP,				E_KEY,		GRAY_HELP,				S_KEYDOWN },
	{ L_HELP,				E_KEY,		WHITE_QUESTION,			S_CMD | S_KEYDOWN },
	{ L_HELP,				E_KEY,		WHITE_QUESTION,			S_CMD | S_SHIFT | S_KEYDOWN },
	{ L_NONE,				0,			0,						0 }
};
ZafPaletteMap ZAF_FARDATA ZafWindowObject::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_CURRENT, { ZAF_LINE_NULL, ZAF_PTN_DEFAULT, ZAF_CLR_NULL, ZAF_CLR_BLUE, ZAF_MONO_NULL, ZAF_MONO_BLACK, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_NULL, ZAF_CLR_WHITE, ZAF_MONO_NULL, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_FOREGROUND, ZAF_PM_DISABLED, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_DARKGRAY, ZAF_CLR_WHITE, ZAF_MONO_BLACK, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_FOREGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_NULL, ZAF_MONO_BLACK, ZAF_MONO_NULL, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_LIGHT_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_WHITE, ZAF_CLR_WHITE, ZAF_MONO_WHITE, ZAF_MONO_WHITE, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_DARK_SHADOW, ZAF_PM_ANY_STATE, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_DARKGRAY, ZAF_CLR_DARKGRAY, ZAF_MONO_BLACK, ZAF_MONO_BLACK, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_OUTLINE, ZAF_PM_DISABLED, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_DARKGRAY, ZAF_CLR_DARKGRAY, ZAF_MONO_BLACK, ZAF_MONO_BLACK, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_OUTLINE, ZAF_PM_ANY_STATE, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_BLACK, ZAF_MONO_BLACK, ZAF_MONO_BLACK, ZAF_FNT_NULL, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_DISABLED, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_DARKGRAY, ZAF_CLR_WHITE, ZAF_MONO_BLACK, ZAF_MONO_WHITE, ZAF_FNT_DIALOG, 0 } },
	{ ZAF_PM_TEXT, ZAF_PM_ANY_STATE, { ZAF_LINE_NULL, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_WHITE, ZAF_MONO_BLACK, ZAF_MONO_WHITE, ZAF_FNT_DIALOG, 0 } },
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_BLACK, ZAF_CLR_WHITE, ZAF_MONO_BLACK, ZAF_MONO_WHITE, ZAF_FNT_DIALOG, 0 } },
};
#endif
#endif

// --- Advanced Dialog windows ---
#if defined(ZAF_DIALOG_WINDOW_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafDialogWindow::classID = ID_ZAF_DIALOG_WINDOW;
ZafClassNameChar ZAF_FARDATA ZafDialogWindow::className[] = ZAF_ITEXT("ZafDialogWindow");
#endif

#if defined(ZAF_ERROR_STUB_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZAF_EXPORT ZafErrorStub *zafErrorSystem = ZAF_NULLP(ZafErrorStub);
#endif

#if defined(ZAF_ERROR_SYSTEM_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafErrorSystem::classID = ID_ZAF_ERROR_SYSTEM;
ZafClassNameChar ZAF_FARDATA ZafErrorSystem::className[] = ZAF_ITEXT("ZafErrorSystem");
ZafLanguageData *ZafErrorSystem::language = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_FILE_DIALOG_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafFileDialog::classID = ID_ZAF_FILE_DIALOG;
ZafClassNameChar ZAF_FARDATA ZafFileDialog::className[] = ZAF_ITEXT("ZafFileDialog");
ZafLanguageData *ZafFileDialog::language = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_HELP_STUB_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZAF_EXPORT ZafHelpStub *zafHelpSystem = ZAF_NULLP(ZafHelpStub);
#endif

#if defined(ZAF_HELP_SYSTEM_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafHelpSystem::classID = ID_ZAF_HELP_SYSTEM;
ZafClassNameChar ZAF_FARDATA ZafHelpSystem::className[] = ZAF_ITEXT("ZafHelpSystem");
ZafLanguageData *ZafHelpSystem::language = ZAF_NULLP(ZafLanguageData);
ZafIconData *ZafHelpSystem::helpIcon = ZAF_NULLP(ZafIconData);
#endif

#if defined(ZAF_MDI_WINDOW_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafMDIWindow::classID = ID_ZAF_MDI_WINDOW;
ZafClassNameChar ZAF_FARDATA ZafMDIWindow::className[] = ZAF_ITEXT("ZafMDIWindow");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafMDIWindow::defaultEventMap[] =
{
	{ L_MDI_NEXT_WINDOW, 	E_KEY, 	TAB,	S_KEYDOWN | S_CTRL },
	{ L_NONE, 0, 0, 0 }
};
ZafPaletteMap ZAF_FARDATA ZafMDIWindow::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafMDIWindow::defaultEventMap[] =
{
	{ L_MDI_NEXT_WINDOW,	E_KEY,	TAB,	S_OPT | S_KEYDOWN },
	{ L_NONE,				0,		0,		0 }
};
ZafPaletteMap ZAF_FARDATA ZafMDIWindow::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } }
};
#endif
#endif

#if defined(ZAF_MESSAGE_WINDOW_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafMessageWindow::classID = ID_ZAF_MESSAGE_WINDOW;
ZafClassNameChar ZAF_FARDATA ZafMessageWindow::className[] = ZAF_ITEXT("ZafMessageWindow");

ZafLanguageData *ZafMessageWindow::language = ZAF_NULLP(ZafLanguageData);
#endif

#if defined(ZAF_SCROLLED_WINDOW_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafScrolledWindow::classID = ID_ZAF_SCROLLED_WINDOW;
ZafClassNameChar ZAF_FARDATA ZafScrolledWindow::className[] = ZAF_ITEXT("ZafScrolledWindow");

#if defined(ZAF_MOTIF)
ZafEventMap ZAF_FARDATA ZafScrolledWindow::defaultEventMap[] =
{
	{ L_PGDN, 		E_KEY, 	GRAY_PGDN, 			S_KEYDOWN },
	{ L_PGDN, 		E_KEY, 	WHITE_PGDN, 		S_KEYDOWN },
	{ L_PGUP, 		E_KEY, 	GRAY_PGUP, 			S_KEYDOWN },
	{ L_PGUP, 		E_KEY, 	WHITE_PGUP, 		S_KEYDOWN },
	{ L_NONE, 		0, 		0, 					0 }
};
#elif defined(ZAF_MACINTOSH)
ZafEventMap ZAF_FARDATA ZafScrolledWindow::defaultEventMap[] =
{
	{ L_PGDN, 	E_KEY, 	GRAY_PGDN, 	S_KEYDOWN },
	{ L_PGUP, 	E_KEY, 	GRAY_PGUP, 	S_KEYDOWN },
	{ L_NONE, 	0, 		0, 			0 }
};
#endif
#endif

// --- Geometry management objects ---
#if defined(ZAF_GEOMETRY_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
ZafClassID ZafAttachment::classID = ID_ZAF_ATTACHMENT;
ZafClassNameChar ZAF_FARDATA ZafAttachment::className[] = ZAF_ITEXT("ZafAttachment");

ZafClassID ZafConstraint::classID = ID_ZAF_CONSTRAINT;
ZafClassNameChar ZAF_FARDATA ZafConstraint::className[] = ZAF_ITEXT("ZafConstraint");
ZafStringID ZafConstraint::genericConstraintID = ZAF_ITEXT("CONSTRAINT_");

ZafClassID ZafDimensionConstraint::classID = ID_ZAF_DIMENSION_CONSTRAINT;
ZafClassNameChar ZAF_FARDATA ZafDimensionConstraint::className[] = ZAF_ITEXT("ZafDimensionConstraint");

ZafClassID ZafGeometryManager::classID = ID_ZAF_GEOMETRY_MANAGER;
ZafClassNameChar ZAF_FARDATA ZafGeometryManager::className[] = ZAF_ITEXT("ZafGeometryManager");

ZafClassID ZafRelativeConstraint::classID = ID_ZAF_RELATIVE_CONSTRAINT;
ZafClassNameChar ZAF_FARDATA ZafRelativeConstraint::className[] = ZAF_ITEXT("ZafRelativeConstraint");
#endif

// --- Environment-specific ---
#if defined(ZAF_UTILS_INFO) && defined(ZAF_LOCAL_FILE_STATICS)
#if defined(ZAF_MACINTOSH)
Boolean zafColorQD = false;
Boolean zafQuickDrawGX = false;
Boolean zafDragMgr = false;
Boolean zafUsedMenuID[ZAF_LAST_MENU_ID + 1];
MenuRef zafAppleMenu = ZAF_NULLH(MenuRef);
Rect zafDropRect = { 0, 0, 0, 0 };
Str63 zafDTPName = { 0 };
ZafWindowObject *zafAppleAbout = ZAF_NULLP(ZafWindowObject);
ZafWindowObject *zafMenuBar = ZAF_NULLP(ZafWindowObject);
#endif
#endif
