# Zinc Application Framework - BORLAND.MAK
# COPYRIGHT (C) 1990-1997.  All Rights Reserved.
# Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#
# General definitions
# (ZAF_ROOT is root directory of ZAF installation)
# (DEBUG specifies whethor or not debug information is included)
#
ZAF_ROOT=..
DEBUG=off

#
# ----- Usage ---------------------------------------------------------------
#
usage:
	@type &&|

Usage:

make -f borland.mak win16      (16 bit Windows)
make -f borland.mak win32      (32 bit Windows)
make -f borland.mak win32dll   (32 bit Windows dll's)
make -f borland.mak dos16      (16 bit DOS extended)
|


#
# ----- Clean ---------------------------------------------------------------
#
clean:
	z_clean


#
# ----- Windows 16 bit ------------------------------------------------------
#
win16: zafw16 zafw16p wtest16


#
# ----- Windows 32 bit ------------------------------------------------------
#
win32: zafw32 zafw32p wtest32


#
# ----- Windows 32 bit DLL --------------------------------------------------
#
win32dll: zafw32dll zafw32d wtest


#
# ----- Targets -------------------------------------------------------------
#
!ifndef TARGET
#
# Build the current target by defining the "TARGET" macro in a recusive 
# call to make.  Then copy the target to the "lib\borland" directory.
#
zafw16:
	@echo.
	@echo making $<.lib...
	@echo.
	@$(MAKE) -f borland.mak TARGET=$<.lib $<.lib
	-@md ..\lib
	-@md ..\lib\borland
	copy $<.lib ..\lib\borland
	-@del wtest16.exe

zafw16p:
	@echo.
	@echo making $<.lib...
	@echo.
	@$(MAKE) -f borland.mak TARGET=$<.lib $<.lib
	-@md ..\lib
	-@md ..\lib\borland
	copy $<.lib ..\lib\borland

zafw32:
	@echo.
	@echo making $<.lib...
	@echo.
	@$(MAKE) -f borland.mak TARGET=$<.lib $<.lib
	-@md ..\lib
	-@md ..\lib\borland
	copy $<.lib ..\lib\borland
	-@del wtest32.exe

zafw32p:
	@echo.
	@echo making $<.lib...
	@echo.
	@$(MAKE) -f borland.mak TARGET=$<.lib $<.lib
	-@md ..\lib
	-@md ..\lib\borland
	copy $<.lib ..\lib\borland

zafw32dll:
	@echo.
	@echo making zafw32.dll...
	@echo.
	@$(MAKE) -f borland.mak TARGET=zafw32.dll zafw32.dll
	-@md ..\lib
	-@md ..\lib\borland
	copy zafw32.dll ..\lib\borland
	copy zafw32i.lib ..\lib\borland
	-@del wtest.exe

zafw32d:
	@echo.
	@echo making $<.lib...
	@echo.
	@$(MAKE) -f borland.mak TARGET=$<.lib $<.lib
	-@md ..\lib
	-@md ..\lib\borland
	copy $<.lib ..\lib\borland

wtest16:
	@echo.
	@echo making $<.exe...
	@echo.
	@$(MAKE) -f borland.mak TARGET=$<.exe $<.exe

wtest32:
	@echo.
	@echo making $<.exe...
	@echo.
	@$(MAKE) -f borland.mak TARGET=$<.exe $<.exe

wtest:
	@echo.
	@echo making $<.exe...
	@echo.
	@$(MAKE) -f borland.mak TARGET=$<.exe $<.exe


!else
#
# Define the ZAF project macros for the current target.
# (The "TARGET" macro has already been defined by a recusive call to make)
#

#
# Include the source file macros.
#
!include "zaffiles.mak"
!include "winfiles.mak"

#
# Build options for zafw16.lib
#
!if "$(TARGET)" == "zafw16.lib"
TARGET_TYPE=LIB
PLATFORM=WIN16
SOURCE_FILES=$(ZAF_SOURCE_CORE) $(ZAF_SOURCE_WINDOWS) $(ZAF_SOURCE_WINDOWS_NO_DLL)
!endif

#
# Build options for zafw16p.lib
#
!if "$(TARGET)" == "zafw16p.lib"
TARGET_TYPE=LIB
PLATFORM=WIN16
SOURCE_FILES=$(ZAF_SOURCE_PERSIST_ALL)
!endif

#
# Build options for zafw32.lib
#
!if "$(TARGET)" == "zafw32.lib"
TARGET_TYPE=LIB
PLATFORM=WIN32
SOURCE_FILES=$(ZAF_SOURCE_CORE) $(ZAF_SOURCE_WINDOWS) $(ZAF_SOURCE_WINDOWS_NO_DLL)
!endif

#
# Build options for zafw32p.lib
#
!if "$(TARGET)" == "zafw32p.lib"
TARGET_TYPE=LIB
PLATFORM=WIN32
SOURCE_FILES=$(ZAF_SOURCE_PERSIST_ALL)
!endif

#
# Build options for zafw32.dll
#
!if "$(TARGET)" == "zafw32.dll"
TARGET_TYPE=DLL
PLATFORM=WIN32
SOURCE_FILES=$(ZAF_SOURCE_CORE) $(ZAF_SOURCE_WINDOWS) $(ZAF_SOURCE_PERSIST_ALL)
DEFINITION_FILE=w32_dll.def
IMPORT_LIBRARY=zafw32i.lib
!endif

#
# Build options for zafw32d.lib
#
!if "$(TARGET)" == "zafw32d.lib"
TARGET_TYPE=LIBDLL
PLATFORM=WIN32
SOURCE_FILES=$(ZAF_SOURCE_WINDOWS_NO_DLL)
!endif

#
# Build options for wtest16.exe
#
!if "$(TARGET)" == "wtest16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=test.cpp
DEFINITION_FILE=wtest16.def
!endif

#
# Build options for wtest32.exe
#
!if "$(TARGET)" == "wtest32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=test.cpp
!endif

#
# Build options for wtest.exe
#
!if "$(TARGET)" == "wtest.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=test.cpp
!endif

#
# Build the target.
#
!include "$(ZAF_ROOT)\include\zafbor.mak"

!endif
