//	Zinc Application Framework - TREE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

// This is the bitmap to be used on closed tree items.
static ZafLogicalColor normalBitmapArray[16][16] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
};

static ZafImageStruct normalBitmapInfo = 
{
	16, 16, (ZafLogicalColor *)normalBitmapArray
};

// This is the bitmap to be used on open tree items.
static ZafLogicalColor selectedBitmapArray[16][16] =
{
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
};

static ZafImageStruct selectedBitmapInfo = 
{
	16, 16, (ZafLogicalColor *)selectedBitmapArray
};

// ----- TreeWindow ---------------------------------------------------------

class TreeWindow : public ZafWindow
{
public:
	TreeWindow(int left, int top);
	~TreeWindow(void);
	static ZafEventType Callback(ZafWindowObject *, ZafEventStruct &, ZafEventType ccode);

private:
	ZafBitmapData normalBitmapData;
	ZafBitmapData selectedBitmapData;
};

ZafEventType TreeWindow::Callback(ZafWindowObject *, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT)
		ZafErrorSystem::Beep();
	else if (ccode == L_DOUBLE_CLICK)
	{
		ZafErrorSystem::Beep();
		ZafErrorSystem::Beep();
	}
	return (0);
}

TreeWindow::TreeWindow(int left, int top) :
	ZafWindow(left, top, 50, 10),
	normalBitmapData(normalBitmapInfo),
	selectedBitmapData(selectedBitmapInfo)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("TreeWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);
	normalBitmapData.SetDestroyable(false);
	selectedBitmapData.SetDestroyable(false);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("Tree Window")));

	// Create a bordered tree list.
	ZafTreeList *treeList = new ZafTreeList(2, 1, 30, 6);
	treeList->SetBordered(true);

	// Add the expandable base tree item to the tree list.
	ZafTreeItem *baseItem = new ZafTreeItem(0, 0, new ZafStringData(ZAF_ITEXT("Base")));
	baseItem->SetExpandable(true);
	treeList->Add(baseItem);

	// Add a scroll bar to the tree list, and add the tree list to the window.
	treeList->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_VERTICAL_SCROLL));
	Add(treeList);

	// Add 10 expandable tree items to the base tree item.
	ZafIChar string[256];
	for (int i = 0; i < 10; i++)
	{
		// Add the children of the base tree item, using the static bitmaps.
		sprintf(string, ZAF_ITEXT("Item %d"), i);
		ZafTreeItem *item = new ZafTreeItem(&normalBitmapData,
			&selectedBitmapData, new ZafStringData(string));
		item->SetExpandable(true);

		// Add the children of the base tree item's children, using the
		// static bitmaps.
		for (int j = 0; j < 10; j++)
		{
			sprintf(string, ZAF_ITEXT("Sub-item %d.%d"), i, j);
			ZafTreeItem *subItem = new ZafTreeItem(&normalBitmapData,
				&selectedBitmapData, new ZafStringData(string));
			subItem->SetExpandable(true);

			// Add the children of the base tree item's children's children,
			// using the static bitmaps.
			for (int k = 0; k < 10; k++)
			{
				sprintf(string, ZAF_ITEXT("Leaf-item %d.%d.%d"), i, j, k);
				ZafTreeItem *leafItem = new ZafTreeItem(0, 0, new ZafStringData(string));
				leafItem->SetUserFunction(Callback);
				subItem->Add(leafItem);
			}
			item->Add(subItem);
		}
		baseItem->Add(item);
	}
}

TreeWindow::~TreeWindow(void)
{
	// We must specifically destroy the window's children before the static
	// iconData is destroyed (The natural call sequence order of destruction
	// is wrong).
	ZafList::Destroy();
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new TreeWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

