//	Zinc Application Framework - TEXT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

// ----- TextWindow ---------------------------------------------------------

class TextWindow : public ZafWindow
{
public:
	TextWindow(int left, int top);
};

TextWindow::TextWindow(int left, int top) :
	ZafWindow(left, top, 40, 9)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("TextWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton(ZAF_NATIVE_SYSTEM_BUTTON));
	Add(new ZafTitle(new ZafStringData("Text Window")));

	// Add a text object.
	ZafText *text = new ZafText(2, 1, 35, 6, new ZafStringData(ZAF_ITEXT("text"), 1000));
	text->SetRegionType(ZAF_AVAILABLE_REGION);
	text->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	Add(text);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new TextWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

