//	Zinc Application Framework - SYS.CPP
//	COPYRIGHT (C) 1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

// ----- SystemMenuWindow ---------------------------------------------------

class SystemMenuWindow : public ZafWindow
{
public:
	SystemMenuWindow(int left, int top);
};

SystemMenuWindow::SystemMenuWindow(int left, int top) :
	ZafWindow(left, top, 40, 7)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("SystemMenuWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);

	ZafSystemButton *sysButton = new ZafSystemButton(ZAF_EMPTY_SYSTEM_BUTTON);
	sysButton->Add(new ZafPopUpItem(ZAF_ITEXT("Item 1")));
	sysButton->Add(new ZafPopUpItem(ZAF_ITEXT("Item 2")));
	sysButton->Add(new ZafPopUpItem(ZAF_ITEXT("Item 3")));
	sysButton->Add(new ZafPopUpItem(ZAF_ITEXT("Item 4")));
	sysButton->Add(new ZafPopUpItem(ZAF_ITEXT("Item 5")));
	sysButton->Add(new ZafPopUpItem(ZAF_NULLP(ZafIChar), ZAF_SEPARATOR));
	sysButton->Add(new ZafPopUpItem(ZAF_ITEXT("Exit"), ZAF_EXIT_OPTION));
	Add(sysButton);

	Add(new ZafTitle(new ZafStringData("System Menu Window")));
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new SystemMenuWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

