//	Zinc Application Framework - STRING1.CPP
//	COPYRIGHT (C) 1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

// ----- StringWindow -------------------------------------------------------

class StringWindow : public ZafWindow
{
public:
	StringWindow(int left, int top);
};

StringWindow::StringWindow(int left, int top) :
	ZafWindow(left, top, 40, 7)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("StringWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("String Window")));

	// Add a normal string with a prompt.
	ZafPrompt *prompt = new ZafPrompt(0, 1, 11, new ZafStringData("no flags:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	ZafString *string = new ZafString(12, 1, 20, new ZafStringData("no flags", 100));
	Add(string);

	// Add a variable name string with a prompt.
	prompt = new ZafPrompt(0, 2, 11, new ZafStringData("variable:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	string = new ZafString(12, 2, 20, new ZafStringData("variable name", 100));
	string->SetVariableName(true);
	string->SetAutoClear(true);
	Add(string);

	// Add a lower-case string with a prompt.
	prompt = new ZafPrompt(0, 3, 11, new ZafStringData("lowerCase:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	string = new ZafString(12, 3, 20, new ZafStringData("lower-case", 100));
	string->SetLowerCase(true);
	Add(string);

	// Add a upper-case string with a prompt.
	prompt = new ZafPrompt(0, 4, 11, new ZafStringData("upperCase:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	string = new ZafString(12, 4, 20, new ZafStringData("upper-case", 100));
	string->SetUpperCase(true);
	Add(string);

	// Add a password string with a prompt.
	prompt = new ZafPrompt(0, 5, 11, new ZafStringData("password:"));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	string = new ZafString(12, 5, 20, new ZafStringData("password", 100));
	string->SetPassword(true);
	Add(string);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new StringWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

