//	Zinc Application Framework - MDIWIN.CPP
//	COPYRIGHT (C) 1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

static ZafUInt8 iconArray[32][32] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
};
static ZafImageStruct iconInfo = 
{
	32, 32, (ZafLogicalColor *)iconArray, true
};

// ----- MDIWindow ----------------------------------------------------------

class MDIWindow : public ZafMDIWindow
{
public:
	MDIWindow(int left, int top);
	~MDIWindow(void);

private:
	ZafIconData iconData;
};

MDIWindow::MDIWindow(int left, int top) :
	ZafMDIWindow(left, top, 50, 10, ZAF_MDI_PARENT),
	iconData(iconInfo)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("MDI Parent"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);
	iconData.SetDestroyable(false);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("MDI Parent")));

	ZafToolBar *toolBar = new ZafToolBar(0, 0, 0, 1);
	toolBar->Add(new ZafButton(0, 0, 10, 1, ZAF_ITEXT("Button")));
	Add(toolBar);

	// Add a pull-down menu.
	ZafPullDownMenu *pullDownMenu = new ZafPullDownMenu();
	ZafPullDownItem *pullDownItem = new ZafPullDownItem(ZAF_ITEXT("File"));
	pullDownMenu->Add(pullDownItem);
	Add(pullDownMenu);

	// Create an MDI child with decorations and some child objects.
	ZafMDIWindow *child1 = new ZafMDIWindow(2, 1, 40, 5, ZAF_MDI_CHILD);
	child1->Add(new ZafBorder);
	child1->Add(new ZafMaximizeButton);
	child1->Add(new ZafMinimizeButton);
	child1->Add(new ZafSystemButton);
	child1->Add(new ZafIcon(0, 0, ZAF_NULLP(ZafIChar), &iconData, ZAF_MINIMIZE_ICON));
	child1->Add(new ZafTitle(new ZafStringData("MDI Child1")));
	child1->Add(new ZafPrompt(2, 1, 8, new ZafStringData("string:")));
	child1->Add(new ZafString(10, 1, 15, new ZafStringData("string", 100)));
	child1->Add(new ZafButton(10, 3, 15, 1, new ZafStringData("button")));
	Add(child1);

	// Create an MDI child with decorations and some child objects.
	ZafMDIWindow *child2 = new ZafMDIWindow(4, 2, 40, 5, ZAF_MDI_CHILD);
	child2->Add(new ZafBorder);
	child2->Add(new ZafMaximizeButton);
	child2->Add(new ZafMinimizeButton);
	child2->Add(new ZafSystemButton);
	child2->Add(new ZafTitle(new ZafStringData("MDI Child2")));
	child2->Add(new ZafIcon(10, 0, ZAF_NULLP(ZafIChar), &iconData, ZAF_MINIMIZE_ICON));
	child2->Add(new ZafPrompt(2, 1, 8, new ZafStringData("string:")));
	child2->Add(new ZafString(10, 1, 15, new ZafStringData("string", 100)));
	child2->Add(new ZafButton(10, 3, 15, 1, new ZafStringData("button")));
	Add(child2);

	// Create an MDI child with decorations and some child objects.
	ZafMDIWindow *child3 = new ZafMDIWindow(6, 3, 40, 5, ZAF_MDI_CHILD);
	child3->Add(new ZafBorder);
	child3->Add(new ZafMaximizeButton);
	child3->Add(new ZafMinimizeButton);
	child3->Add(new ZafSystemButton);
	child3->Add(new ZafTitle(new ZafStringData("MDI Child3")));
	child3->Add(new ZafIcon(20, 0, ZAF_NULLP(ZafIChar), &iconData, ZAF_MINIMIZE_ICON));
	child3->Add(new ZafPrompt(2, 1, 8, new ZafStringData("string:")));
	child3->Add(new ZafString(10, 1, 15, new ZafStringData("string", 100)));
	child3->Add(new ZafButton(10, 3, 15, 1, new ZafStringData("button")));
	Add(child3);
}

MDIWindow::~MDIWindow(void)
{
	// We must specifically destroy the window's children before the static
	// iconData is destroyed (The natural call sequence order of destruction
	// is wrong).
	ZafList::Destroy();
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new MDIWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

